/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.vinery.client.gui.handler.FermentationBarrelGuiHandler;
import net.satisfy.vinery.core.Vinery;
import net.satisfy.vinery.platform.PlatformHelper;

@OnlyIn(value=Dist.CLIENT)
public class FermentationBarrelGui
extends AbstractContainerScreen<FermentationBarrelGuiHandler> {
    public static final ResourceLocation BACKGROUND = Vinery.identifier("textures/gui/fermentation_barrel_gui.png");
    private static final int FLUID_WIDTH = 20;
    private static final int FLUID_X = 82;
    private static final int FLUID_Y = 44;
    private static final int CRAFT_PROGRESS_TEXTURE_X = 176;
    private static final int CRAFT_PROGRESS_TEXTURE_Y = 0;
    private static final int CRAFT_PROGRESS_WIDTH = 11;
    private static final int CRAFT_PROGRESS_HEIGHT = 29;
    private static final int CRAFT_PROGRESS_GUI_X = 122;
    private static final int CRAFT_PROGRESS_GUI_Y = 20;
    private static final int CRAFT_PROGRESS_GUI_HEIGHT = 29;

    public FermentationBarrelGui(FermentationBarrelGuiHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.imageWidth = 176;
        this.imageHeight = 166;
        this.titleLabelX = 8;
        this.titleLabelY = 6;
        this.inventoryLabelX = 8;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        Component tooltip;
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.isMouseOverFluidArea(mouseX, mouseY)) {
            tooltip = this.getFluidTooltip();
            guiGraphics.renderTooltip(this.font, tooltip, mouseX, mouseY);
        }
        if (this.isMouseOverCraftingTimeArea(mouseX, mouseY)) {
            tooltip = this.getCraftingTimeTooltip();
            guiGraphics.renderTooltip(this.font, tooltip, mouseX, mouseY);
        }
    }

    private Component getFluidTooltip() {
        String juiceType = ((FermentationBarrelGuiHandler)this.menu).getJuiceType();
        int fluidLevel = ((FermentationBarrelGuiHandler)this.menu).getFluidLevel();
        int maxFluidLevel = PlatformHelper.getMaxFluidLevel();
        double percentage = (double)fluidLevel / (double)maxFluidLevel * 100.0;
        String percentageStr = String.format("%.2f", percentage);
        if (juiceType.startsWith("red")) {
            String region = juiceType.substring(4);
            return Component.translatable((String)("tooltip.vinery.fermentation_barrel.red_" + region + "_juice_with_percentage"), (Object[])new Object[]{percentageStr});
        }
        if (juiceType.startsWith("white")) {
            String region = juiceType.substring(6);
            return Component.translatable((String)("tooltip.vinery.fermentation_barrel.white_" + region + "_juice_with_percentage"), (Object[])new Object[]{percentageStr});
        }
        if (juiceType.equals("apple")) {
            return Component.translatable((String)"tooltip.vinery.fermentation_barrel.apple_juice_with_percentage", (Object[])new Object[]{percentageStr});
        }
        return Component.translatable((String)"tooltip.vinery.fermentation_barrel.empty");
    }

    private Component getCraftingTimeTooltip() {
        int currentTicks;
        int totalTicks = ((FermentationBarrelGuiHandler)this.menu).data.get(1);
        int remainingTicks = totalTicks - (currentTicks = ((FermentationBarrelGuiHandler)this.menu).data.get(0));
        if (remainingTicks > 0) {
            int seconds = remainingTicks / 20;
            int minutes = seconds / 60;
            String formattedTime = String.format("%d:%02d Seconds", minutes, seconds %= 60);
            return Component.translatable((String)"tooltip.vinery.fermentation_barrel.crafting_time", (Object[])new Object[]{formattedTime});
        }
        return Component.translatable((String)"tooltip.vinery.fermentation_barrel.crafting_time", (Object[])new Object[]{"0:00 Seconds"});
    }

    private boolean isMouseOverFluidArea(int mouseX, int mouseY) {
        int fluidAreaLeft = this.leftPos + 82 - 1;
        int fluidAreaTop = this.topPos + 44 - 5;
        int fluidAreaRight = this.leftPos + 82 + 20 + 1;
        int fluidAreaBottom = this.topPos + 44 + 10;
        return mouseX >= fluidAreaLeft && mouseX <= fluidAreaRight && mouseY >= fluidAreaTop && mouseY <= fluidAreaBottom;
    }

    private boolean isMouseOverCraftingTimeArea(int mouseX, int mouseY) {
        int totalTicks = ((FermentationBarrelGuiHandler)this.menu).data.get(1);
        int currentTicks = ((FermentationBarrelGuiHandler)this.menu).data.get(0);
        if (totalTicks <= 0 || currentTicks >= totalTicks) {
            return false;
        }
        int craftingTimeAreaLeft = this.leftPos + 122;
        int craftingTimeAreaTop = this.topPos + 20;
        int craftingTimeAreaRight = this.leftPos + 122 + 11;
        int craftingTimeAreaBottom = this.topPos + 20 + 29;
        return mouseX >= craftingTimeAreaLeft && mouseX <= craftingTimeAreaRight && mouseY >= craftingTimeAreaTop && mouseY <= craftingTimeAreaBottom;
    }

    public static void drawJuiceBar(GuiGraphics guiGraphics, String juiceType, int juiceAmount, int originX, int originY) {
        int MAX_FLUID = PlatformHelper.getMaxFluidLevel();
        int scaledWidth = (int)((double)juiceAmount / (double)MAX_FLUID * 20.0);
        scaledWidth = Math.max(0, Math.min(20, scaledWidth));
        int TEXTURE_X_START = 176;
        int TEXTURE__START = juiceType.startsWith("red") ? 29 : (juiceType.startsWith("white") ? 33 : (juiceType.equals("apple") ? 37 : 0));
        guiGraphics.blit(BACKGROUND, originX, originY, 176, TEXTURE__START, scaledWidth, 4);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
        int x = this.leftPos;
        int y = this.topPos;
        guiGraphics.blit(BACKGROUND, x, y, 0, 0, this.imageWidth, this.imageHeight);
        FermentationBarrelGui.drawJuiceBar(guiGraphics, ((FermentationBarrelGuiHandler)this.menu).getJuiceType(), ((FermentationBarrelGuiHandler)this.menu).getFluidLevel(), x + 82, y + 44);
        this.renderCraftingProgress(guiGraphics, x, y);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title.getString(), this.titleLabelX, this.titleLabelY, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle.getString(), this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }

    protected void renderCraftingProgress(GuiGraphics guiGraphics, int guiLeft, int guiTop) {
        int filledHeight = ((FermentationBarrelGuiHandler)this.menu).getScaledProgress(29);
        int drawY = guiTop + 20 + (29 - filledHeight);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
        guiGraphics.blit(BACKGROUND, guiLeft + 122, drawY, 176, 0 + (29 - filledHeight), 11, filledHeight);
    }
}

