/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block;

import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.vinery.core.block.entity.ApplePressBlockEntity;
import net.satisfy.vinery.core.registry.EntityTypeRegistry;
import net.satisfy.vinery.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplePressBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<DoubleBlockHalf> HALF = EnumProperty.create((String)"half", DoubleBlockHalf.class);
    public static final Map<Direction, VoxelShape> TOP_SHAPES = new HashMap<Direction, VoxelShape>();
    public static final Map<Direction, VoxelShape> BOTTOM_SHAPES = new HashMap<Direction, VoxelShape>();

    public ApplePressBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return ApplePressBlock.simpleCodec(ApplePressBlock::new);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HALF});
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!world.isClientSide) {
            BlockPos upperPos;
            BlockState upperState;
            if (state.getValue(HALF) == DoubleBlockHalf.UPPER && state.getBlock() != newState.getBlock()) {
                BlockPos lowerPos = pos.below();
                BlockState lowerState = world.getBlockState(lowerPos);
                if (lowerState.getBlock() == this && lowerState.getValue(HALF) == DoubleBlockHalf.LOWER) {
                    world.setBlock(lowerPos, Blocks.AIR.defaultBlockState(), 35);
                }
            } else if (state.getValue(HALF) == DoubleBlockHalf.LOWER && state.getBlock() != newState.getBlock() && (upperState = world.getBlockState(upperPos = pos.above())).getBlock() == this && upperState.getValue(HALF) == DoubleBlockHalf.UPPER) {
                world.setBlock(upperPos, Blocks.AIR.defaultBlockState(), 35);
            }
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.isClientSide) {
            if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
                this.dropInventory(world, pos);
                ApplePressBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this));
                BlockPos otherPartPos = pos.above();
                BlockState otherPartState = world.getBlockState(otherPartPos);
                if (otherPartState.getBlock() == this) {
                    world.setBlock(otherPartPos, Blocks.AIR.defaultBlockState(), 35);
                }
            } else if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
                ApplePressBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this));
                BlockPos otherPartPos = pos.below();
                BlockState otherPartState = world.getBlockState(otherPartPos);
                if (otherPartState.getBlock() == this) {
                    this.dropInventory(world, otherPartPos);
                    world.setBlock(otherPartPos, Blocks.AIR.defaultBlockState(), 35);
                }
            }
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    private void dropInventory(Level world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof ApplePressBlockEntity) {
            ApplePressBlockEntity applePress = (ApplePressBlockEntity)blockEntity;
            for (int i = 0; i < applePress.getItems().size(); ++i) {
                ItemStack stack = applePress.getItem(i);
                if (stack.isEmpty()) continue;
                ApplePressBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)stack);
            }
            applePress.clearContent();
        }
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        MenuProvider screenHandlerFactory;
        if (state.getValue(HALF) != DoubleBlockHalf.LOWER) {
            return InteractionResult.PASS;
        }
        if (!world.isClientSide && (screenHandlerFactory = state.getMenuProvider(world, pos)) != null) {
            player.openMenu(screenHandlerFactory);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ApplePressBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return ApplePressBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)EntityTypeRegistry.APPLE_PRESS_BLOCK_ENTITY.get()), (world1, pos, state1, be) -> be.tick(world1, pos, state1, (ApplePressBlockEntity)be));
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        if (pos.getY() < world.getMaxBuildHeight() - 1 && world.getBlockState(pos.above()).canBeReplaced(ctx)) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            BlockPos upperPos = pos.above();
            BlockState upperState = (BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER);
            world.setBlock(upperPos, upperState, 3);
        }
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            return TOP_SHAPES.get(facing);
        }
        return BOTTOM_SHAPES.get(facing);
    }

    private static VoxelShape makeTopShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.46875, (double)0.3125, (double)0.46875, (double)0.53125, (double)0.8125, (double)0.53125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.8125, (double)0.375, (double)0.625, (double)0.875, (double)0.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.40625, (double)0.125, (double)0.625, (double)0.59375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.875, (double)0.0, (double)0.40625, (double)1.0, (double)0.625, (double)0.59375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.5, (double)0.40625, (double)0.875, (double)0.625, (double)0.59375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.3125, (double)0.8125), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private static VoxelShape makeBottomShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.3125, (double)0.46875, (double)0.875, (double)0.4375, (double)0.53125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0625, (double)0.125, (double)0.125, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.875, (double)0.0, (double)0.0625, (double)1.0, (double)0.125, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.125, (double)0.40625, (double)0.125, (double)1.0, (double)0.59375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.875, (double)0.125, (double)0.40625, (double)1.0, (double)1.0, (double)0.59375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.5625, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.4375, (double)0.125, (double)0.875, (double)0.5625, (double)0.875), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    static {
        Supplier<VoxelShape> topShapeSupplier = ApplePressBlock::makeTopShape;
        Supplier<VoxelShape> bottomShapeSupplier = ApplePressBlock::makeBottomShape;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            TOP_SHAPES.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, topShapeSupplier.get()));
            BOTTOM_SHAPES.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, bottomShapeSupplier.get()));
        }
    }
}

