/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.satisfy.vinery.core.registry.GrapeTypeRegistry;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.util.GrapeType;
import org.jetbrains.annotations.NotNull;

public class GrapeVineBlock
extends VineBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    public static final BooleanProperty STERILIZED = BooleanProperty.create((String)"sterilized");
    public final GrapeType type;

    public GrapeVineBlock(BlockBehaviour.Properties settings, GrapeType type) {
        super(settings);
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)STERILIZED, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean bl;
        if (hand == InteractionHand.OFF_HAND) {
            return super.useItemOn(stack, state, world, pos, player, hand, hit);
        }
        if (player.getItemInHand(hand).is(Items.SHEARS)) {
            world.playSound(player, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)STERILIZED));
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        int i = (Integer)state.getValue((Property)AGE);
        boolean bl2 = bl = i == 3;
        if (!bl && player.getItemInHand(hand).is(Items.BONE_MEAL)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (i > 1) {
            int x = world.random.nextInt(2);
            GrapeVineBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack(this.type == GrapeTypeRegistry.JUNGLE_RED ? (ItemLike)ObjectRegistry.JUNGLE_RED_GRAPE.get() : (ItemLike)ObjectRegistry.JUNGLE_WHITE_GRAPE.get(), x + (bl ? 1 : 0)));
            world.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + world.random.nextFloat() * 0.4f);
            world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return super.useItemOn(stack, state, world, pos, player, hand, hit);
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int i = (Integer)state.getValue((Property)AGE);
        if (i < 3 && random.nextInt(5) == 0 && world.getRawBrightness(pos.above(), 0) >= 9) {
            BlockState blockState = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            world.setBlock(pos, blockState, 2);
            world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)blockState));
        }
        super.randomTick(state, world, pos, random);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)STERILIZED) == false;
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return (Integer)blockState.getValue((Property)AGE) < 3;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        int i = Math.min(3, (Integer)state.getValue((Property)AGE) + 1);
        world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AGE, STERILIZED});
    }
}

