/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.vinery.core.block.state.properties.GrapeProperty;
import net.satisfy.vinery.core.item.GrapeItem;
import net.satisfy.vinery.core.registry.GrapeTypeRegistry;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.registry.SoundEventRegistry;
import net.satisfy.vinery.core.util.GrapeType;
import org.jetbrains.annotations.NotNull;

public class GrapevinePotBlock
extends Block {
    private static final VoxelShape FILLING_SHAPE = Shapes.or((VoxelShape)Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)10.0, (double)16.0), Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)10.0, (double)1.0), Block.box((double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)10.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)0.0), Block.box((double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)6.0, (double)16.0), Block.box((double)16.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)16.0), Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0)});
    private static final VoxelShape SMASHING_SHAPE = Shapes.or((VoxelShape)FILLING_SHAPE, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0));
    private static final int MAX_STAGE = 6;
    private static final int MAX_STORAGE = 6;
    private static final IntegerProperty STAGE = IntegerProperty.create((String)"stage", (int)0, (int)6);
    private static final IntegerProperty STORAGE = IntegerProperty.create((String)"storage", (int)0, (int)6);
    private static final int DECREMENT_PER_WINE_BOTTLE = 3;
    private static final GrapeProperty GRAPEVINE_TYPE = GrapeProperty.create("type");

    public GrapevinePotBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)STAGE, (Comparable)Integer.valueOf(0))).setValue((Property)STORAGE, (Comparable)Integer.valueOf(0))).setValue((Property)GRAPEVINE_TYPE, (Comparable)GrapeTypeRegistry.NONE));
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if ((Integer)state.getValue((Property)STAGE) < 3) {
            return super.getCollisionShape(state, world, pos, context);
        }
        return SMASHING_SHAPE;
    }

    public void fallOn(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        int activeStage;
        super.fallOn(world, state, pos, entity, fallDistance);
        if (entity instanceof LivingEntity && (activeStage = ((Integer)state.getValue((Property)STAGE)).intValue()) >= 3) {
            if (activeStage < 6) {
                world.setBlock(pos, (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(activeStage + 1)), 3);
            }
            world.playSound(null, pos, (SoundEvent)SoundEventRegistry.BLOCK_GRAPEVINE_POT_SQUEEZE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private boolean canTakeWine(BlockState state, ItemStack stackInHand) {
        int storage = (Integer)state.getValue((Property)STORAGE);
        int stage = (Integer)state.getValue((Property)STAGE);
        if (this.canTakeWine(storage) && stage == 6) {
            return stackInHand.is(((Item)ObjectRegistry.WINE_BOTTLE.get()).asItem());
        }
        return false;
    }

    private boolean canTakeWine(int storage) {
        return switch (storage) {
            case 3, 6, 9 -> true;
            default -> false;
        };
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (((Integer)state.getValue((Property)STAGE) > 3 || (Integer)state.getValue((Property)STORAGE) >= 6) && stack.getItem() instanceof GrapeItem) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        Item item = stack.getItem();
        if (item instanceof GrapeItem) {
            BlockState newState;
            GrapeItem grape = (GrapeItem)item;
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            int stage = (Integer)state.getValue((Property)STAGE);
            int storage = (Integer)state.getValue((Property)STORAGE);
            boolean playSound = false;
            if (stage == 0) {
                world.setBlock(pos, (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)STAGE, (Comparable)Integer.valueOf(1))).setValue((Property)STORAGE, (Comparable)Integer.valueOf(1))).setValue((Property)GRAPEVINE_TYPE, (Comparable)grape.getType()), 3);
                playSound = true;
            }
            if (!this.isFilled(state)) {
                newState = world.getBlockState(pos);
                world.setBlock(pos, (BlockState)newState.setValue((Property)STORAGE, (Comparable)Integer.valueOf(storage + 1)), 3);
                playSound = true;
            }
            newState = world.getBlockState(pos);
            int newStage = (Integer)newState.getValue((Property)STAGE);
            int newStorage = (Integer)newState.getValue((Property)STORAGE);
            switch (newStorage) {
                case 3: 
                case 6: 
                case 9: {
                    if (newStage >= 3) break;
                    world.setBlock(pos, (BlockState)newState.setValue((Property)STAGE, (Comparable)Integer.valueOf(newStage + 1)), 3);
                }
            }
            if (playSound) {
                world.playSound(player, pos, SoundEvents.CORAL_BLOCK_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.is(((Item)ObjectRegistry.WINE_BOTTLE.get()).asItem()) && this.canTakeWine(state, stack)) {
            ItemStack output = ((GrapeType)state.getValue((Property)GRAPEVINE_TYPE)).getBottle().getDefaultInstance();
            int storage = (Integer)state.getValue((Property)STORAGE);
            int newStorage = storage - 3;
            if (newStorage == 0) {
                world.setBlock(pos, (BlockState)((BlockState)world.getBlockState(pos).setValue((Property)STORAGE, (Comparable)Integer.valueOf(0))).setValue((Property)STAGE, (Comparable)Integer.valueOf(0)), 3);
            } else {
                world.setBlock(pos, (BlockState)world.getBlockState(pos).setValue((Property)STORAGE, (Comparable)Integer.valueOf(newStorage)), 3);
            }
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            if (!player.getInventory().add(output)) {
                player.drop(output, false, false);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private boolean isFilled(BlockState state) {
        return (Integer)state.getValue((Property)STORAGE) >= 6;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.9375, (double)0.0, (double)0.0, (double)1.0, (double)0.625, (double)1.0));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.0625, (double)0.625, (double)1.0));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0, (double)0.9375, (double)0.625, (double)0.0625));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.9375, (double)0.9375, (double)0.625, (double)1.0));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.0625, (double)0.9375));
        return shape;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{STAGE, STORAGE, GRAPEVINE_TYPE});
    }
}

