/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block.entity;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.vinery.client.gui.handler.FermentationBarrelGuiHandler;
import net.satisfy.vinery.core.recipe.FermentationBarrelRecipe;
import net.satisfy.vinery.core.recipe.input.FermentationBarrelRecipeInput;
import net.satisfy.vinery.core.registry.EntityTypeRegistry;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.registry.RecipeTypesRegistry;
import net.satisfy.vinery.core.util.ImplementedInventory;
import net.satisfy.vinery.core.util.JuiceUtil;
import net.satisfy.vinery.core.util.WineYears;
import net.satisfy.vinery.platform.PlatformHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FermentationBarrelBlockEntity
extends BlockEntity
implements ImplementedInventory,
MenuProvider {
    private static final int INVENTORY_SIZE = 6;
    public static final int GRAPEJUICE_INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT_GENERAL = 5;
    public static final int WINE_BOTTLE_SLOT = 4;
    private NonNullList<ItemStack> inventory;
    private int fermentationTime = 0;
    private int fluidLevel = 0;
    private String juiceType = "";
    private final ContainerData propertyDelegate = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> FermentationBarrelBlockEntity.this.fermentationTime;
                case 1 -> PlatformHelper.getTotalFermentationTime();
                case 2 -> FermentationBarrelBlockEntity.this.fluidLevel;
                case 3 -> FermentationBarrelBlockEntity.this.getJuiceTypeValue();
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    FermentationBarrelBlockEntity.this.fermentationTime = value;
                    break;
                }
                case 1: {
                    FermentationBarrelBlockEntity.this.updateTotalFermentationTime();
                    break;
                }
                case 2: {
                    FermentationBarrelBlockEntity.this.setFluidLevel(value);
                    break;
                }
                case 3: {
                    FermentationBarrelBlockEntity.this.juiceType = FermentationBarrelBlockEntity.this.getJuiceTypeFromValue(value);
                    break;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };

    public FermentationBarrelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.FERMENTATION_BARREL_ENTITY.get(), pos, state);
        this.inventory = NonNullList.withSize((int)6, (Object)ItemStack.EMPTY);
    }

    public void updateTotalFermentationTime() {
        this.setChanged();
    }

    public int getFluidLevel() {
        return this.fluidLevel;
    }

    public void setFluidLevel(int fluidLevel) {
        this.fluidLevel = fluidLevel;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public String getJuiceType() {
        return this.juiceType;
    }

    public void setJuiceType(String juiceType) {
        this.juiceType = juiceType;
        this.setChanged();
    }

    private int getJuiceTypeValue() {
        return switch (this.juiceType) {
            case "white_general" -> 0;
            case "red_general" -> 1;
            case "white_savanna" -> 2;
            case "red_savanna" -> 3;
            case "white_taiga" -> 4;
            case "red_taiga" -> 5;
            case "white_jungle" -> 6;
            case "red_jungle" -> 7;
            case "apple" -> 8;
            case "red_crimson" -> 9;
            case "white_warped" -> 10;
            default -> -1;
        };
    }

    private String getJuiceTypeFromValue(int value) {
        return switch (value) {
            case 0 -> "white_general";
            case 1 -> "red_general";
            case 2 -> "white_savanna";
            case 3 -> "red_savanna";
            case 4 -> "white_taiga";
            case 5 -> "red_taiga";
            case 6 -> "white_jungle";
            case 7 -> "red_jungle";
            case 8 -> "apple";
            case 9 -> "red_crimson";
            case 10 -> "white_warped";
            default -> "";
        };
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
        this.fermentationTime = nbt.getInt("FermentationTime");
        this.fluidLevel = nbt.getInt("FluidLevel");
        this.juiceType = nbt.getString("JuiceType");
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.saveAdditional(nbt, provider);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
        nbt.putInt("FermentationTime", this.fermentationTime);
        nbt.putInt("FluidLevel", this.fluidLevel);
        nbt.putString("JuiceType", this.juiceType);
    }

    public static void tick(Level world, BlockPos pos, FermentationBarrelBlockEntity blockEntity) {
        if (world.isClientSide) {
            return;
        }
        if (blockEntity.fluidLevel == 0) {
            blockEntity.setJuiceType("");
        }
        RegistryAccess access = world.registryAccess();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (int i = 1; i <= 3; ++i) {
            ItemStack stack = blockEntity.getItem(i);
            if (stack.isEmpty() || !blockEntity.isIngredient(stack)) continue;
            inputs.add(stack);
        }
        FermentationBarrelRecipeInput input = new FermentationBarrelRecipeInput(inputs, blockEntity.getItem(4), new FermentationBarrelRecipeInput.JuiceData(blockEntity.juiceType, blockEntity.fluidLevel));
        Optional recipeHolder = world.getRecipeManager().getRecipeFor((RecipeType)RecipeTypesRegistry.FERMENTATION_BARREL_RECIPE_TYPE.get(), (RecipeInput)input, world);
        if (recipeHolder.isEmpty()) {
            blockEntity.fermentationTime = 0;
        } else {
            FermentationBarrelRecipe recipe = (FermentationBarrelRecipe)((RecipeHolder)recipeHolder.get()).value();
            if (blockEntity.canCraft(recipe, access)) {
                ++blockEntity.fermentationTime;
                if (blockEntity.fermentationTime >= PlatformHelper.getTotalFermentationTime()) {
                    blockEntity.fermentationTime = 0;
                    blockEntity.craft(recipe, access);
                }
            } else {
                blockEntity.fermentationTime = 0;
            }
        }
        ItemStack stack = blockEntity.getItem(0);
        if (JuiceUtil.isJuice(stack)) {
            String newJuiceType = JuiceUtil.getJuiceType(stack);
            if (blockEntity.fluidLevel == 0 || blockEntity.juiceType.equals(newJuiceType)) {
                blockEntity.setJuiceType(newJuiceType);
                int currentLevel = blockEntity.getFluidLevel();
                int maxFluidLevel = PlatformHelper.getMaxFluidLevel();
                int juiceCount = stack.getCount();
                int juicesToConsume = Math.min(juiceCount, 4);
                int fluidIncrease = juicesToConsume * PlatformHelper.getMaxFluidIncrease();
                int newFluidLevel = Math.min(currentLevel + fluidIncrease, maxFluidLevel);
                int actualFluidIncrease = newFluidLevel - currentLevel;
                int actualJuicesConsumed = actualFluidIncrease / PlatformHelper.getMaxFluidIncrease();
                if (actualJuicesConsumed > 0) {
                    blockEntity.setFluidLevel(newFluidLevel);
                    stack.shrink(actualJuicesConsumed);
                    if (stack.isEmpty()) {
                        blockEntity.setItem(0, ItemStack.EMPTY);
                    } else {
                        blockEntity.setItem(0, stack);
                    }
                    ItemStack wineBottleStack = new ItemStack((ItemLike)ObjectRegistry.WINE_BOTTLE.get(), actualJuicesConsumed);
                    ItemStack existingOutput = blockEntity.getItem(4);
                    if (existingOutput.isEmpty()) {
                        blockEntity.setItem(4, wineBottleStack);
                    } else if (existingOutput.is(wineBottleStack.getItem()) && existingOutput.getCount() + wineBottleStack.getCount() <= existingOutput.getMaxStackSize()) {
                        existingOutput.grow(wineBottleStack.getCount());
                        blockEntity.setItem(4, existingOutput);
                    } else {
                        Containers.dropItemStack((Level)world, (double)((double)pos.getX() + 0.5), (double)(pos.getY() + 1), (double)((double)pos.getZ() + 0.5), (ItemStack)wineBottleStack);
                    }
                }
            }
        }
    }

    private boolean canCraft(FermentationBarrelRecipe recipe, RegistryAccess access) {
        ItemStack wineBottle;
        if (recipe == null || recipe.getResultItem((HolderLookup.Provider)access).isEmpty()) {
            return false;
        }
        if (this.areIngredientsEmpty()) {
            return false;
        }
        if (this.fluidLevel < recipe.getJuiceData().amount()) {
            return false;
        }
        if (!this.juiceType.equals(recipe.getJuiceData().type())) {
            return false;
        }
        if (recipe.isWineBottleRequired() && ((wineBottle = this.getItem(4)).isEmpty() || !wineBottle.is((Item)ObjectRegistry.WINE_BOTTLE.get()))) {
            return false;
        }
        ItemStack recipeOutput = recipe.getResultItem((HolderLookup.Provider)access);
        if (recipeOutput.is((Item)ObjectRegistry.WINE_BOTTLE.get())) {
            ItemStack existingWineBottle = this.getItem(4);
            if (existingWineBottle.isEmpty()) {
                return true;
            }
            return existingWineBottle.is(recipeOutput.getItem()) && existingWineBottle.getCount() + recipeOutput.getCount() <= existingWineBottle.getMaxStackSize();
        }
        ItemStack existingOutput = this.getItem(5);
        if (existingOutput.isEmpty()) {
            return true;
        }
        return existingOutput.is(recipeOutput.getItem()) && existingOutput.getCount() + recipeOutput.getCount() <= existingOutput.getMaxStackSize();
    }

    private boolean areIngredientsEmpty() {
        for (int i = 1; i < 4; ++i) {
            if (this.getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void craft(FermentationBarrelRecipe recipe, RegistryAccess access) {
        ItemStack wineBottle;
        if (!this.canCraft(recipe, access)) {
            return;
        }
        ItemStack recipeOutput = recipe.getResultItem((HolderLookup.Provider)access).copy();
        ItemStack existingOutput = this.getItem(5);
        if (existingOutput.isEmpty()) {
            this.setItem(5, recipeOutput);
        } else if (existingOutput.is(recipeOutput.getItem()) && existingOutput.getCount() + recipeOutput.getCount() <= existingOutput.getMaxStackSize()) {
            existingOutput.grow(recipeOutput.getCount());
            this.setItem(5, existingOutput);
        } else {
            assert (this.level != null);
            Containers.dropItemStack((Level)this.level, (double)((double)this.worldPosition.getX() + 0.5), (double)(this.worldPosition.getY() + 1), (double)((double)this.worldPosition.getZ() + 0.5), (ItemStack)recipeOutput);
        }
        if (recipe.isWineBottleRequired() && !(wineBottle = this.getItem(4)).isEmpty() && wineBottle.getCount() > 0) {
            wineBottle.shrink(1);
            this.setItem(4, wineBottle);
        }
        int newFluidLevel = this.fluidLevel - recipe.getJuiceData().amount();
        this.setFluidLevel(newFluidLevel);
        block0: for (Ingredient ingredient : recipe.getIngredients()) {
            for (int i = 1; i < 4; ++i) {
                ItemStack slotStack = this.getItem(i);
                if (!ingredient.test(slotStack)) continue;
                slotStack.shrink(1);
                if (slotStack.isEmpty()) {
                    this.setItem(i, ItemStack.EMPTY);
                    continue block0;
                }
                this.setItem(i, slotStack);
                continue block0;
            }
        }
        WineYears.setWineYear(recipeOutput, this.level);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        ItemStack stackInSlot = (ItemStack)this.inventory.get(slot);
        boolean sameItem = !stack.isEmpty() && ItemStack.matches((ItemStack)stack, (ItemStack)stackInSlot);
        this.inventory.set(slot, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        if (!sameItem && this.isIngredientSlot(slot) && this.areIngredientsEmpty()) {
            this.fermentationTime = 0;
            this.setChanged();
        }
    }

    private boolean isIngredientSlot(int slot) {
        return slot >= 1 && slot <= 3;
    }

    @Override
    public boolean stillValid(Player player) {
        assert (this.level != null);
        return this.level.getBlockEntity(this.worldPosition) == this && player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
        return new FermentationBarrelGuiHandler(syncId, inv, (Container)this, this.propertyDelegate);
    }

    @Override
    public int getContainerSize() {
        return this.inventory.size();
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public ItemStack getItem(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    @Override
    @NotNull
    public ItemStack removeItem(int index, int count) {
        return ContainerHelper.removeItem(this.inventory, (int)index, (int)count);
    }

    @Override
    @NotNull
    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.inventory, (int)index);
    }

    @Override
    public void clearContent() {
        this.inventory.clear();
    }

    private boolean isIngredient(ItemStack stack) {
        if (this.level == null) {
            return false;
        }
        return this.level.getRecipeManager().getAllRecipesFor((RecipeType)RecipeTypesRegistry.FERMENTATION_BARREL_RECIPE_TYPE.get()).stream().anyMatch(recipe -> ((FermentationBarrelRecipe)recipe.value()).getIngredients().stream().anyMatch(ingredient -> ingredient.test(stack)));
    }

    @Override
    public int @NotNull [] getSlotsForFace(Direction side) {
        if (side == Direction.UP) {
            return new int[]{0, 4};
        }
        if (side == Direction.DOWN) {
            return new int[]{5};
        }
        if (side.getAxis().isHorizontal()) {
            return new int[]{5, 4, 1, 2, 3};
        }
        return new int[0];
    }

    @Override
    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        if (direction == Direction.UP) {
            if (index == 0 && JuiceUtil.isJuice(stack)) {
                return this.hasSpace(index, stack);
            }
            if (index == 4 && stack.is((Item)ObjectRegistry.WINE_BOTTLE.get())) {
                return this.hasSpace(index, stack);
            }
        } else {
            assert (direction != null);
            if (direction.getAxis().isHorizontal()) {
                if (index >= 1 && index <= 3 && this.isIngredient(stack)) {
                    return this.hasSpace(index, stack);
                }
                if (index == 4 && stack.is((Item)ObjectRegistry.WINE_BOTTLE.get())) {
                    return this.hasSpace(index, stack);
                }
            }
        }
        return false;
    }

    private boolean hasSpace(int index, ItemStack stack) {
        ItemStack slotStack = this.getItem(index);
        if (slotStack.isEmpty()) {
            return true;
        }
        if (ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)stack)) {
            return slotStack.getCount() + stack.getCount() <= slotStack.getMaxStackSize();
        }
        return false;
    }

    @Override
    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return (direction == Direction.DOWN || direction.getAxis().isHorizontal()) && index == 5;
    }
}

