/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.item;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class BasketItem
extends BlockItem {
    public BasketItem(Block block, Item.Properties settings) {
        super(block, new Item.Properties().stacksTo(1));
    }

    private static Stream<ItemStack> getContents(ItemStack itemStack, HolderLookup.Provider provider) {
        CompoundTag compoundTag = ((CustomData)itemStack.get(DataComponents.CUSTOM_DATA)).copyTag();
        if (compoundTag == null) {
            return Stream.empty();
        }
        CompoundTag blockEntityTag = compoundTag.getCompound("BlockEntityTag");
        if (blockEntityTag == null) {
            return Stream.empty();
        }
        ListTag itemsList = blockEntityTag.getList("Items", 10);
        if (itemsList == null) {
            return Stream.empty();
        }
        return itemsList.stream().filter(Objects::nonNull).map(Tag.class::cast).map(CompoundTag.class::cast).map(tag -> ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag));
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(ItemStack itemStack, HolderLookup.Provider provider) {
        NonNullList nonNullList = NonNullList.create();
        Stream<ItemStack> var10000 = BasketItem.getContents(itemStack, provider);
        Objects.requireNonNull(nonNullList);
        var10000.forEach(arg_0 -> nonNullList.add(arg_0));
        return Optional.of(new BundleTooltip(new BundleContents((List)nonNullList)));
    }
}

