/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.satisfy.vinery.core.recipe.input.ApplePressMashingRecipeInput;
import net.satisfy.vinery.core.registry.RecipeTypesRegistry;
import org.jetbrains.annotations.NotNull;

public class ApplePressMashingRecipe
implements Recipe<ApplePressMashingRecipeInput> {
    public final Ingredient input;
    private final ItemStack output;
    public static RecipeType<ApplePressMashingRecipe> Type = (RecipeType)RecipeTypesRegistry.APPLE_PRESS_MASHING_RECIPE_TYPE.get();

    public ApplePressMashingRecipe(Ingredient input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public boolean matches(ApplePressMashingRecipeInput inventory, Level world) {
        return this.input.test(inventory.getItem(0));
    }

    @NotNull
    public ItemStack assemble(ApplePressMashingRecipeInput container, HolderLookup.Provider registryAccess) {
        return this.output.copy();
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.input);
        return list;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return this.output.copy();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeTypesRegistry.APPLE_PRESS_MASHING_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipeTypesRegistry.APPLE_PRESS_MASHING_RECIPE_TYPE.get();
    }

    public boolean isSpecial() {
        return true;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public static class Serializer
    implements RecipeSerializer<ApplePressMashingRecipe> {
        public MapCodec<ApplePressMashingRecipe> codec() {
            return RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC.fieldOf("input").forGetter(ApplePressMashingRecipe::getInput), (App)ItemStack.CODEC.fieldOf("output").forGetter(ApplePressMashingRecipe::getOutput)).apply((Applicative)inst, ApplePressMashingRecipe::new));
        }

        public StreamCodec<RegistryFriendlyByteBuf, ApplePressMashingRecipe> streamCodec() {
            return new StreamCodec<RegistryFriendlyByteBuf, ApplePressMashingRecipe>(this){

                public void encode(RegistryFriendlyByteBuf buf, ApplePressMashingRecipe recipe) {
                    Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.getInput());
                    ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.getOutput());
                }

                public ApplePressMashingRecipe decode(RegistryFriendlyByteBuf buf) {
                    return new ApplePressMashingRecipe((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf), (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf));
                }
            };
        }
    }
}

