/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.registry.TagRegistry;

public class JuiceUtil {
    public static final Map<TagKey<Item>, String> RED_JUICE_TAGS = new HashMap<TagKey<Item>, String>();
    public static final Map<TagKey<Item>, String> WHITE_JUICE_TAGS = new HashMap<TagKey<Item>, String>();
    public static final Map<Item, String> APPLE_JUICES = new HashMap<Item, String>();

    private static void addRedJuice(TagKey<Item> tag, String region) {
        RED_JUICE_TAGS.put(tag, region);
    }

    private static void addWhiteJuice(TagKey<Item> tag, String region) {
        WHITE_JUICE_TAGS.put(tag, region);
    }

    private static void addAppleJuice(Item item) {
        APPLE_JUICES.put(item, "apple");
    }

    public static boolean isJuice(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return JuiceUtil.isRedJuice(stack) || JuiceUtil.isWhiteJuice(stack) || JuiceUtil.isAppleJuice(stack);
    }

    private static boolean isRedJuice(ItemStack stack) {
        for (TagKey<Item> tag : RED_JUICE_TAGS.keySet()) {
            if (!stack.is(tag)) continue;
            return true;
        }
        return false;
    }

    private static boolean isWhiteJuice(ItemStack stack) {
        for (TagKey<Item> tag : WHITE_JUICE_TAGS.keySet()) {
            if (!stack.is(tag)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAppleJuice(ItemStack stack) {
        return APPLE_JUICES.containsKey(stack.getItem());
    }

    public static String getJuiceType(ItemStack stack) {
        if (!JuiceUtil.isJuice(stack)) {
            return "";
        }
        for (Map.Entry<TagKey<Item>, String> entry : RED_JUICE_TAGS.entrySet()) {
            if (!stack.is(entry.getKey())) continue;
            return "red_" + entry.getValue();
        }
        for (Map.Entry<TagKey<Item>, String> entry : WHITE_JUICE_TAGS.entrySet()) {
            if (!stack.is(entry.getKey())) continue;
            return "white_" + entry.getValue();
        }
        String region = APPLE_JUICES.get(stack.getItem());
        if (region != null) {
            return region;
        }
        return "";
    }

    static {
        JuiceUtil.addRedJuice(TagRegistry.RED_GRAPEJUICE, "general");
        JuiceUtil.addRedJuice(TagRegistry.RED_SAVANNA_GRAPEJUICE, "savanna");
        JuiceUtil.addRedJuice(TagRegistry.RED_TAIGA_GRAPEJUICE, "taiga");
        JuiceUtil.addRedJuice(TagRegistry.RED_JUNGLE_GRAPEJUICE, "jungle");
        JuiceUtil.addRedJuice(TagRegistry.CRIMSON_GRAPEJUICE, "crimson");
        JuiceUtil.addWhiteJuice(TagRegistry.WHITE_GRAPEJUICE, "general");
        JuiceUtil.addWhiteJuice(TagRegistry.WHITE_SAVANNA_GRAPEJUICE, "savanna");
        JuiceUtil.addWhiteJuice(TagRegistry.WHITE_TAIGA_GRAPEJUICE, "taiga");
        JuiceUtil.addWhiteJuice(TagRegistry.WHITE_JUNGLE_GRAPEJUICE, "jungle");
        JuiceUtil.addWhiteJuice(TagRegistry.WARPED_GRAPEJUICE, "warped");
        JuiceUtil.addAppleJuice((Item)ObjectRegistry.APPLE_JUICE.get());
    }
}

