/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.world.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.satisfy.vinery.core.block.GrapeVineBlock;

public class JungleGrapeFeature
extends Feature<BlockStateConfiguration> {
    public JungleGrapeFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BlockStateConfiguration> context) {
        int tries = 12;
        int xz = 7;
        int height = 10;
        int length = 12;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i < tries; ++i) {
            mutable.set((Vec3i)context.origin()).move(context.random().nextInt(xz * 2 + 1) - xz, context.random().nextInt(height) - 1, context.random().nextInt(xz * 2 + 1) - xz);
            if (!context.level().isEmptyBlock((BlockPos)mutable)) continue;
            BlockPos.MutableBlockPos vineMutablePos = new BlockPos.MutableBlockPos().set((Vec3i)mutable);
            ChunkPos currentChunkPos = new ChunkPos((BlockPos)vineMutablePos);
            int maxLength = length - context.random().nextInt(context.random().nextInt(length) + 1);
            int targetY = vineMutablePos.getY() - maxLength;
            while (vineMutablePos.getY() >= targetY && context.level().isEmptyBlock((BlockPos)vineMutablePos)) {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    mutable.set((Vec3i)vineMutablePos).move(direction);
                    ChunkPos newChunkPos = new ChunkPos((BlockPos)mutable);
                    if (newChunkPos.x != currentChunkPos.x || newChunkPos.z != currentChunkPos.z) continue;
                    BlockState currentBlockstate = (BlockState)((BlockStateConfiguration)context.config()).state.setValue((Property)GrapeVineBlock.getPropertyForFace((Direction)direction), (Comparable)Boolean.valueOf(true));
                    BlockState aboveBlockstate = context.level().getBlockState(vineMutablePos.above());
                    if (currentBlockstate.canSurvive((LevelReader)context.level(), (BlockPos)vineMutablePos) && context.level().getBlockState(vineMutablePos.relative(direction)).getBlock() != Blocks.MOSS_CARPET) {
                        context.level().setBlock((BlockPos)vineMutablePos, (BlockState)((BlockState)currentBlockstate.setValue((Property)VineBlock.UP, (Comparable)Boolean.valueOf(aboveBlockstate.canOcclude()))).setValue((Property)GrapeVineBlock.AGE, (Comparable)Integer.valueOf(context.random().nextInt(3))), 2);
                        break;
                    }
                    if (!aboveBlockstate.is(((BlockStateConfiguration)context.config()).state.getBlock())) continue;
                    context.level().setBlock((BlockPos)vineMutablePos, (BlockState)((BlockState)aboveBlockstate.setValue((Property)VineBlock.UP, (Comparable)Boolean.valueOf(false))).setValue((Property)GrapeVineBlock.AGE, (Comparable)Integer.valueOf(context.random().nextInt(3))), 2);
                    break;
                }
                vineMutablePos.move(Direction.DOWN);
            }
        }
        return true;
    }
}

