/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.fabric.core.registry;

import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.object.builder.v1.villager.VillagerProfessionBuilder;
import net.fabricmc.fabric.api.object.builder.v1.world.poi.PointOfInterestHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3852;
import net.minecraft.class_4158;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.satisfy.vinery.core.Vinery;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.util.VillagerUtil;
import net.satisfy.vinery.fabric.config.VineryFabricConfig;

public class VineryFabricVillagers {
    private static final class_2960 WINEMAKER_POI_IDENTIFIER = Vinery.identifier("winemaker_poi");
    public static final class_4158 WINEMAKER_POI = PointOfInterestHelper.register((class_2960)WINEMAKER_POI_IDENTIFIER, (int)1, (int)12, (class_2248[])new class_2248[]{(class_2248)ObjectRegistry.FERMENTATION_BARREL.get()});
    public static final class_3852 WINEMAKER = (class_3852)class_2378.method_10230((class_2378)class_7923.field_41195, (class_2960)class_2960.method_60655((String)"vinery", (String)"winemaker"), (Object)VillagerProfessionBuilder.create().id(class_2960.method_60655((String)"vinery", (String)"winemaker")).workstation(class_5321.method_29179((class_5321)class_7924.field_41212, (class_2960)WINEMAKER_POI_IDENTIFIER)).build());

    public static void registerPOIAndProfession() {
    }

    public static void init(MinecraftServer server) {
        VineryFabricConfig config = (VineryFabricConfig)AutoConfig.getConfigHolder(VineryFabricConfig.class).getConfig();
        class_5455.class_6890 registryAccess = server.method_30611();
        VineryFabricVillagers.registerTradesForLevel(config.villager.level1, 1, (class_5455)registryAccess);
        VineryFabricVillagers.registerTradesForLevel(config.villager.level2, 2, (class_5455)registryAccess);
        VineryFabricVillagers.registerTradesForLevel(config.villager.level3, 3, (class_5455)registryAccess);
        VineryFabricVillagers.registerTradesForLevel(config.villager.level4, 4, (class_5455)registryAccess);
        VineryFabricVillagers.registerTradesForLevel(config.villager.level5, 5, (class_5455)registryAccess);
    }

    private static void registerTradesForLevel(VineryFabricConfig.VillagerSettings.TradeLevelSettings tradeLevelSettings, int level, class_5455 registryAccess) {
        TradeOfferHelper.registerVillagerOffers((class_3852)WINEMAKER, (int)level, factories -> {
            for (VineryFabricConfig.VillagerSettings.TradeEntry entry : tradeLevelSettings.trades) {
                if (entry.price < 1 || entry.price > 99) {
                    System.err.println("Vinery Villager Trade has invalid price: " + entry.price + " (must be 1-99). Skipping trade for item: " + entry.item);
                    continue;
                }
                if (entry.maxUses < 1) {
                    System.err.println("Vinery Villager Trade has invalid maxUses: " + entry.maxUses + " (must be >= 1). Skipping trade for item: " + entry.item);
                    continue;
                }
                String[] parts = entry.item.split(":");
                if (parts.length >= 2) {
                    String modId = parts[0];
                    String itemId = parts[1];
                    class_2960 rl = class_2960.method_60655((String)modId, (String)itemId);
                    class_1792 item = (class_1792)registryAccess.method_30530(class_7924.field_41197).method_10223(rl);
                    if (item != null && item != class_1802.field_8162) {
                        if (entry.type == VineryFabricConfig.VillagerSettings.TradeType.BUY) {
                            factories.add(new VillagerUtil.BuyForOneEmeraldFactory((class_1935)item, entry.price, entry.maxUses, entry.experience));
                            continue;
                        }
                        if (entry.type != VineryFabricConfig.VillagerSettings.TradeType.SELL) continue;
                        factories.add(new VillagerUtil.SellItemFactory(item, entry.price, entry.maxUses, entry.experience));
                        continue;
                    }
                    System.err.println("Vinery Villager Trade Item not found or is AIR: " + String.valueOf(rl));
                    continue;
                }
                System.err.println("Vinery Villager Trade has invalid item format: " + entry.item);
            }
        });
    }
}

