/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block.entity;

import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.satisfy.vinery.client.gui.handler.ApplePressGuiHandler;
import net.satisfy.vinery.core.recipe.ApplePressFermentingRecipe;
import net.satisfy.vinery.core.recipe.ApplePressMashingRecipe;
import net.satisfy.vinery.core.recipe.input.ApplePressFermentingRecipeInput;
import net.satisfy.vinery.core.recipe.input.ApplePressMashingRecipeInput;
import net.satisfy.vinery.core.registry.EntityTypeRegistry;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.registry.RecipeTypesRegistry;
import net.satisfy.vinery.core.util.ImplementedInventory;
import net.satisfy.vinery.platform.PlatformHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplePressBlockEntity
extends class_2586
implements class_3908,
ImplementedInventory,
class_5558<ApplePressBlockEntity> {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    protected final class_3913 propertyDelegate;
    private int progress1 = 0;
    private int maxProgress1 = PlatformHelper.getApplePressMashingTime();
    private int progress2 = 0;
    private int maxProgress2 = PlatformHelper.getApplePressFermentationTime();

    public ApplePressBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)EntityTypeRegistry.APPLE_PRESS_BLOCK_ENTITY.get(), pos, state);
        this.propertyDelegate = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> ApplePressBlockEntity.this.progress1;
                    case 1 -> ApplePressBlockEntity.this.maxProgress1;
                    case 2 -> ApplePressBlockEntity.this.progress2;
                    case 3 -> ApplePressBlockEntity.this.maxProgress2;
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        ApplePressBlockEntity.this.progress1 = value;
                        break;
                    }
                    case 1: {
                        ApplePressBlockEntity.this.maxProgress1 = value;
                        break;
                    }
                    case 2: {
                        ApplePressBlockEntity.this.progress2 = value;
                        break;
                    }
                    case 3: {
                        ApplePressBlockEntity.this.maxProgress2 = value;
                    }
                }
            }

            public int method_17389() {
                return 4;
            }
        };
    }

    @Override
    public int @NotNull [] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return new int[]{3};
        }
        if (side.method_10166().method_10179()) {
            return new int[]{0, 1, 2};
        }
        return new int[0];
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    @NotNull
    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new ApplePressGuiHandler(syncId, inv, (class_1263)this, this.propertyDelegate);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 provider) {
        super.method_11007(nbt, provider);
        class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)provider);
        nbt.method_10569("apple_press.progress1", this.progress1);
        nbt.method_10569("apple_press.progress2", this.progress2);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 provider) {
        super.method_11014(nbt, provider);
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)provider);
        this.progress1 = nbt.method_10550("apple_press.progress1");
        this.progress2 = nbt.method_10550("apple_press.progress2");
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, ApplePressBlockEntity entity) {
        Record input;
        if (world.method_8608()) {
            return;
        }
        boolean dirty = false;
        if (ApplePressBlockEntity.hasInput(entity, 0)) {
            input = new ApplePressMashingRecipeInput(entity.method_5438(0));
            if (world.method_8433().method_8132((class_3956)RecipeTypesRegistry.APPLE_PRESS_MASHING_RECIPE_TYPE.get(), (class_9695)input, world).isEmpty()) {
                return;
            }
            class_1860 recipe1 = ((class_8786)world.method_8433().method_8132((class_3956)RecipeTypesRegistry.APPLE_PRESS_MASHING_RECIPE_TYPE.get(), (class_9695)input, this.field_11863).get()).comp_1933();
            if (recipe1 instanceof ApplePressMashingRecipe) {
                ApplePressMashingRecipe mashingRecipe = (ApplePressMashingRecipe)recipe1;
                if (ApplePressBlockEntity.canProcessMashing(entity, mashingRecipe)) {
                    ++entity.progress1;
                    if (entity.progress1 >= entity.maxProgress1) {
                        ApplePressBlockEntity.processMashing(entity, mashingRecipe);
                        dirty = true;
                    }
                } else {
                    entity.progress1 = 0;
                }
            } else {
                entity.progress1 = 0;
            }
        } else {
            entity.progress1 = 0;
        }
        if (ApplePressBlockEntity.hasInput(entity, 1)) {
            input = new ApplePressFermentingRecipeInput(entity.method_5438(1));
            if (world.method_8433().method_8132((class_3956)RecipeTypesRegistry.APPLE_PRESS_FERMENTING_RECIPE_TYPE.get(), (class_9695)input, world).isEmpty()) {
                return;
            }
            class_1860 recipe2 = ((class_8786)world.method_8433().method_8132((class_3956)RecipeTypesRegistry.APPLE_PRESS_FERMENTING_RECIPE_TYPE.get(), (class_9695)input, world).get()).comp_1933();
            if (recipe2 instanceof ApplePressFermentingRecipe) {
                ApplePressFermentingRecipe fermentingRecipe = (ApplePressFermentingRecipe)recipe2;
                if (ApplePressBlockEntity.canProcessFermenting(entity, fermentingRecipe)) {
                    ++entity.progress2;
                    if (entity.progress2 >= entity.maxProgress2) {
                        ApplePressBlockEntity.processFermenting(entity, fermentingRecipe);
                        dirty = true;
                    }
                } else {
                    entity.progress2 = 0;
                }
            } else {
                entity.progress2 = 0;
            }
        } else {
            entity.progress2 = 0;
        }
        if (dirty) {
            ApplePressBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
        }
    }

    private static boolean hasInput(ApplePressBlockEntity entity, int slot) {
        return !entity.method_5438(slot).method_7960();
    }

    private static boolean canProcessMashing(ApplePressBlockEntity entity, ApplePressMashingRecipe recipe) {
        class_1799 input = entity.method_5438(0);
        class_1799 output = entity.method_5438(1);
        if (!recipe.matches(new ApplePressMashingRecipeInput(input), entity.field_11863)) {
            return false;
        }
        if (output.method_7960()) {
            return true;
        }
        assert (entity.field_11863 != null);
        return output.method_7909() == recipe.method_8110((class_7225.class_7874)entity.field_11863.method_30349()).method_7909();
    }

    private static void processMashing(ApplePressBlockEntity entity, ApplePressMashingRecipe recipe) {
        entity.method_5434(0, 1);
        assert (entity.field_11863 != null);
        class_1799 result = recipe.method_8110((class_7225.class_7874)entity.field_11863.method_30349()).method_7972();
        class_1799 outputSlot = entity.method_5438(1);
        if (outputSlot.method_7960()) {
            entity.method_5447(1, result);
        } else {
            outputSlot.method_7933(result.method_7947());
        }
        entity.progress1 = 0;
    }

    private static boolean canProcessFermenting(ApplePressBlockEntity entity, ApplePressFermentingRecipe recipe) {
        class_1799 bottle;
        if (!recipe.matches(new ApplePressFermentingRecipeInput(entity.method_5438(1)), entity.field_11863)) {
            return false;
        }
        if (recipe.requiresBottle() && !ApplePressBlockEntity.isWineBottle(bottle = entity.method_5438(2))) {
            return false;
        }
        class_1799 output = entity.method_5438(3);
        if (output.method_7960()) {
            return true;
        }
        assert (entity.field_11863 != null);
        return output.method_7909() == recipe.method_8110((class_7225.class_7874)entity.field_11863.method_30349()).method_7909();
    }

    private static void processFermenting(ApplePressBlockEntity entity, ApplePressFermentingRecipe recipe) {
        entity.method_5434(1, 1);
        if (recipe.requiresBottle()) {
            entity.method_5434(2, 1);
        }
        assert (entity.field_11863 != null);
        class_1799 result = recipe.method_8110((class_7225.class_7874)entity.field_11863.method_30349()).method_7972();
        class_1799 outputSlot = entity.method_5438(3);
        if (outputSlot.method_7960()) {
            entity.method_5447(3, result);
        } else {
            outputSlot.method_7933(result.method_7947());
        }
        entity.progress2 = 0;
    }

    private static boolean isWineBottle(class_1799 stack) {
        return stack.method_7909() == ObjectRegistry.WINE_BOTTLE.get();
    }

    @Override
    public boolean method_5443(class_1657 player) {
        return this.field_11863 != null && this.field_11863.method_8321(this.field_11867) == this && player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public boolean method_5437(int index, class_1799 stack) {
        return switch (index) {
            case 0 -> true;
            case 2 -> {
                if (stack.method_7909() == ObjectRegistry.WINE_BOTTLE.get()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 direction) {
        assert (direction != null);
        if (direction.method_10166().method_10179()) {
            return switch (index) {
                case 0 -> this.isValidForApplePressMashing(stack);
                case 1 -> this.isValidForApplePressFermenting(stack);
                case 2 -> ApplePressBlockEntity.isWineBottle(stack);
                default -> false;
            };
        }
        return false;
    }

    @Override
    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return index == 3 && (direction == class_2350.field_11033 || direction.method_10166().method_10179());
    }

    private boolean isValidForApplePressMashing(class_1799 stack) {
        if (this.field_11863 == null) {
            return false;
        }
        return this.field_11863.method_8433().method_30027((class_3956)RecipeTypesRegistry.APPLE_PRESS_MASHING_RECIPE_TYPE.get()).stream().anyMatch(recipe -> ((ApplePressMashingRecipe)recipe.comp_1933()).method_8117().stream().anyMatch(ingredient -> ingredient.method_8093(stack)));
    }

    private boolean isValidForApplePressFermenting(class_1799 stack) {
        if (this.field_11863 == null) {
            return false;
        }
        return this.field_11863.method_8433().method_30027((class_3956)RecipeTypesRegistry.APPLE_PRESS_FERMENTING_RECIPE_TYPE.get()).stream().anyMatch(recipe -> ((ApplePressFermentingRecipe)recipe.comp_1933()).method_8117().stream().anyMatch(ingredient -> ingredient.method_8093(stack)));
    }
}

