/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.item;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_5251;
import net.minecraft.class_5328;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9331;
import net.satisfy.vinery.core.block.entity.StorageBlockEntity;
import net.satisfy.vinery.core.registry.DataComponentRegistry;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.util.GeneralUtil;
import net.satisfy.vinery.core.util.WineYears;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrinkBlockItem
extends class_1747 {
    private int baseDuration = 0;
    private boolean scaleDurationWithAge;
    private final BottleSize bottleSize;
    private Supplier<class_6880<class_1291>> effectSupplier;
    private int baseAmplifier;

    public DrinkBlockItem(class_2248 block, class_1792.class_1793 settings, boolean scaleDurationWithAge, BottleSize bottleSize) {
        super(block, settings);
        this.scaleDurationWithAge = scaleDurationWithAge;
        this.bottleSize = bottleSize;
        this.effectSupplier = null;
        this.baseAmplifier = 0;
    }

    public void setEffectSupplier(Supplier<class_6880<class_1291>> effectSupplier, int baseDuration, int baseAmplifier) {
        this.effectSupplier = effectSupplier;
        this.baseDuration = baseDuration;
        this.baseAmplifier = baseAmplifier;
    }

    @NotNull
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8946;
    }

    protected class_2680 method_7707(class_1750 context) {
        if (!Objects.requireNonNull(context.method_8036()).method_18276()) {
            return null;
        }
        class_2680 blockState = this.method_7711().method_9605(context);
        return blockState != null && this.method_7709(context, blockState) ? blockState : null;
    }

    protected boolean method_7710(class_2338 blockPos, class_1937 level, @Nullable class_1657 player, class_1799 itemStack, class_2680 blockState) {
        class_2586 class_25862 = level.method_8321(blockPos);
        if (class_25862 instanceof StorageBlockEntity) {
            StorageBlockEntity wineEntity = (StorageBlockEntity)class_25862;
            wineEntity.setStack(0, itemStack.method_46651(1));
        }
        return super.method_7710(blockPos, level, player, itemStack, blockState);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 tooltipContext, List<class_2561> tooltip, class_1836 tooltipFlag) {
        class_1937 world = null;
        if (tooltipContext.method_59527() != null) {
            world = this.getLevel();
        }
        if (this.effectSupplier != null && world != null) {
            class_6880<class_1291> effectHolder = this.effectSupplier.get();
            class_1291 effect = (class_1291)effectHolder.comp_349();
            String effectName = effect.method_5560().getString();
            int amplifier = Math.max(0, WineYears.getEffectLevel(stack, world));
            String amplifierRoman = amplifier > 0 ? " " + this.toRoman(amplifier) : "";
            int durationTicks = this.scaleDurationWithAge ? WineYears.getEffectDuration(stack, world) : this.baseDuration;
            durationTicks = Math.max(0, durationTicks);
            String formattedDuration = this.formatDuration(durationTicks);
            String tooltipText = effectName + amplifierRoman + " (" + formattedDuration + ")";
            tooltip.add((class_2561)class_2561.method_43470((String)tooltipText).method_27692(effect.method_18792().method_18793()));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"effect.none").method_27692(class_124.field_1080));
        }
        tooltip.add((class_2561)class_2561.method_43473());
        if (world != null) {
            int age = Math.max(0, WineYears.getWineAge(stack, world));
            int ageDays = WineYears.getWineAgeDays(stack, world);
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.vinery.age", (Object[])new Object[]{age}).method_27692(class_124.field_1068));
            tooltip.add((class_2561)class_2561.method_43473());
            int daysToNextUpgrade = WineYears.YEARS_PER_EFFECT_LEVEL * WineYears.DAYS_PER_YEAR - ageDays % (WineYears.YEARS_PER_EFFECT_LEVEL * WineYears.DAYS_PER_YEAR);
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.vinery.next_upgrade", (Object[])new Object[]{daysToNextUpgrade}).method_27694(style -> style.method_27703(class_5251.method_27717((int)9684093))));
        }
        tooltip.add((class_2561)class_2561.method_43471((String)("tooltip.vinery.bottle_size." + this.bottleSize.name().toLowerCase())).method_27695(new class_124[]{class_124.field_1063, class_124.field_1056}));
    }

    @Environment(value=EnvType.CLIENT)
    private class_1937 getLevel() {
        return class_310.method_1551().field_1687;
    }

    @NotNull
    public class_1799 method_7861(class_1799 itemStack, class_1937 level, class_1309 livingEntity) {
        if (!level.field_9236 && this.effectSupplier != null) {
            int duration = this.scaleDurationWithAge ? Math.max(0, WineYears.getEffectDuration(itemStack, level)) : this.baseDuration;
            int amplifier = this.scaleDurationWithAge ? Math.max(0, WineYears.getEffectLevel(itemStack, level)) : this.baseAmplifier;
            class_6880<class_1291> effectHolder = this.effectSupplier.get();
            class_1291 effect = (class_1291)effectHolder.comp_349();
            class_6880 registryHolder = level.method_30349().method_30530(class_7924.field_41208).method_47983((Object)effect);
            livingEntity.method_6092(new class_1293(registryHolder, duration, amplifier));
        }
        itemStack.method_7934(1);
        return GeneralUtil.convertStackAfterFinishUsing(livingEntity, itemStack, (class_1792)ObjectRegistry.WINE_BOTTLE.get(), (class_1792)this);
    }

    private String formatDuration(int ticks) {
        int totalSeconds = Math.max(0, ticks) / 20;
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        return String.format("%d:%02d", minutes, seconds);
    }

    @NotNull
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 interactionHand) {
        return class_5328.method_29282((class_1937)level, (class_1657)player, (class_1268)interactionHand);
    }

    public void method_54465(class_1799 stack, class_1937 world, class_1657 player) {
        super.method_54465(stack, world, player);
        WineYears.setWineYear(stack, world);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
        if (world != null && !world.field_9236) {
            if (stack.method_57824((class_9331)DataComponentRegistry.WINE_YEAR.get()) == null) {
                WineYears.setWineYear(stack, world);
            } else if (world.method_8510() % 200L == 0L) {
                WineYears.refreshCached(stack, world);
            }
        }
    }

    private String toRoman(int number) {
        return switch (number) {
            case 1 -> "I";
            case 2 -> "II";
            case 3 -> "III";
            case 4 -> "IV";
            case 5 -> "V";
            case 6 -> "VI";
            case 7 -> "VII";
            case 8 -> "VIII";
            case 9 -> "IX";
            case 10 -> "X";
            default -> String.valueOf(number);
        };
    }

    public static enum BottleSize {
        SMALL,
        BIG;

    }
}

