/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1662;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.satisfy.vinery.core.recipe.input.FermentationBarrelRecipeInput;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.registry.RecipeTypesRegistry;
import org.jetbrains.annotations.NotNull;

public class FermentationBarrelRecipe
implements class_1860<FermentationBarrelRecipeInput> {
    private final class_2371<class_1856> inputs;
    private final class_1799 output;
    private final FermentationBarrelRecipeInput.JuiceData juiceData;
    private final boolean wineBottleRequired;
    public static class_3956<FermentationBarrelRecipe> Type = (class_3956)RecipeTypesRegistry.FERMENTATION_BARREL_RECIPE_TYPE.get();

    public FermentationBarrelRecipe(class_2371<class_1856> inputs, FermentationBarrelRecipeInput.JuiceData data, class_1799 output, boolean wineBottleRequired) {
        this.inputs = inputs;
        this.juiceData = data;
        this.output = output;
        this.wineBottleRequired = wineBottleRequired;
    }

    public FermentationBarrelRecipeInput.JuiceData getJuiceData() {
        return this.juiceData;
    }

    public boolean isWineBottleRequired() {
        return this.wineBottleRequired;
    }

    public boolean matches(FermentationBarrelRecipeInput input, class_1937 world) {
        class_1799 wineBottle;
        if (this.juiceData.amount() > 0) {
            if (input.data().amount() < this.juiceData.amount()) {
                return false;
            }
            if (!this.juiceData.type().equals(input.data().type())) {
                return false;
            }
        }
        if (this.wineBottleRequired && ((wineBottle = input.method_59984(0)).method_7960() || !wineBottle.method_31574((class_1792)ObjectRegistry.WINE_BOTTLE.get()))) {
            return false;
        }
        class_1662 recipeMatcher = new class_1662();
        int matchingStacks = 0;
        for (int i = 0; i < input.getIngredientSlots().size(); ++i) {
            class_1799 itemStack = input.getIngredientSlots().get(i);
            if (itemStack.method_7960()) continue;
            ++matchingStacks;
            recipeMatcher.method_20478(itemStack, 1);
        }
        return matchingStacks == this.inputs.size() && recipeMatcher.method_7402((class_1860)this, null);
    }

    @NotNull
    public class_1799 assemble(FermentationBarrelRecipeInput input, class_7225.class_7874 registryAccess) {
        return this.output.method_7972();
    }

    @NotNull
    public class_2371<class_1856> method_8117() {
        return this.inputs;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    @NotNull
    public class_1799 method_8110(class_7225.class_7874 registryAccess) {
        return this.output.method_7972();
    }

    public class_2371<class_1856> getInputs() {
        return this.inputs;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return (class_1865)RecipeTypesRegistry.FERMENTATION_BARREL_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public class_3956<?> method_17716() {
        return (class_3956)RecipeTypesRegistry.FERMENTATION_BARREL_RECIPE_TYPE.get();
    }

    public boolean method_8118() {
        return true;
    }

    public static class Serializer
    implements class_1865<FermentationBarrelRecipe> {
        private static final MapCodec<Boolean> WINE_BOTTLE_CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.BOOL.fieldOf("required").forGetter(b -> b)).apply((Applicative)inst, b -> b));

        public MapCodec<FermentationBarrelRecipe> method_53736() {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1856.field_46095.listOf().fieldOf("ingredients").xmap(list -> class_2371.method_10212((Object)class_1856.field_9017, (Object[])list.toArray(new class_1856[0])), ingredients -> ingredients).forGetter(FermentationBarrelRecipe::getInputs), (App)FermentationBarrelRecipeInput.JuiceData.CODEC.fieldOf("juice").forGetter(FermentationBarrelRecipe::getJuiceData), (App)class_1799.field_24671.fieldOf("result").forGetter(r -> r.output), (App)WINE_BOTTLE_CODEC.fieldOf("wine_bottle").forGetter(FermentationBarrelRecipe::isWineBottleRequired)).apply((Applicative)instance, FermentationBarrelRecipe::new));
        }

        public class_9139<class_9129, FermentationBarrelRecipe> method_56104() {
            return class_9139.method_56437((buf, recipe) -> {
                buf.method_10804(recipe.inputs.size());
                for (class_1856 ingredient : recipe.inputs) {
                    class_1856.field_48355.encode(buf, (Object)ingredient);
                }
                FermentationBarrelRecipeInput.JuiceData.STREAM_CODEC.encode(buf, (Object)recipe.getJuiceData());
                class_1799.field_48349.encode(buf, (Object)recipe.output);
                buf.method_52964(recipe.wineBottleRequired);
            }, buf -> {
                int size = buf.method_10816();
                class_2371 inputs = class_2371.method_10213((int)size, (Object)class_1856.field_9017);
                for (int i = 0; i < size; ++i) {
                    inputs.set(i, (Object)((class_1856)class_1856.field_48355.decode(buf)));
                }
                FermentationBarrelRecipeInput.JuiceData juiceData = (FermentationBarrelRecipeInput.JuiceData)FermentationBarrelRecipeInput.JuiceData.STREAM_CODEC.decode(buf);
                class_1799 output = (class_1799)class_1799.field_48349.decode(buf);
                boolean wineBottleRequired = buf.readBoolean();
                return new FermentationBarrelRecipe((class_2371<class_1856>)inputs, juiceData, output, wineBottleRequired);
            });
        }
    }
}

