/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_4174;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class FoodComponent {
    private final int nutrition;
    private final float saturationModifier;
    private final boolean canAlwaysEat;
    private final float eatSeconds;
    private final Optional<class_1799> usingConvertsTo;
    private final List<class_4174.class_9423> effects;
    private final class_4174 foodProperties;
    public static final Codec<FoodComponent> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_33441.fieldOf("nutrition").forGetter(FoodComponent::nutrition), (App)Codec.FLOAT.fieldOf("saturation").forGetter(FoodComponent::saturationModifier), (App)Codec.BOOL.optionalFieldOf("can_always_eat", (Object)false).forGetter(FoodComponent::canAlwaysEat), (App)class_5699.field_34387.optionalFieldOf("eat_seconds", (Object)Float.valueOf(1.6f)).forGetter(FoodComponent::eatSeconds), (App)class_1799.field_49747.optionalFieldOf("using_converts_to").forGetter(FoodComponent::usingConvertsTo), (App)class_4174.class_9423.field_49996.listOf().optionalFieldOf("effects", List.of()).forGetter(FoodComponent::getEffects)).apply((Applicative)instance, FoodComponent::new));
    public static final class_9139<class_9129, FoodComponent> DIRECT_STREAM_CODEC = class_9139.method_58025((class_9139)class_9135.field_48550, FoodComponent::nutrition, (class_9139)class_9135.field_48552, FoodComponent::saturationModifier, (class_9139)class_9135.field_48547, FoodComponent::canAlwaysEat, (class_9139)class_9135.field_48552, FoodComponent::eatSeconds, (class_9139)class_1799.field_48349.method_56433(class_9135::method_56382), FoodComponent::usingConvertsTo, (class_9139)class_4174.class_9423.field_49997.method_56433(class_9135.method_56363()), FoodComponent::getEffects, FoodComponent::new);

    public FoodComponent(int nutrition, float saturationModifier, boolean canAlwaysEat, float eatSeconds, Optional<class_1799> usingConvertsTo, List<class_4174.class_9423> effects) {
        this.nutrition = nutrition;
        this.saturationModifier = saturationModifier;
        this.canAlwaysEat = canAlwaysEat;
        this.eatSeconds = eatSeconds;
        this.usingConvertsTo = usingConvertsTo;
        this.effects = effects;
        class_4174.class_4175 builder = new class_4174.class_4175().method_19238(nutrition).method_19237(saturationModifier);
        if (canAlwaysEat) {
            builder.method_19240();
        }
        for (class_4174.class_9423 effect : effects) {
            builder.method_19239(effect.comp_2496(), effect.comp_2497());
        }
        this.foodProperties = builder.method_19242();
    }

    public FoodComponent(List<class_4174.class_9423> statusEffects) {
        this(1, 0.0f, true, 1.6f, Optional.empty(), statusEffects);
    }

    public FoodComponent(int nutrition, float saturationModifier, boolean canAlwaysEat, boolean fastFood, boolean meat, List<class_4174.class_9423> statusEffects) {
        this.nutrition = nutrition;
        this.saturationModifier = saturationModifier;
        this.canAlwaysEat = canAlwaysEat;
        this.eatSeconds = fastFood ? 0.8f : 1.6f;
        this.usingConvertsTo = Optional.empty();
        this.effects = statusEffects;
        class_4174.class_4175 builder = new class_4174.class_4175().method_19238(nutrition).method_19237(saturationModifier);
        if (canAlwaysEat) {
            builder.method_19240();
        }
        if (fastFood) {
            builder.method_19241();
        }
        for (class_4174.class_9423 effect : statusEffects) {
            builder.method_19239(effect.comp_2496(), effect.comp_2497());
        }
        this.foodProperties = builder.method_19242();
    }

    public List<class_4174.class_9423> getEffects() {
        return this.effects;
    }

    public class_4174 getFoodProperties() {
        return this.foodProperties;
    }

    public int nutrition() {
        return this.nutrition;
    }

    public int getNutrition() {
        return this.nutrition;
    }

    public float saturationModifier() {
        return this.saturationModifier;
    }

    public float getSaturationModifier() {
        return this.saturationModifier;
    }

    public boolean canAlwaysEat() {
        return this.canAlwaysEat;
    }

    public float eatSeconds() {
        return this.eatSeconds;
    }

    public Optional<class_1799> usingConvertsTo() {
        return this.usingConvertsTo;
    }

    public boolean isFastFood() {
        return this.eatSeconds < 1.6f;
    }
}

