/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.util;

import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_9331;
import net.satisfy.vinery.core.components.WineYearComponent;
import net.satisfy.vinery.core.registry.DataComponentRegistry;
import net.satisfy.vinery.platform.PlatformHelper;

public class WineYears {
    public static final int YEARS_START = 0;
    public static final int MAX_LEVEL = PlatformHelper.getWineMaxLevel();
    public static final int START_DURATION = PlatformHelper.getWineStartDuration();
    public static final int DURATION_PER_YEAR = PlatformHelper.getWineDurationPerYear();
    public static final int DAYS_PER_YEAR = PlatformHelper.getWineDaysPerYear();
    public static final int YEARS_PER_EFFECT_LEVEL = PlatformHelper.getWineYearsPerEffectLevel();
    public static final int MAX_DURATION = PlatformHelper.getWineMaxDuration();

    public static int getYear(class_1937 world) {
        return world != null ? 0 + (int)(world.method_8510() / 24000L / (long)DAYS_PER_YEAR) : 0;
    }

    public static int getDays(class_1937 world) {
        return world != null ? (int)(world.method_8510() / 24000L) : 0;
    }

    public static int getWineAge(class_1799 wine, class_1937 world) {
        int y = WineYears.hasWineYear(wine) ? WineYears.getWineYear(wine) : 0;
        return Math.max(0, WineYears.getYear(world) - y);
    }

    public static int getWineAgeDays(class_1799 wine, class_1937 world) {
        int y = WineYears.hasWineYear(wine) ? WineYears.getWineYear(wine) : 0;
        return Math.max(0, WineYears.getDays(world) - y * DAYS_PER_YEAR);
    }

    public static int getEffectLevel(class_1799 wine, class_1937 world) {
        int age = WineYears.getWineAge(wine, world);
        return Math.max(0, Math.min(MAX_LEVEL, YEARS_PER_EFFECT_LEVEL > 0 ? age / YEARS_PER_EFFECT_LEVEL : 0));
    }

    public static int getEffectDuration(class_1799 wine, class_1937 world) {
        int age = WineYears.getWineAge(wine, world);
        return Math.min(MAX_DURATION, Math.max(0, START_DURATION + DURATION_PER_YEAR * age));
    }

    public static void setWineYear(class_1799 wine, class_1937 world) {
        int year = world != null ? WineYears.getYear(world) : 0;
        int amplifier = WineYears.getEffectLevel(wine, world);
        int duration = WineYears.getEffectDuration(wine, world);
        wine.method_57379((class_9331)DataComponentRegistry.WINE_YEAR.get(), (Object)new WineYearComponent(year, amplifier, duration));
    }

    public static void refreshCached(class_1799 wine, class_1937 world) {
        WineYearComponent existing = (WineYearComponent)wine.method_57824((class_9331)DataComponentRegistry.WINE_YEAR.get());
        int year = existing != null ? existing.year() : WineYears.getYear(world);
        int amplifier = WineYears.getEffectLevel(wine, world);
        int duration = WineYears.getEffectDuration(wine, world);
        wine.method_57379((class_9331)DataComponentRegistry.WINE_YEAR.get(), (Object)new WineYearComponent(year, amplifier, duration));
    }

    public static int getWineYear(class_1799 wine) {
        WineYearComponent comp = (WineYearComponent)wine.method_57824((class_9331)DataComponentRegistry.WINE_YEAR.get());
        return comp != null ? comp.year() : 0;
    }

    public static boolean hasWineYear(class_1799 wine) {
        return wine.method_57824((class_9331)DataComponentRegistry.WINE_YEAR.get()) != null;
    }
}

