/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dmc_improvements.init;

import net.mcreator.dmc_improvements.entity.BoulderingZombieEntity;
import net.mcreator.dmc_improvements.entity.EnderGhastEntity;
import net.mcreator.dmc_improvements.entity.GargamelEntity;
import net.mcreator.dmc_improvements.entity.HerobrineEntity;
import net.mcreator.dmc_improvements.entity.MoobloomEntity;
import net.mcreator.dmc_improvements.entity.MoolipEntity;
import net.mcreator.dmc_improvements.entity.MuddyPigEntity;
import net.mcreator.dmc_improvements.entity.PapaSmurfEntity;
import net.mcreator.dmc_improvements.entity.PebbleProjectileEntity;
import net.mcreator.dmc_improvements.entity.SmurfetteEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class DmcImprovementsModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"dmc_improvements");
    public static final DeferredHolder<EntityType<?>, EntityType<EnderGhastEntity>> ENDER_GHAST = DmcImprovementsModEntities.register("ender_ghast", EntityType.Builder.of(EnderGhastEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.95f, 0.95f));
    public static final DeferredHolder<EntityType<?>, EntityType<HerobrineEntity>> HEROBRINE = DmcImprovementsModEntities.register("herobrine", EntityType.Builder.of(HerobrineEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(70).setUpdateInterval(3).fireImmune().ridingOffset(-0.6f).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<BoulderingZombieEntity>> BOULDERING_ZOMBIE = DmcImprovementsModEntities.register("bouldering_zombie", EntityType.Builder.of(BoulderingZombieEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).ridingOffset(-0.6f).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<MoobloomEntity>> MOOBLOOM = DmcImprovementsModEntities.register("moobloom", EntityType.Builder.of(MoobloomEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.9f, 1.4f));
    public static final DeferredHolder<EntityType<?>, EntityType<MoolipEntity>> MOOLIP = DmcImprovementsModEntities.register("moolip", EntityType.Builder.of(MoolipEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.9f, 1.4f));
    public static final DeferredHolder<EntityType<?>, EntityType<PebbleProjectileEntity>> PEBBLE_PROJECTILE = DmcImprovementsModEntities.register("pebble_projectile", EntityType.Builder.of(PebbleProjectileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<PapaSmurfEntity>> PAPA_SMURF = DmcImprovementsModEntities.register("papa_smurf", EntityType.Builder.of(PapaSmurfEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).ridingOffset(-0.6f).sized(0.2f, 0.6f));
    public static final DeferredHolder<EntityType<?>, EntityType<GargamelEntity>> GARGAMEL = DmcImprovementsModEntities.register("gargamel", EntityType.Builder.of(GargamelEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).ridingOffset(-0.6f).sized(0.6f, 2.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<MuddyPigEntity>> MUDDY_PIG = DmcImprovementsModEntities.register("muddy_pig", EntityType.Builder.of(MuddyPigEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.9f, 0.9f));
    public static final DeferredHolder<EntityType<?>, EntityType<SmurfetteEntity>> SMURFETTE = DmcImprovementsModEntities.register("smurfette", EntityType.Builder.of(SmurfetteEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).ridingOffset(-0.6f).sized(0.2f, 0.6f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        EnderGhastEntity.init(event);
        HerobrineEntity.init(event);
        BoulderingZombieEntity.init(event);
        MoobloomEntity.init(event);
        MoolipEntity.init(event);
        PapaSmurfEntity.init(event);
        GargamelEntity.init(event);
        MuddyPigEntity.init(event);
        SmurfetteEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)ENDER_GHAST.get(), EnderGhastEntity.createAttributes().build());
        event.put((EntityType)HEROBRINE.get(), HerobrineEntity.createAttributes().build());
        event.put((EntityType)BOULDERING_ZOMBIE.get(), BoulderingZombieEntity.createAttributes().build());
        event.put((EntityType)MOOBLOOM.get(), MoobloomEntity.createAttributes().build());
        event.put((EntityType)MOOLIP.get(), MoolipEntity.createAttributes().build());
        event.put((EntityType)PAPA_SMURF.get(), PapaSmurfEntity.createAttributes().build());
        event.put((EntityType)GARGAMEL.get(), GargamelEntity.createAttributes().build());
        event.put((EntityType)MUDDY_PIG.get(), MuddyPigEntity.createAttributes().build());
        event.put((EntityType)SMURFETTE.get(), SmurfetteEntity.createAttributes().build());
    }
}

