/*
 * Decompiled with CFR 0.152.
 */
package me.bymartrixx.vtd.data;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.bymartrixx.vtd.data.Pack;
import org.jetbrains.annotations.Nullable;

@JsonAdapter(value=CustomTypeAdapterFactory.class)
public class Category {
    public static final List<String> HARD_INCOMPATIBLE_CATEGORIES = List.of("Crosshairs", "Hearts", "Hunger Bars", "Menu Panoramas", "Options Backgrounds", "Slimes", "Elytra", "Enchantment Glints");
    @SerializedName(value="category")
    private final String name;
    @SerializedName(value="categories")
    @Nullable
    private List<SubCategory> subCategories;
    private final List<Pack> packs;
    @Nullable
    private Warning warning = null;
    private boolean hardIncompatible = false;
    private Map<String, Pack> packsById;

    public Category(String name, List<Pack> packs) {
        this.name = name;
        this.packs = packs;
        this.buildPacksById();
    }

    public Category(String name, @Nullable List<SubCategory> subCategories, List<Pack> packs) {
        this(name, packs);
        this.subCategories = subCategories;
    }

    public Category(String name, List<Pack> packs, @Nullable Warning warning) {
        this(name, packs);
        this.warning = warning;
    }

    public Category(String name, @Nullable List<SubCategory> subCategories, List<Pack> packs, @Nullable Warning warning) {
        this(name, subCategories, packs);
        this.warning = warning;
    }

    public Category(String name, List<Pack> packs, @Nullable Warning warning, boolean hardIncompatible) {
        this(name, packs, warning);
        this.hardIncompatible = hardIncompatible;
    }

    public Category(String name, @Nullable List<SubCategory> subCategories, List<Pack> packs, @Nullable Warning warning, boolean hardIncompatible) {
        this(name, subCategories, packs, warning);
        this.hardIncompatible = hardIncompatible;
    }

    private void buildPacksById() {
        if (this.packsById != null) {
            return;
        }
        this.packsById = new HashMap<String, Pack>();
        for (Pack pack : this.packs) {
            this.packsById.put(pack.getId(), pack);
        }
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public List<SubCategory> getSubCategories() {
        return this.subCategories;
    }

    public List<Pack> getPacks() {
        return this.packs;
    }

    @Nullable
    public Warning getWarning() {
        return this.warning;
    }

    public Pack getPack(String id) {
        this.buildPacksById();
        return this.packsById.get(id);
    }

    public boolean hasWarning() {
        return this.warning != null;
    }

    public List<String> getPackIds() {
        return this.getPacks().stream().map(Pack::getId).toList();
    }

    public boolean isHardIncompatible() {
        return this.hardIncompatible || HARD_INCOMPATIBLE_CATEGORIES.contains(this.getName());
    }

    public String getId() {
        return this.name.toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9]", "-");
    }

    public String toString() {
        return this.name;
    }

    public static class Warning {
        private final String text;
        private final String color;

        public Warning(String text, String color) {
            this.text = text;
            this.color = color;
        }

        public String getText() {
            return this.text;
        }

        public String getColor() {
            return this.color;
        }
    }

    static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        CustomTypeAdapterFactory() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            final TypeAdapter defaultAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            return new TypeAdapter<T>(this){

                public void write(JsonWriter out, T value) throws IOException {
                    defaultAdapter.write(out, value);
                }

                private void linkSubCategories(Category category) {
                    if (category.getSubCategories() != null && !category.getSubCategories().isEmpty()) {
                        for (SubCategory subCategory : category.getSubCategories()) {
                            subCategory.parent = category;
                            this.linkSubCategories(subCategory);
                        }
                    }
                }

                public T read(JsonReader in) throws IOException {
                    Object result = defaultAdapter.read(in);
                    if (result instanceof Category) {
                        Category category = (Category)result;
                        this.linkSubCategories(category);
                    }
                    return result;
                }
            };
        }
    }

    public static class SubCategory
    extends Category {
        private Category parent;

        public SubCategory(String name, List<Pack> packs) {
            super(name, packs);
        }

        public SubCategory(String name, List<Pack> packs, @Nullable Warning warning) {
            super(name, packs, warning);
        }

        public SubCategory(String name, List<Pack> packs, @Nullable Warning warning, boolean hardIncompatible) {
            super(name, packs, warning, hardIncompatible);
        }

        public Category getParent() {
            if (this.parent == null) {
                throw new IllegalStateException("Parent category for '" + this.getName() + "' is null");
            }
            return this.parent;
        }

        @Override
        public String getId() {
            return this.getParent().getId() + "." + super.getId();
        }

        @Override
        public String toString() {
            return this.getParent().toString() + " > " + super.toString();
        }
    }
}

