/*
 * Decompiled with CFR 0.152.
 */
package me.bymartrixx.vtd.data;

import java.util.ArrayDeque;
import java.util.List;
import me.bymartrixx.vtd.data.Category;
import me.bymartrixx.vtd.data.Pack;
import org.jetbrains.annotations.Nullable;

public class RpCategories {
    private final List<Category> categories;
    @Nullable
    private List<Category> allCategories;

    public RpCategories(List<Category> categories) {
        this.categories = categories;
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    private List<Category> getAllCategories() {
        if (this.allCategories != null) {
            return this.allCategories;
        }
        this.allCategories = this.categories.stream().mapMulti((category, consumer) -> {
            consumer.accept(category);
            ArrayDeque<Category> categories = new ArrayDeque<Category>();
            categories.add((Category)category);
            while (!categories.isEmpty()) {
                Category cat = (Category)categories.pop();
                if (cat.getSubCategories() == null) continue;
                cat.getSubCategories().forEach(consumer);
                categories.addAll(cat.getSubCategories());
            }
        }).toList();
        return this.allCategories;
    }

    @Nullable
    public Pack findPack(String id) {
        for (Category category : this.getAllCategories()) {
            Pack pack = category.getPack(id);
            if (pack == null) continue;
            return pack;
        }
        return null;
    }

    @Nullable
    public Category getCategory(Pack pack) {
        for (Category category : this.getAllCategories()) {
            if (!category.getPacks().contains(pack)) continue;
            return category;
        }
        return null;
    }
}

