/*
 * Decompiled with CFR 0.152.
 */
package me.bymartrixx.vtd.gui.widget;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.bymartrixx.vtd.VTDMod;
import me.bymartrixx.vtd.data.Category;
import me.bymartrixx.vtd.data.Pack;
import me.bymartrixx.vtd.gui.widget.PackSelectionData;
import me.bymartrixx.vtd.gui.widget.PackSelectionListWidget;
import org.jetbrains.annotations.VisibleForTesting;

public class PackSelectionHelper {
    public static final int DEFAULT_SELECTION_COLOR = -268435456;
    private static final List<Integer> INCOMPATIBLE_SELECTION_COLORS = List.of(Integer.valueOf(-16744793), Integer.valueOf(-98515), Integer.valueOf(-16711739), Integer.valueOf(-5963743), Integer.valueOf(-1082555), Integer.valueOf(-6763008), Integer.valueOf(-15277891), Integer.valueOf(-610771), Integer.valueOf(-2224750), Integer.valueOf(-3062459));
    private final List<String> selection = new ArrayList<String>();
    private final List<IncompatibilityGroup> allIncompatibilityGroups = new ArrayList<IncompatibilityGroup>();
    private final Multimap<String, IncompatibilityGroup> incompatibilityGroups = LinkedHashMultimap.create();
    @VisibleForTesting
    protected final Map<IncompatibilityGroup, Integer> usedColors = new HashMap<IncompatibilityGroup, Integer>();
    private SelectionChangeCallback selectionChangeCallback = (pack, category, selected) -> {};

    public void buildIncompatibilityGroups(List<Category> categories) {
        this.allIncompatibilityGroups.clear();
        this.incompatibilityGroups.clear();
        this.usedColors.clear();
        ArrayList<Pack> packs = new ArrayList<Pack>();
        for (Category category : categories) {
            this.collectCategoryPacks(packs, category);
        }
        for (Pack pack : packs) {
            int i = this.allIncompatibilityGroups.indexOf(pack);
            if (i == -1) {
                this.allIncompatibilityGroups.add(new DefaultIncompatibilityGroup(pack));
                continue;
            }
            ((DefaultIncompatibilityGroup)this.allIncompatibilityGroups.get((int)i)).bases.add(pack.getId());
        }
        for (IncompatibilityGroup group : this.allIncompatibilityGroups) {
            for (String id : group.getIds()) {
                this.incompatibilityGroups.put((Object)id, (Object)group);
            }
        }
    }

    private void collectCategoryPacks(List<Pack> packs, Category category) {
        if (category.getSubCategories() != null && !category.getSubCategories().isEmpty()) {
            for (Category category2 : category.getSubCategories()) {
                this.collectCategoryPacks(packs, category2);
            }
        }
        if (category.isHardIncompatible()) {
            this.allIncompatibilityGroups.add(new CategoryIncompatibilityGroup(category));
            return;
        }
        packs.addAll(category.getPacks());
    }

    public void toggleSelection(PackSelectionListWidget.PackEntry entry) {
        boolean selected;
        Pack pack = entry.getPack();
        PackSelectionData data = entry.selectionData;
        if (this.selection.remove(pack.getId())) {
            selected = false;
        } else {
            this.selection.add(pack.getId());
            selected = true;
        }
        this.selectionChangeCallback.onSelectionChanged(pack, data.getCategory(), selected);
        if (selected != data.isSelected()) {
            data.toggleSelection();
        }
        for (IncompatibilityGroup group : this.incompatibilityGroups.get((Object)pack.getId())) {
            if (!this.usedColors.containsKey(group) || group.hasIncompatibility(this.selection)) continue;
            this.usedColors.remove(group);
        }
    }

    public int getSelectionColor(Pack pack) {
        Collection groups = this.incompatibilityGroups.get((Object)pack.getId());
        return groups.stream().sorted(Comparator.comparingInt(IncompatibilityGroup::size)).filter(group -> group.hasIncompatibility(this.selection)).findFirst().map(group -> this.usedColors.computeIfAbsent((IncompatibilityGroup)group, g -> this.getNextColor())).orElse(-268435456);
    }

    private int getNextColor() {
        for (int color : INCOMPATIBLE_SELECTION_COLORS) {
            if (this.usedColors.containsValue(color)) continue;
            return color;
        }
        return INCOMPATIBLE_SELECTION_COLORS.get(0);
    }

    public void addCallback(SelectionChangeCallback callback) {
        SelectionChangeCallback prev = this.selectionChangeCallback;
        this.selectionChangeCallback = (pack, category, selected) -> {
            prev.onSelectionChanged(pack, category, selected);
            callback.onSelectionChanged(pack, category, selected);
        };
    }

    protected void setSelectionChangeCallback(SelectionChangeCallback callback) {
        this.selectionChangeCallback = callback;
    }

    public boolean isSelected(Pack pack) {
        return this.selection.contains(pack.getId());
    }

    protected List<String> getSelection() {
        return this.selection;
    }

    public boolean hasSelection() {
        return !this.selection.isEmpty();
    }

    public void setSelection(List<String> selection) {
        this.selection.clear();
        this.selection.addAll(selection);
    }

    public void cleanUpSelection() {
        List<String> validPacks = this.selection.stream().map(VTDMod.rpCategories::findPack).filter(Objects::nonNull).map(Pack::getId).toList();
        this.selection.retainAll(validPacks);
    }

    public Map<Category, List<Pack>> getSelectedPacks() {
        return this.selection.stream().map(VTDMod.rpCategories::findPack).filter(Objects::nonNull).map(p -> new AbstractMap.SimpleEntry<Category, Pack>(VTDMod.rpCategories.getCategory((Pack)p), (Pack)p)).collect(Collectors.groupingBy(Map.Entry::getKey, LinkedHashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    public Map<String, List<String>> getSelectedPacksPrimitive() {
        return this.selection.stream().map(VTDMod.rpCategories::findPack).filter(Objects::nonNull).map(p -> new AbstractMap.SimpleEntry<Category, Pack>(VTDMod.rpCategories.getCategory((Pack)p), (Pack)p)).map(e -> new AbstractMap.SimpleEntry<String, String>(((Category)e.getKey()).getId(), ((Pack)e.getValue()).getId())).collect(Collectors.groupingBy(Map.Entry::getKey, LinkedHashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    public static interface SelectionChangeCallback {
        public void onSelectionChanged(Pack var1, Category var2, boolean var3);
    }

    protected static class DefaultIncompatibilityGroup
    implements IncompatibilityGroup {
        private final Set<String> ids = new HashSet<String>();
        private final Set<String> bases = new HashSet<String>();

        private DefaultIncompatibilityGroup(Pack pack) {
            this.ids.add(pack.getId());
            this.ids.addAll(pack.getIncompatiblePacks());
            this.bases.add(pack.getId());
        }

        @Override
        public Set<String> getIds() {
            return this.ids;
        }

        private int countBases(List<String> packs) {
            ArrayList<String> match = new ArrayList<String>(this.bases);
            match.retainAll(packs);
            return match.size();
        }

        @Override
        public boolean hasIncompatibility(List<String> packs) {
            return this.countBases(packs) >= 1 && this.count(packs) > 1;
        }

        @Override
        public int size() {
            return this.ids.size();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof DefaultIncompatibilityGroup) {
                DefaultIncompatibilityGroup group = (DefaultIncompatibilityGroup)obj;
                return this.ids.equals(group.ids);
            }
            if (obj instanceof Pack) {
                Pack pack = (Pack)obj;
                List<String> packs = pack.getIncompatiblePacks();
                return this.ids.contains(pack.getId()) && this.ids.containsAll(packs) && this.ids.size() == packs.size() + 1;
            }
            return super.equals(obj);
        }

        public String toString() {
            return this.ids.toString();
        }
    }

    protected static interface IncompatibilityGroup {
        public Set<String> getIds();

        public boolean hasIncompatibility(List<String> var1);

        public int size();

        default public int count(List<String> packs) {
            ArrayList<String> match = new ArrayList<String>(this.getIds());
            match.retainAll(packs);
            return match.size();
        }
    }

    protected static class CategoryIncompatibilityGroup
    implements IncompatibilityGroup {
        private final String category;
        private final Set<String> ids = new HashSet<String>();

        private CategoryIncompatibilityGroup(Category category) {
            this.category = category.getName();
            this.ids.addAll(category.getPackIds());
        }

        @Override
        public Set<String> getIds() {
            return this.ids;
        }

        @Override
        public boolean hasIncompatibility(List<String> packs) {
            return this.count(packs) > 1;
        }

        @Override
        public int size() {
            return this.ids.size();
        }

        public String toString() {
            return "(Category) " + this.category;
        }
    }
}

