/*
 * Decompiled with CFR 0.152.
 */
package me.bymartrixx.vtd.gui.widget;

import java.util.List;
import java.util.Map;
import me.bymartrixx.vtd.data.Category;
import me.bymartrixx.vtd.data.Pack;
import me.bymartrixx.vtd.gui.VTDownloadScreen;
import me.bymartrixx.vtd.gui.widget.PackSelectionHelper;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import net.minecraft.class_6381;
import net.minecraft.class_6382;

public class SelectedPacksListWidget
extends class_350<AbstractEntry> {
    private static final class_2561 HEADER = class_2561.method_43471((String)"vtd.selectedPacks").method_27695(new class_124[]{class_124.field_1067, class_124.field_1073});
    private static final int ITEM_HEIGHT = 16;
    private static final int HEADER_HEIGHT = 16;
    private static final int ROW_LEFT_RIGHT_MARGIN = 4;
    private static final int SCROLLBAR_LEFT_MARGIN = 4;
    private final VTDownloadScreen screen;
    private final PackSelectionHelper selectionHelper;
    private boolean extended = false;

    public SelectedPacksListWidget(VTDownloadScreen screen, class_310 client, int width, int height, int x, int y, PackSelectionHelper selectionHelper) {
        super(client, width, height, y, 16, 16);
        this.screen = screen;
        this.selectionHelper = selectionHelper;
        this.method_46421(x);
        selectionHelper.addCallback(this::updateSelection);
        this.addPacks(selectionHelper.getSelectedPacks());
    }

    public boolean isExtended() {
        return this.extended;
    }

    public boolean toggleExtended() {
        this.extended = !this.extended;
        return this.extended;
    }

    public void update() {
        this.method_25339();
        this.addPacks(this.selectionHelper.getSelectedPacks());
    }

    private void updateSelection(Pack pack, Category category, boolean selected) {
        int lastChildIndex;
        if (selected) {
            CategoryEntry categoryEntry = this.getOrCreateCategoryEntry(category);
            PackEntry entry = this.getPackEntry(pack, category);
            int i = this.getLastChildEntryIndex(category);
            if (i == -1) {
                i = this.method_25396().indexOf((Object)categoryEntry);
            }
            this.method_25396().add(i + 1, entry);
            return;
        }
        int i = this.getPackEntryIndex(pack);
        if (i == -1) {
            return;
        }
        this.method_25396().remove(i);
        int categoryIndex = this.getCategoryEntryIndex(category);
        if (categoryIndex != -1 && (lastChildIndex = this.getLastChildIndex(category)) == -1) {
            this.method_25396().remove(categoryIndex);
        }
        this.method_65506();
    }

    private void addPacks(Map<Category, List<Pack>> packs) {
        for (Category category : packs.keySet()) {
            packs.get(category).forEach(pack -> this.updateSelection((Pack)pack, category, true));
        }
    }

    private int getCategoryEntryIndex(Category category) {
        for (int i = 0; i < this.method_25396().size(); ++i) {
            if (!((Object)((Object)((AbstractEntry)((Object)this.method_25396().get(i))))).equals(category)) continue;
            return i;
        }
        return -1;
    }

    private CategoryEntry getOrCreateCategoryEntry(Category category) {
        int i = this.getCategoryEntryIndex(category);
        if (i == -1) {
            CategoryEntry entry;
            if (category instanceof Category.SubCategory) {
                Category.SubCategory subCategory = (Category.SubCategory)category;
                entry = new SubCategoryEntry(this, subCategory);
                CategoryEntry parentEntry = this.getOrCreateCategoryEntry(subCategory.getParent());
                int index = this.getLastChildIndex(parentEntry.getCategory());
                if (index != -1) {
                    this.method_25396().add(index + 1, entry);
                } else {
                    this.method_25321(entry);
                }
            } else {
                entry = new CategoryEntry(this, category);
                this.method_25321(entry);
            }
            return entry;
        }
        return (CategoryEntry)((Object)this.method_25396().get(i));
    }

    private int getPackEntryIndex(Pack pack) {
        for (int i = 0; i < this.method_25396().size(); ++i) {
            if (!((Object)((Object)((AbstractEntry)((Object)this.method_25396().get(i))))).equals(pack)) continue;
            return i;
        }
        return -1;
    }

    private PackEntry getPackEntry(Pack pack, Category category) {
        int i = this.getPackEntryIndex(pack);
        if (i == -1) {
            return new PackEntry(this, category, pack);
        }
        return (PackEntry)((Object)this.method_25396().get(i));
    }

    private int getLastChildEntryIndex(Category category) {
        int index = -1;
        int i = this.getCategoryEntryIndex(category);
        if (i != -1) {
            AbstractEntry entry;
            ++i;
            while (i < this.method_25396().size() && (entry = (AbstractEntry)((Object)this.method_25396().get(i))) instanceof PackEntry) {
                PackEntry packEntry = (PackEntry)entry;
                if (packEntry.category.equals(category)) {
                    index = i;
                }
                ++i;
            }
        }
        return index;
    }

    private int getLastSubCategoryIndex(Category category) {
        int index = -1;
        int i = this.getCategoryEntryIndex(category);
        if (i != -1 && !(category instanceof Category.SubCategory)) {
            AbstractEntry entry;
            ++i;
            while (i < this.method_25396().size() && (entry = (AbstractEntry)((Object)this.method_25396().get(i))) instanceof SubCategoryEntry) {
                SubCategoryEntry subCategoryEntry = (SubCategoryEntry)entry;
                if (subCategoryEntry.getParentCategory().equals(category)) {
                    index = i;
                }
                ++i;
            }
        }
        return index;
    }

    private int getLastChildIndex(Category category) {
        SubCategoryEntry entry;
        int subCatIndex;
        int subCat = this.getLastSubCategoryIndex(category);
        if (subCat != -1 && (subCatIndex = this.getLastChildEntryIndex((entry = (SubCategoryEntry)((Object)this.method_25396().get(subCat))).getParentCategory())) != -1) {
            return subCatIndex;
        }
        int index = this.getLastChildEntryIndex(category);
        if (index == -1 && subCat != -1) {
            return subCat;
        }
        return index;
    }

    protected boolean method_25332(int index) {
        return this.method_25336() == this.method_25326(index);
    }

    public int method_25322() {
        return this.field_22758 - 8 - 6 - 4;
    }

    public int method_25342() {
        return super.method_25342() - 4;
    }

    protected int method_65507() {
        return this.method_31383() + 4;
    }

    public boolean method_25370() {
        return this.screen.method_25399() == this;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.extended && super.method_25405(mouseX, mouseY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        AbstractEntry focusedEntry;
        if (this.method_25370() && (keyCode == 257 || keyCode == 335) && (focusedEntry = (AbstractEntry)this.method_25336()) != null) {
            focusedEntry.selectEntry();
        }
        return false;
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (!this.extended) {
            return;
        }
        super.method_48579(graphics, mouseX, mouseY, delta);
    }

    protected void method_25312(class_332 graphics, int x, int y) {
        graphics.method_27534(this.field_22740.field_1772, HEADER, this.method_25342() + this.method_25322() / 2, y, -1);
    }

    public void method_47399(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, HEADER);
    }

    public static class CategoryEntry
    extends AbstractEntry {
        protected final Category category;
        private long lastClickTime = -1L;

        public CategoryEntry(SelectedPacksListWidget widget, Category category) {
            super(widget);
            this.category = category;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0) {
                long time = System.currentTimeMillis();
                if (time <= this.lastClickTime + 250L) {
                    this.selectEntry();
                }
                this.lastClickTime = time;
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        @Override
        protected String getTextString() {
            return this.category.getName();
        }

        @Override
        protected void selectEntry() {
            this.widget.screen.selectCategory(this.category);
        }

        public Category getCategory() {
            return this.category;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof CategoryEntry) {
                CategoryEntry entry = (CategoryEntry)((Object)obj);
                return this.category.equals(entry.category);
            }
            if (obj instanceof Category) {
                Category c = (Category)obj;
                return this.category.equals(c);
            }
            return super.equals(obj);
        }
    }

    public static class PackEntry
    extends AbstractEntry {
        private static final String PREFIX_STRING = "> ";
        private final Category category;
        private final Pack pack;
        private int color = 0;
        private int lastChildrenCount = -1;
        private long lastClickTime = -1L;

        public PackEntry(SelectedPacksListWidget widget, Category category, Pack pack) {
            super(widget);
            this.category = category;
            this.pack = pack;
            this.textPrefix = PREFIX_STRING;
        }

        private int calculateColor() {
            int color = this.widget.selectionHelper.getSelectionColor(this.pack);
            return color != -268435456 ? color : -1;
        }

        @Override
        protected int getColor() {
            if (this.color != 0 && this.widget.method_25396().size() == this.lastChildrenCount) {
                return this.color;
            }
            this.lastChildrenCount = this.widget.method_25396().size();
            this.color = this.calculateColor();
            return this.color;
        }

        @Override
        protected String getTextString() {
            return this.pack.getName();
        }

        @Override
        protected void selectEntry() {
            this.widget.screen.goToPack(this.pack, this.category);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0) {
                long time = System.currentTimeMillis();
                if (time <= this.lastClickTime + 250L) {
                    this.selectEntry();
                }
                this.lastClickTime = time;
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof PackEntry) {
                PackEntry entry = (PackEntry)((Object)obj);
                return this.pack.equals(entry.pack);
            }
            if (obj instanceof Pack) {
                Pack p = (Pack)obj;
                return this.pack.equals(p);
            }
            return super.equals(obj);
        }
    }

    public static abstract class AbstractEntry
    extends class_350.class_351<AbstractEntry> {
        protected final class_310 client;
        protected final SelectedPacksListWidget widget;
        private class_2561 text;
        protected String textPrefix = null;

        protected AbstractEntry(SelectedPacksListWidget widget) {
            this.client = widget.field_22740;
            this.widget = widget;
        }

        protected abstract String getTextString();

        protected abstract void selectEntry();

        protected class_2561 getText() {
            if (this.text != null) {
                return this.text;
            }
            this.text = class_2561.method_30163((String)this.getTextString());
            return this.text;
        }

        protected int getColor() {
            return -1;
        }

        protected void drawScrollingText(class_332 graphics, int x, int y, int maxWidth, int height, int color) {
            class_327 textRenderer = this.client.field_1772;
            class_2561 text = this.getText();
            int textWidth = textRenderer.method_27525((class_5348)text);
            if (textWidth > maxWidth) {
                int extraWidth = textWidth - maxWidth;
                double seconds = (double)class_156.method_658() / 1000.0;
                double scrollWidth = Math.max((double)extraWidth * 0.5, 3.0);
                double delta = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * seconds / scrollWidth)) / 2.0 + 0.5;
                double scrollOffset = class_3532.method_16436((double)delta, (double)0.0, (double)extraWidth);
                graphics.method_44379(x, y, x + maxWidth, y + height);
                graphics.method_27535(textRenderer, text, x - (int)scrollOffset, y, color);
                graphics.method_44380();
            } else {
                graphics.method_27535(textRenderer, text, x, y, color);
            }
        }

        public void method_25343(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int color = this.getColor();
            graphics.method_25303(this.client.field_1772, this.textPrefix, x, y, color);
            int offsetX = this.client.field_1772.method_1727(this.textPrefix);
            if (offsetX > 0) {
                this.drawScrollingText(graphics, x + offsetX, y, entryWidth - (offsetX - x), entryHeight, color);
            } else {
                this.drawScrollingText(graphics, x, y, entryWidth, entryHeight, color);
            }
        }
    }

    public static class SubCategoryEntry
    extends CategoryEntry {
        private static final String PREFIX_STRING = "| ";

        public SubCategoryEntry(SelectedPacksListWidget widget, Category.SubCategory category) {
            super(widget, category);
            this.textPrefix = PREFIX_STRING;
        }

        @Override
        public Category.SubCategory getCategory() {
            return (Category.SubCategory)super.getCategory();
        }

        public Category getParentCategory() {
            return this.getCategory().getParent();
        }
    }
}

