/*
 * Decompiled with CFR 0.152.
 */
package me.bymartrixx.vtd.gui.widget;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import me.bymartrixx.vtd.util.RenderUtil;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import org.jetbrains.annotations.Nullable;

public class PackNameTextFieldWidget
extends class_342 {
    public static final String FILE_NAME_REGEX = "^[\\w,.\\s-]+$";
    private static final Pattern RESERVED_WINDOWS_NAME = Pattern.compile("^(?:COM|CLOCK\\$|CON|PRN|AUX|NUL|COM[1-9]|LPT[1-9])(?:\\..*)?$", 2);
    private static final Pattern INVALID_WINDOWS_NAME = Pattern.compile("^.*\\.$");
    private static final class_2561 FILE_EXISTS_TEXT = class_2561.method_43471((String)"vtd.fileNameValidity.fileExists");
    private static final class_2561 INVALID_WINDOWS_NAME_TEXT = class_2561.method_43471((String)"vtd.fileNameValidity.invalidWindows");
    private static final class_2561 RESERVED_WINDOWS_NAME_TEXT = class_2561.method_43471((String)"vtd.fileNameValidity.reservedWindows");
    private static final class_2561 REGEX_DOESNT_MATCH_TEXT = class_2561.method_43469((String)"vtd.fileNameValidity.regexDoesntMatch", (Object[])new Object[]{"^[\\w,.\\s-]+$"});
    public static final int MAX_LENGTH = 64;
    private static final int ERROR_COLOR = -1420986;
    private static final int ERROR_FOCUSED_COLOR = -39322;
    private static final int WARNING_COLOR = -871156;
    private static final int WARNING_FOCUSED_COLOR = -4337;
    private final class_327 textRenderer;
    private final Path directory;
    private final String defaultName;
    private NameStatus nameStatus = NameStatus.VALID;

    public PackNameTextFieldWidget(class_327 textRenderer, int x, int y, int width, int height, @Nullable String copyText, class_2561 text, Path directory, @Nullable String defaultName) {
        super(textRenderer, x, y, width, height, text);
        this.textRenderer = textRenderer;
        this.directory = directory;
        this.defaultName = defaultName;
        super.method_1863(this::onChange);
        this.method_1880(64);
        if (copyText != null) {
            this.method_1852(copyText);
        }
    }

    public void method_1863(Consumer<String> changedListener) {
        super.method_1863(((Consumer<String>)this::onChange).andThen(changedListener));
    }

    private void onChange(String text) {
        this.nameStatus = !text.isBlank() ? (RESERVED_WINDOWS_NAME.matcher(text).matches() ? NameStatus.RESERVED_WINDOWS : (INVALID_WINDOWS_NAME.matcher(text).matches() ? NameStatus.INVALID_WINDOWS : (!text.matches(FILE_NAME_REGEX) ? NameStatus.REGEX_DOESNT_MATCH : (Files.exists(this.directory.resolve(text + ".zip"), new LinkOption[0]) ? NameStatus.FILE_EXISTS : NameStatus.VALID)))) : NameStatus.VALID;
    }

    public boolean isBlank() {
        return this.method_1882().isBlank();
    }

    public boolean canUseName() {
        return !this.nameStatus.isError();
    }

    private boolean isNewName() {
        return this.defaultName == null || !this.defaultName.equals(this.method_1882());
    }

    @Nullable
    public class_2561 getTooltipText() {
        return switch (this.nameStatus.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> {
                if (this.isNewName()) {
                    yield FILE_EXISTS_TEXT;
                }
                yield null;
            }
            case 2 -> RESERVED_WINDOWS_NAME_TEXT;
            case 3 -> INVALID_WINDOWS_NAME_TEXT;
            case 4 -> REGEX_DOESNT_MATCH_TEXT;
            case 0 -> null;
        };
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_48579(graphics, mouseX, mouseY, delta);
        if (this.method_1885()) {
            if (this.method_1882().isEmpty()) {
                int x = this.method_46426() + 4;
                int y = this.method_46427() + (this.field_22759 - 8) / 2;
                graphics.method_27535(this.textRenderer, this.method_25369(), x, y, 0x707070);
            }
            this.renderOutline(graphics);
        }
    }

    private void renderOutline(class_332 graphics) {
        int color = -1;
        if (this.nameStatus.isError()) {
            color = this.method_25370() ? -39322 : -1420986;
        } else if (this.nameStatus == NameStatus.FILE_EXISTS && this.isNewName()) {
            int n = color = this.method_25370() ? -4337 : -871156;
        }
        if (color != -1) {
            RenderUtil.drawOutline(graphics, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759, 1, color);
        }
    }

    public static enum NameStatus {
        VALID(false),
        FILE_EXISTS(false),
        RESERVED_WINDOWS(true),
        INVALID_WINDOWS(true),
        REGEX_DOESNT_MATCH(true);

        private final boolean error;

        private NameStatus(boolean error) {
            this.error = error;
        }

        public boolean isError() {
            return this.error;
        }
    }
}

