/*
 * Decompiled with CFR 0.152.
 */
package me.bymartrixx.vtd.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.bymartrixx.vtd.data.Category;
import me.bymartrixx.vtd.data.Pack;
import org.jetbrains.annotations.Contract;

public class DownloadPackRequestData {
    private final Map<String, List<String>> packs;

    private DownloadPackRequestData(Map<String, List<String>> packs) {
        this.packs = packs;
    }

    @Contract(value="_ -> new")
    public static DownloadPackRequestData create(Map<Category, List<Pack>> selectedPacks) {
        Map<String, List<String>> packs = selectedPacks.entrySet().stream().collect(Collectors.toMap(entry -> ((Category)entry.getKey()).getId(), entry -> ((List)entry.getValue()).stream().map(Pack::getId).toList()));
        return new DownloadPackRequestData(packs);
    }

    public static class Serializer
    implements JsonSerializer<DownloadPackRequestData> {
        public JsonElement serialize(DownloadPackRequestData downloadPackData, Type type, JsonSerializationContext jsonSerializationContext) {
            return jsonSerializationContext.serialize(downloadPackData.packs);
        }
    }
}

