/*
 * Decompiled with CFR 0.152.
 */
package work.msdnicrosoft.commandbuttons.gui;

import com.google.common.collect.Lists;
import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.client.LightweightGuiDescription;
import io.github.cottonmc.cotton.gui.widget.WButton;
import io.github.cottonmc.cotton.gui.widget.WGridPanel;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WToggleButton;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import java.util.function.BiConsumer;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import work.msdnicrosoft.commandbuttons.CommandButtons;
import work.msdnicrosoft.commandbuttons.compat.minecraft.ComponentCompatApi;
import work.msdnicrosoft.commandbuttons.data.CommandDestination;
import work.msdnicrosoft.commandbuttons.data.CommandItem;
import work.msdnicrosoft.commandbuttons.data.ConfigManager;
import work.msdnicrosoft.commandbuttons.data.Text;
import work.msdnicrosoft.commandbuttons.gui.CommandEditGUI;
import work.msdnicrosoft.commandbuttons.gui.CommandListPanel;
import work.msdnicrosoft.commandbuttons.gui.WTextFieldExtra;
import work.msdnicrosoft.commandbuttons.gui.WrapperCommandGUIScreen;

public class CommandGUI
extends LightweightGuiDescription {
    private final BiConsumer<CommandItem, CommandDestination> creator = this::defBtnBehavior;
    private final WTextFieldExtra search = (WTextFieldExtra)new WTextFieldExtra().setSuggestion(ComponentCompatApi.translatable("mgbuttons.gui.main.search"));
    private final WButton addBtn = new WButton(ComponentCompatApi.literal("+")).setOnClick(this::addCallBack);
    private final WToggleButton editBtn = new WToggleButton(ComponentCompatApi.translatable("mgbuttons.gui.main.edit")).setColor(0xFFFFFF, 0xFFFFFF).setOnToggle(this::editBtnCallback);
    private final WToggleButton deleteBtn = new WToggleButton(ComponentCompatApi.translatable("mgbuttons.gui.main.delete")).setColor(0xFFFFFF, 0xFFFFFF).setOnToggle(this::deleteBtnCallback);
    private final CommandListPanel<CommandItem, CommandDestination> commandPanel = new CommandListPanel<CommandItem, CommandDestination>(ConfigManager.getData(), CommandDestination::new, this.creator, this.search);
    private final WGridPanel root = new WGridPanel(5);

    public CommandGUI() {
        this.setupRoot();
        this.setRootPanel((WPanel)this.root);
        this.createCommandPanel();
    }

    private void setupRoot() {
        this.root.setSize(350, 240);
        this.root.add((WWidget)this.search, 1, 1, 68, 2);
        this.root.add(this.commandPanel, 1, 6, 68, 36);
        this.root.add((WWidget)this.addBtn, 1, 43, 4, 4);
        this.root.add((WWidget)this.editBtn, 6, 43, 4, 4);
        this.root.add((WWidget)this.deleteBtn, 25, 43, 4, 4);
        this.root.validate((GuiDescription)this);
    }

    private void createCommandPanel() {
        this.search.setChangedListener(s -> this.commandPanel.layout());
    }

    private void defBtnBehavior(@NotNull CommandItem item, @NotNull CommandDestination destination) {
        destination.getButton().setLabel(ComponentCompatApi.literal(item.getDisplayName()));
        destination.getButton().setOnClick(() -> {
            if (this.editBtn.getToggle()) {
                CommandEditGUI gui = new CommandEditGUI(item, true);
                WrapperCommandGUIScreen guiScreen = new WrapperCommandGUIScreen((GuiDescription)gui);
                guiScreen.setCloseCallback(gui::saveData);
                guiScreen.setReturnAction(this.commandPanel::layout);
                guiScreen.setParent(class_310.method_1551().field_1755);
                class_310.method_1551().method_1507((class_437)guiScreen);
            } else if (this.deleteBtn.getToggle()) {
                ConfigManager.remove(item);
                this.commandPanel.layout();
            } else {
                item.getRaw().stream().map(Text::getText).forEach(CommandButtons::send);
            }
        });
    }

    private void addCallBack() {
        CommandEditGUI gui = new CommandEditGUI(new CommandItem("", Lists.newArrayList()));
        WrapperCommandGUIScreen guiScreen = new WrapperCommandGUIScreen((GuiDescription)gui);
        guiScreen.setCloseCallback(gui::saveData);
        guiScreen.setReturnAction(this.commandPanel::layout);
        guiScreen.setParent(class_310.method_1551().field_1755);
        class_310.method_1551().method_1507((class_437)guiScreen);
    }

    private void editBtnCallback(@NotNull Boolean aBoolean) {
        if (aBoolean.booleanValue()) {
            this.deleteBtn.setToggle(false);
        }
    }

    private void deleteBtnCallback(@NotNull Boolean aBoolean) {
        if (aBoolean.booleanValue()) {
            this.editBtn.setToggle(false);
        }
    }

    public void addPainters() {
        super.addPainters();
        this.rootPanel.setBackgroundPainter(BackgroundPainter.createColorful((int)0x4D000000));
    }
}

