/*
 * Decompiled with CFR 0.152.
 */
package work.msdnicrosoft.commandbuttons.gui;

import com.google.common.collect.Lists;
import io.github.cottonmc.cotton.gui.widget.WListPanel;
import io.github.cottonmc.cotton.gui.widget.WTextField;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import work.msdnicrosoft.commandbuttons.data.CommandItem;
import work.msdnicrosoft.commandbuttons.mixin.IWListPanel;
import work.msdnicrosoft.commandbuttons.mixin.IWWidget;

public class CommandListPanel<D, W extends WWidget>
extends WListPanel<D, W> {
    private final WTextField search;

    public CommandListPanel(List<D> data, Supplier<W> supplier, BiConsumer<D, W> configurator, WTextField search) {
        super(data, supplier, configurator);
        this.search = search;
    }

    public void layout() {
        this.children.clear();
        this.children.add(this.scrollBar);
        this.scrollBar.setLocation(this.width - this.scrollBar.getWidth(), 0);
        this.scrollBar.setSize(8, this.height);
        if (!this.fixedHeight) {
            if (this.unconfigured.isEmpty()) {
                if (this.configured.isEmpty()) {
                    exemplar = ((IWListPanel)((Object)this)).invokeCreateChild();
                    this.unconfigured.add(exemplar);
                    if (!exemplar.canResize()) {
                        this.cellHeight = exemplar.getHeight();
                    }
                } else {
                    exemplar = (WWidget)this.configured.values().iterator().next();
                    if (!exemplar.canResize()) {
                        this.cellHeight = exemplar.getHeight();
                    }
                }
            } else {
                exemplar = (WWidget)this.unconfigured.get(0);
                if (!exemplar.canResize()) {
                    this.cellHeight = exemplar.getHeight();
                }
            }
        }
        if (this.cellHeight < 4) {
            this.cellHeight = 4;
        }
        int layoutHeight = this.getHeight() - 4;
        int cellsHigh = Math.max((layoutHeight + 2) / (this.cellHeight + 2), 1);
        List<Object> data = Lists.newArrayList((Iterable)this.data);
        if (!this.search.getText().isEmpty()) {
            data = data.stream().filter(d -> ((CommandItem)d).getDisplayName().contains(this.search.getText().trim())).collect(Collectors.toList());
        }
        this.scrollBar.setWindow(cellsHigh);
        this.scrollBar.setMaxValue(data.size() > 32 ? data.size() - 8 : 8);
        int scrollOffset = this.scrollBar.getValue();
        int presentCells = Math.min(data.size() - scrollOffset / 4 + 1, 32);
        int offsetX = 0;
        int offsetY = 0;
        if (presentCells > 0) {
            int index;
            for (int i = 0; i < presentCells && (index = i + scrollOffset) < data.size(); ++i) {
                if (index < 0) continue;
                Object d2 = data.get(index);
                Object w = (WWidget)this.configured.get(d2);
                if (w == null) {
                    w = this.unconfigured.isEmpty() ? ((IWListPanel)((Object)this)).invokeCreateChild() : (WWidget)this.unconfigured.remove(0);
                    this.configured.put(d2, w);
                }
                this.configurator.accept(d2, w);
                ((IWWidget)w).setX((w.getWidth() + 5) * offsetX);
                ((IWWidget)w).setY(offsetY * 22);
                if (++offsetX >= 4) {
                    offsetX = 0;
                    ++offsetY;
                }
                this.children.add(w);
            }
        }
    }
}

