/*
 * Decompiled with CFR 0.152.
 */
package work.msdnicrosoft.commandbuttons.data;

import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import work.msdnicrosoft.commandbuttons.CommandButtonsReference;
import work.msdnicrosoft.commandbuttons.data.CommandItem;
import work.msdnicrosoft.commandbuttons.data.Text;

public class ConfigManager {
    private static final List<CommandItem> data = Lists.newArrayList();
    private static final File file = new File("./config/command-gui-buttons");

    private static void saveToFile() {
        Path path = file.toPath().resolve("commands.json");
        if (data.isEmpty()) {
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException e) {
                CommandButtonsReference.getLogger().error("Cannot delete empty file '{}':", (Object)path.toString(), (Object)e);
            }
            return;
        }
        String string = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(CommandItem.class, (Object)new Serializer()).create().toJson(data);
        ConfigManager.checkDataRoot();
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(string);
        }
        catch (IOException e) {
            CommandButtonsReference.getLogger().error("Cannot write commands data: ", (Throwable)e);
            CommandButtonsReference.getLogger().warn("Data: {}", (Object)string);
        }
        ConfigManager.loadFromFile();
    }

    private static void loadFromFile() {
        Path path = file.toPath().resolve("commands.json");
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            List list = (List)new GsonBuilder().registerTypeAdapter(CommandItem.class, (Object)new Serializer()).create().fromJson((Reader)reader, new TypeToken<List<CommandItem>>(){}.getType());
            data.clear();
            data.addAll(list);
        }
        catch (JsonSyntaxException | IOException e) {
            CommandButtonsReference.getLogger().error("Cannot load commands data: ", e);
        }
    }

    @NotNull
    public static CommandItem createEntry(@NotNull JsonObject jsonObject) {
        try {
            String displayName = jsonObject.has("displayName") ? jsonObject.get("displayName").getAsString() : "Unknown";
            JsonArray raw = jsonObject.has("raw") ? jsonObject.get("raw").getAsJsonArray() : null;
            ArrayList texts = Lists.newArrayList();
            if (raw != null) {
                raw.forEach(jsonElement -> texts.add(new Text(jsonElement.getAsString())));
            }
            return new CommandItem(displayName, texts);
        }
        catch (IllegalStateException | UnsupportedOperationException e) {
            return new CommandItem("Unknown", Lists.newArrayList());
        }
    }

    private static void checkDataRoot() {
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static void add(CommandItem item) {
        data.add(item);
        ConfigManager.save();
    }

    public static void remove(CommandItem item) {
        data.remove(item);
        ConfigManager.save();
    }

    public static void init() {
        ConfigManager.loadFromFile();
    }

    public static void save() {
        ConfigManager.saveToFile();
    }

    @Generated
    public static List<CommandItem> getData() {
        return data;
    }

    static class Serializer
    implements JsonDeserializer<CommandItem>,
    JsonSerializer<CommandItem> {
        Serializer() {
        }

        public JsonElement serialize(CommandItem src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            src.serialize(jsonObject);
            return jsonObject;
        }

        public CommandItem deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jsonObject = json.getAsJsonObject();
                return ConfigManager.createEntry(jsonObject);
            }
            return null;
        }
    }
}

