/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.util;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class Category
implements Comparable<Category> {
    private final class_2960 id;
    private final String displayName;
    private final String shortName;
    private final int order;
    private final Set<class_6862<class_1792>> tags = new HashSet<class_6862<class_1792>>();
    private final Set<class_2960> items = new HashSet<class_2960>();
    public static final Category ALL = new Category(class_2960.method_60655((String)"smartsorter", (String)"all"), "All Items", "All", -1);
    public static final Category MISC = new Category(class_2960.method_60655((String)"smartsorter", (String)"misc"), "Misc / Rare", "Misc", 9999);

    public Category(class_2960 id, String displayName, String shortName, int order) {
        this.id = id;
        this.displayName = displayName;
        this.shortName = shortName;
        this.order = order;
    }

    public void addEntry(String entry) {
        if (entry.startsWith("#")) {
            String tagId = entry.substring(1);
            class_2960 tagIdentifier = class_2960.method_12829((String)tagId);
            if (tagIdentifier != null) {
                this.tags.add((class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)tagIdentifier));
            }
        } else {
            class_2960 itemId = class_2960.method_12829((String)entry);
            if (itemId != null) {
                this.items.add(itemId);
            }
        }
    }

    public boolean matches(class_1792 item) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
        if (this.items.contains(itemId)) {
            return true;
        }
        class_1799 stack = item.method_7854();
        for (class_6862<class_1792> tag : this.tags) {
            if (!stack.method_31573(tag)) continue;
            return true;
        }
        return false;
    }

    public class_2960 getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public int getOrder() {
        return this.order;
    }

    public String asString() {
        return this.id.toString();
    }

    @Override
    public int compareTo(Category other) {
        int orderCompare = Integer.compare(this.order, other.order);
        return orderCompare != 0 ? orderCompare : this.displayName.compareTo(other.displayName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Category)) {
            return false;
        }
        Category other = (Category)obj;
        return this.id.equals((Object)other.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

