/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.util;

import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9334;

public enum RecipeFilterMode {
    ALL_SMELTABLE("All Smeltable"),
    ORES_ONLY("Ores Only"),
    FOOD_ONLY("Food Only"),
    RAW_METALS_ONLY("Raw Metals"),
    NO_WOOD("No Wood"),
    CUSTOM("Custom Whitelist");

    private final String displayName;

    private RecipeFilterMode(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean matches(class_1799 input, class_3956<?> recipeType) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> true;
            case 1 -> this.isOre(input);
            case 2 -> this.isFood(input);
            case 3 -> this.isRawMetal(input);
            case 4 -> {
                if (!this.isWood(input)) {
                    yield true;
                }
                yield false;
            }
            case 5 -> false;
        };
    }

    private boolean isOre(class_1799 stack) {
        class_1792 item = stack.method_7909();
        return item.method_7854().method_31573(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"c", (String)"ores"))) || item.method_7854().method_31573(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"minecraft", (String)"ores"))) || class_7923.field_41178.method_10221((Object)item).method_12832().contains("ore");
    }

    private boolean isFood(class_1799 stack) {
        return stack.method_57353().method_57832(class_9334.field_50075);
    }

    private boolean isRawMetal(class_1799 stack) {
        String id = class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12832();
        return id.startsWith("raw_");
    }

    private boolean isWood(class_1799 stack) {
        String id = class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12832();
        return id.contains("log") || id.contains("wood") || id.contains("plank");
    }

    public String asString() {
        return this.name();
    }

    public static RecipeFilterMode fromString(String name) {
        try {
            return RecipeFilterMode.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return ORES_ONLY;
        }
    }
}

