/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.blockentity.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.shaddii.smartsorter.blockentity.OutputProbeBlockEntity;

public class NetworkInventoryManager {
    private static final int INITIAL_CAPACITY = 256;
    private static final float LOAD_FACTOR = 0.75f;
    private final Map<ItemVariant, Long> networkItems = new LinkedHashMap<ItemVariant, Long>(256, 0.75f);
    private final Map<ItemVariant, Long> deltaItems = new HashMap<ItemVariant, Long>(64, 0.75f);
    private final Map<ItemVariant, List<class_2338>> itemLocationIndex = new HashMap<ItemVariant, List<class_2338>>(256, 0.75f);
    private Map<ItemVariant, Long> networkItemsSnapshot;
    private boolean snapshotDirty = true;
    private int samplingOffset = 0;
    private static final int SAMPLE_SIZE = 300;

    public void updateCache(class_1937 world, List<class_2338> probes) {
        if (world == null) {
            return;
        }
        if (probes.size() > 1000) {
            this.updateCacheSampled(world, probes);
            return;
        }
        this.updateCacheFull(world, probes);
    }

    private void updateCacheFull(class_1937 world, List<class_2338> probes) {
        HashMap<ItemVariant, Long> newItems = new HashMap<ItemVariant, Long>(this.networkItems.size());
        this.itemLocationIndex.clear();
        for (class_2338 probePos : probes) {
            OutputProbeBlockEntity probe;
            Storage<ItemVariant> storage;
            class_2586 be = world.method_8321(probePos);
            if (!(be instanceof OutputProbeBlockEntity) || (storage = (probe = (OutputProbeBlockEntity)be).getTargetStorage()) == null) continue;
            for (StorageView view : storage) {
                ItemVariant variant;
                if (view.getAmount() == 0L || (variant = (ItemVariant)view.getResource()).isBlank()) continue;
                newItems.merge(variant, view.getAmount(), Long::sum);
                this.itemLocationIndex.computeIfAbsent(variant, k -> new ArrayList(4)).add(probePos);
            }
        }
        this.trackDeltas(newItems);
        this.networkItems.clear();
        this.networkItems.putAll(newItems);
        this.snapshotDirty = true;
    }

    private void updateCacheSampled(class_1937 world, List<class_2338> probes) {
        int totalProbes = probes.size();
        int endIndex = Math.min(this.samplingOffset + 300, totalProbes);
        for (int i = this.samplingOffset; i < endIndex; ++i) {
            OutputProbeBlockEntity probe;
            Storage<ItemVariant> storage;
            class_2338 probePos = probes.get(i);
            class_2586 be = world.method_8321(probePos);
            if (!(be instanceof OutputProbeBlockEntity) || (storage = (probe = (OutputProbeBlockEntity)be).getTargetStorage()) == null) continue;
            for (StorageView view : storage) {
                ItemVariant variant;
                if (view.getAmount() == 0L || (variant = (ItemVariant)view.getResource()).isBlank()) continue;
                this.networkItems.merge(variant, view.getAmount(), Long::sum);
                this.itemLocationIndex.computeIfAbsent(variant, k -> new ArrayList(4)).add(probePos);
            }
        }
        this.samplingOffset = endIndex;
        if (this.samplingOffset >= totalProbes) {
            this.samplingOffset = 0;
        }
        this.snapshotDirty = true;
    }

    private void trackDeltas(Map<ItemVariant, Long> newItems) {
        for (Map.Entry<ItemVariant, Long> entry : this.networkItems.entrySet()) {
            long newAmount = newItems.getOrDefault(entry.getKey(), 0L);
            if (newAmount == entry.getValue()) continue;
            this.deltaItems.put(entry.getKey(), newAmount);
        }
        for (Map.Entry<ItemVariant, Long> entry : newItems.entrySet()) {
            if (this.networkItems.containsKey(entry.getKey())) continue;
            this.deltaItems.put(entry.getKey(), entry.getValue());
        }
    }

    public Map<ItemVariant, Long> getNetworkItems() {
        if (this.snapshotDirty || this.networkItemsSnapshot == null) {
            this.networkItemsSnapshot = new HashMap<ItemVariant, Long>(this.networkItems);
            this.snapshotDirty = false;
        }
        return this.networkItemsSnapshot;
    }

    public Map<ItemVariant, Long> consumeDeltas() {
        if (this.deltaItems.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<ItemVariant, Long> deltas = new HashMap<ItemVariant, Long>(this.deltaItems);
        this.deltaItems.clear();
        return deltas;
    }

    public List<class_2338> getProbesWithItem(ItemVariant variant) {
        return this.itemLocationIndex.getOrDefault(variant, Collections.emptyList());
    }

    public long getItemAmount(ItemVariant variant) {
        return this.networkItems.getOrDefault(variant, 0L);
    }

    public boolean hasDeltas() {
        return !this.deltaItems.isEmpty();
    }

    public void markDirty() {
        this.snapshotDirty = true;
    }

    public void applyDeltas(Map<ItemVariant, Long> deltas) {
        for (Map.Entry<ItemVariant, Long> entry : deltas.entrySet()) {
            if (entry.getValue() <= 0L) {
                this.networkItems.remove(entry.getKey());
                continue;
            }
            this.networkItems.put(entry.getKey(), entry.getValue());
        }
        this.snapshotDirty = true;
    }
}

