/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.blockentity.processor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2609;
import net.minecraft.class_3218;
import net.minecraft.class_3720;
import net.minecraft.class_3723;
import net.minecraft.class_3866;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import net.shaddii.smartsorter.util.FuelFilterMode;
import net.shaddii.smartsorter.util.RecipeFilterMode;

public class RecipeValidator {
    private static final int RECIPE_CACHE_MAX = 100;
    private static final int FUEL_CACHE_MAX = 50;
    private static final long CACHE_VALIDITY_MS = 10000L;
    private final Map<CacheKey, CachedRecipeCheck> recipeCache = new HashMap<CacheKey, CachedRecipeCheck>();
    private final Set<ItemVariant> knownFuels = new HashSet<ItemVariant>();
    private final Set<ItemVariant> knownNonFuels = new HashSet<ItemVariant>();

    public boolean canSmelt(class_3218 world, ItemVariant variant, class_2609 furnace, class_3956<?> recipeType) {
        if (recipeType == null) {
            return false;
        }
        String furnaceType = furnace.getClass().getSimpleName();
        CacheKey key = new CacheKey(variant, furnaceType);
        CachedRecipeCheck cached = this.recipeCache.get(key);
        if (cached != null && cached.isValid()) {
            return cached.canProcess;
        }
        class_1799 stack = variant.toStack(1);
        class_9696 recipeInput = new class_9696(stack);
        boolean canSmelt = false;
        try {
            if (furnace instanceof class_3866) {
                canSmelt = world.method_8433().method_8132(class_3956.field_17546, (class_9695)recipeInput, (class_1937)world).isPresent();
            } else if (furnace instanceof class_3720) {
                canSmelt = world.method_8433().method_8132(class_3956.field_17547, (class_9695)recipeInput, (class_1937)world).isPresent();
            } else if (furnace instanceof class_3723) {
                canSmelt = world.method_8433().method_8132(class_3956.field_17548, (class_9695)recipeInput, (class_1937)world).isPresent();
            }
        }
        catch (Exception e) {
            canSmelt = false;
        }
        this.recipeCache.put(key, new CachedRecipeCheck(canSmelt));
        if (this.recipeCache.size() > 100) {
            this.trimRecipeCache();
        }
        return canSmelt;
    }

    public boolean isFuel(class_3218 world, ItemVariant variant) {
        if (this.knownFuels.contains(variant)) {
            return true;
        }
        if (this.knownNonFuels.contains(variant)) {
            return false;
        }
        class_1799 stack = variant.toStack(1);
        boolean isFuel = class_2609.method_11195((class_1799)stack);
        (isFuel ? this.knownFuels : this.knownNonFuels).add(variant);
        if (this.knownFuels.size() > 50) {
            this.trimFuelCache();
        }
        return isFuel;
    }

    public boolean matchesRecipeFilter(ItemVariant variant, RecipeFilterMode filter) {
        class_1799 stack = variant.toStack(1);
        class_1792 item = variant.getItem();
        String id = class_7923.field_41178.method_10221((Object)item).method_12832();
        return switch (filter) {
            case RecipeFilterMode.ALL_SMELTABLE -> true;
            case RecipeFilterMode.ORES_ONLY -> {
                if (id.contains("ore") || id.contains("raw_")) {
                    yield true;
                }
                yield false;
            }
            case RecipeFilterMode.FOOD_ONLY -> stack.method_57353().method_57832(class_9334.field_50075);
            case RecipeFilterMode.RAW_METALS_ONLY -> id.startsWith("raw_");
            case RecipeFilterMode.NO_WOOD -> {
                if (!(id.contains("log") || id.contains("wood") || id.contains("plank"))) {
                    yield true;
                }
                yield false;
            }
            case RecipeFilterMode.CUSTOM -> false;
            default -> true;
        };
    }

    public boolean matchesFuelFilter(ItemVariant variant, FuelFilterMode filter) {
        class_1792 item = variant.getItem();
        String id = class_7923.field_41178.method_10221((Object)item).method_12832();
        return switch (filter) {
            case FuelFilterMode.ANY_FUEL -> true;
            case FuelFilterMode.COAL_ONLY -> {
                if (item == class_1802.field_8713 || item == class_1802.field_8665) {
                    yield true;
                }
                yield false;
            }
            case FuelFilterMode.BLOCKS_ONLY -> {
                if (item == class_1802.field_8797 || item == class_1802.field_17533 || item == class_1802.field_8894) {
                    yield true;
                }
                yield false;
            }
            case FuelFilterMode.NO_WOOD -> {
                if (!(id.contains("log") || id.contains("wood") || id.contains("plank"))) {
                    yield true;
                }
                yield false;
            }
            case FuelFilterMode.LAVA_ONLY -> {
                if (item == class_1802.field_8187) {
                    yield true;
                }
                yield false;
            }
            case FuelFilterMode.CUSTOM -> false;
            default -> true;
        };
    }

    public class_3956<?> getRecipeType(class_2609 furnace) {
        if (furnace instanceof class_3866) {
            return class_3956.field_17546;
        }
        if (furnace instanceof class_3720) {
            return class_3956.field_17547;
        }
        if (furnace instanceof class_3723) {
            return class_3956.field_17548;
        }
        return null;
    }

    public void cleanCache() {
        this.recipeCache.entrySet().removeIf(entry -> !((CachedRecipeCheck)entry.getValue()).isValid());
    }

    private void trimRecipeCache() {
        Iterator<Map.Entry<CacheKey, CachedRecipeCheck>> it = this.recipeCache.entrySet().iterator();
        for (int toRemove = this.recipeCache.size() / 2; it.hasNext() && toRemove > 0; --toRemove) {
            it.next();
            it.remove();
        }
    }

    private void trimFuelCache() {
        if (this.knownFuels.size() > 25) {
            HashSet<ItemVariant> temp = new HashSet<ItemVariant>();
            int kept = 0;
            for (ItemVariant fuel : this.knownFuels) {
                if (kept++ >= 25) break;
                temp.add(fuel);
            }
            this.knownFuels.clear();
            this.knownFuels.addAll(temp);
        }
    }

    public void clearCache() {
        this.recipeCache.clear();
        this.knownFuels.clear();
        this.knownNonFuels.clear();
    }

    private static class CacheKey {
        final ItemVariant variant;
        final String furnaceType;

        CacheKey(ItemVariant variant, String type) {
            this.variant = variant;
            this.furnaceType = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey key = (CacheKey)o;
            return Objects.equals(this.variant, key.variant) && Objects.equals(this.furnaceType, key.furnaceType);
        }

        public int hashCode() {
            return Objects.hash(this.variant, this.furnaceType);
        }
    }

    private static class CachedRecipeCheck {
        final boolean canProcess;
        final long timestamp;

        CachedRecipeCheck(boolean canProcess) {
            this.canProcess = canProcess;
            this.timestamp = System.currentTimeMillis();
        }

        boolean isValid() {
            return System.currentTimeMillis() - this.timestamp < 10000L;
        }
    }
}

