/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.client;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_124;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_3929;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.shaddii.smartsorter.SmartSorter;
import net.shaddii.smartsorter.client.OverflowInputHandler;
import net.shaddii.smartsorter.client.OverflowNotificationOverlay;
import net.shaddii.smartsorter.client.SortProgressOverlay;
import net.shaddii.smartsorter.network.CategorySyncPayload;
import net.shaddii.smartsorter.network.ChestConfigBatchPayload;
import net.shaddii.smartsorter.network.ChestConfigUpdatePayload;
import net.shaddii.smartsorter.network.ChestPriorityBatchPayload;
import net.shaddii.smartsorter.network.OverflowNotificationPayload;
import net.shaddii.smartsorter.network.ProbeConfigBatchPayload;
import net.shaddii.smartsorter.network.ProbeStatsSyncPayload;
import net.shaddii.smartsorter.network.SortProgressPayload;
import net.shaddii.smartsorter.network.StorageControllerSyncPacket;
import net.shaddii.smartsorter.network.StorageDeltaSyncPayload;
import net.shaddii.smartsorter.screen.OutputProbeScreen;
import net.shaddii.smartsorter.screen.OutputProbeScreenHandler;
import net.shaddii.smartsorter.screen.StorageControllerScreen;
import net.shaddii.smartsorter.screen.StorageControllerScreenHandler;
import net.shaddii.smartsorter.util.CategoryManager;
import net.shaddii.smartsorter.util.ChestConfig;
import org.lwjgl.glfw.GLFW;

public class SmartSorterClient
implements ClientModInitializer {
    public void onInitializeClient() {
        this.registerBlockRenderLayers();
        CategoryManager.getInstance();
        class_3929.method_17542(SmartSorter.STORAGE_CONTROLLER_SCREEN_HANDLER, StorageControllerScreen::new);
        class_3929.method_17542(SmartSorter.OUTPUT_PROBE_SCREEN_HANDLER, OutputProbeScreen::new);
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> {
            if (class_310.method_1551().field_1755 == null) {
                SortProgressOverlay.render(drawContext);
                OverflowNotificationOverlay.render(drawContext, 0.0f);
            }
        });
        OverflowInputHandler.register();
        this.registerOverflowInputHandlers();
        ClientPlayNetworking.registerGlobalReceiver(StorageControllerSyncPacket.SyncPayload.ID_PAYLOAD, (payload, context) -> context.client().execute(() -> {
            class_1703 patt0$temp;
            if (context.player() != null && (patt0$temp = context.player().field_7512) instanceof StorageControllerScreenHandler) {
                StorageControllerScreenHandler handler = (StorageControllerScreenHandler)patt0$temp;
                handler.updateNetworkItems(payload.items());
                handler.updateStoredXp(payload.storedXp());
                handler.clearProbeConfigs();
                handler.clearChestConfigs();
                handler.updateProbeConfigs(payload.probeConfigs());
                handler.method_34254(payload.cursorStack());
                class_437 patt1$temp = context.client().field_1755;
                if (patt1$temp instanceof StorageControllerScreen) {
                    StorageControllerScreen screen = (StorageControllerScreen)patt1$temp;
                    screen.markDirty();
                }
            }
        }));
        ClientPlayNetworking.registerGlobalReceiver(ChestConfigBatchPayload.ID, (payload, context) -> context.client().execute(() -> {
            class_1703 patt0$temp;
            if (context.player() != null && (patt0$temp = context.player().field_7512) instanceof StorageControllerScreenHandler) {
                StorageControllerScreenHandler handler = (StorageControllerScreenHandler)patt0$temp;
                handler.updateChestConfigs(payload.configs());
                class_437 patt1$temp = context.client().field_1755;
                if (patt1$temp instanceof StorageControllerScreen) {
                    StorageControllerScreen screen = (StorageControllerScreen)patt1$temp;
                    screen.markDirty();
                }
            }
        }));
        ClientPlayNetworking.registerGlobalReceiver(ChestConfigUpdatePayload.ID, (payload, context) -> context.client().execute(() -> {
            if (context.client().field_1724 != null) {
                class_1703 patt0$temp = context.client().field_1724.field_7512;
                if (patt0$temp instanceof StorageControllerScreenHandler) {
                    StorageControllerScreenHandler handler = (StorageControllerScreenHandler)patt0$temp;
                    HashMap<class_2338, ChestConfig> singleUpdate = new HashMap<class_2338, ChestConfig>();
                    singleUpdate.put(payload.config().position, payload.config());
                    handler.updateChestConfigs(singleUpdate);
                    class_437 patt1$temp = context.client().field_1755;
                    if (patt1$temp instanceof StorageControllerScreen) {
                        StorageControllerScreen screen = (StorageControllerScreen)patt1$temp;
                        screen.markDirty();
                    }
                } else {
                    class_1703 patt1$temp = context.client().field_1724.field_7512;
                    if (patt1$temp instanceof OutputProbeScreenHandler) {
                        OutputProbeScreenHandler handler = (OutputProbeScreenHandler)patt1$temp;
                        handler.setChestConfig(payload.config());
                        class_437 patt2$temp = context.client().field_1755;
                        if (patt2$temp instanceof OutputProbeScreen) {
                            OutputProbeScreen screen = (OutputProbeScreen)patt2$temp;
                            screen.refreshConfig();
                        }
                    }
                }
            }
        }));
        ClientPlayNetworking.registerGlobalReceiver(ProbeStatsSyncPayload.ID, (payload, context) -> context.client().execute(() -> {
            class_1703 patt0$temp;
            if (context.player() != null && (patt0$temp = context.player().field_7512) instanceof StorageControllerScreenHandler) {
                StorageControllerScreenHandler handler = (StorageControllerScreenHandler)patt0$temp;
                handler.updateProbeStats(payload.position(), payload.itemsProcessed());
                class_437 patt1$temp = context.client().field_1755;
                if (patt1$temp instanceof StorageControllerScreen) {
                    StorageControllerScreen screen = (StorageControllerScreen)patt1$temp;
                    screen.updateProbeStats(payload.position(), payload.itemsProcessed());
                    screen.markDirty();
                }
            }
        }));
        ClientPlayNetworking.registerGlobalReceiver(ProbeConfigBatchPayload.ID, (payload, context) -> context.client().execute(() -> {
            class_1703 patt0$temp;
            if (context.player() != null && (patt0$temp = context.player().field_7512) instanceof StorageControllerScreenHandler) {
                StorageControllerScreenHandler handler = (StorageControllerScreenHandler)patt0$temp;
                handler.updateProbeConfigs(payload.configs());
                class_437 patt1$temp = context.client().field_1755;
                if (patt1$temp instanceof StorageControllerScreen) {
                    StorageControllerScreen screen = (StorageControllerScreen)patt1$temp;
                    screen.markDirty();
                }
            }
        }));
        ClientPlayNetworking.registerGlobalReceiver(ChestPriorityBatchPayload.ID, (payload, context) -> context.client().execute(() -> {
            class_1703 patt0$temp;
            if (context.client().field_1724 != null && (patt0$temp = context.client().field_1724.field_7512) instanceof StorageControllerScreenHandler) {
                StorageControllerScreenHandler handler = (StorageControllerScreenHandler)patt0$temp;
                handler.applyPriorityUpdatesFromServer(payload.updates());
                class_437 patt1$temp = context.client().field_1755;
                if (patt1$temp instanceof StorageControllerScreen) {
                    StorageControllerScreen screen = (StorageControllerScreen)patt1$temp;
                    screen.onPriorityUpdate();
                }
            }
        }));
        ClientPlayNetworking.registerGlobalReceiver(OverflowNotificationPayload.ID, (payload, context) -> context.client().execute(() -> {
            if (context.client().field_1724 == null) {
                return;
            }
            class_5250 message = class_2561.method_43470((String)"\u00a7e[Smart Sorter] \u00a76Items overflowed:").method_27694(style -> style.method_10977(class_124.field_1065));
            for (Map.Entry<ItemVariant, Long> entry : payload.overflowedItems().entrySet()) {
                class_1799 stack = entry.getKey().toStack();
                long count = entry.getValue();
                class_5250 itemText = class_2561.method_43470((String)("\n - " + count + "x ")).method_27692(class_124.field_1080).method_10852((class_2561)stack.method_7964().method_27661().method_27692(class_124.field_1075));
                itemText.method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24343, (Object)new class_2568.class_5249(stack))));
                message.method_10852((class_2561)itemText);
            }
            context.client().field_1724.method_7353((class_2561)message, false);
        }));
        ClientPlayNetworking.registerGlobalReceiver(StorageDeltaSyncPayload.ID, (payload, context) -> context.client().execute(() -> {
            class_1703 patt0$temp;
            if (context.player() != null && (patt0$temp = context.player().field_7512) instanceof StorageControllerScreenHandler) {
                StorageControllerScreenHandler handler = (StorageControllerScreenHandler)patt0$temp;
                HashMap<ItemVariant, Long> updatedItems = new HashMap<ItemVariant, Long>(handler.getNetworkItems());
                for (Map.Entry<ItemVariant, Long> entry : payload.changedItems().entrySet()) {
                    if (entry.getValue() > 0L) {
                        updatedItems.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    updatedItems.remove(entry.getKey());
                }
                handler.updateNetworkItems(updatedItems);
                class_437 patt1$temp = context.client().field_1755;
                if (patt1$temp instanceof StorageControllerScreen) {
                    StorageControllerScreen screen = (StorageControllerScreen)patt1$temp;
                    screen.markDirty();
                }
            }
        }));
        ClientPlayNetworking.registerGlobalReceiver(SortProgressPayload.ID, (payload, context) -> context.client().execute(() -> {
            SortProgressOverlay.updateProgress(payload.current(), payload.total(), payload.isComplete());
            if (payload.isComplete() && payload.overflowItems() != null && !payload.overflowItems().isEmpty()) {
                OverflowNotificationOverlay.show(payload.overflowItems(), payload.overflowDestinations());
            }
        }));
        ClientPlayNetworking.registerGlobalReceiver(CategorySyncPayload.ID, (payload, context) -> context.client().execute(() -> {
            CategoryManager.getInstance().updateFromServer(payload.categories());
            class_437 patt0$temp = context.client().field_1755;
            if (patt0$temp instanceof StorageControllerScreen) {
                StorageControllerScreen screen = (StorageControllerScreen)patt0$temp;
                screen.markDirty();
            }
        }));
    }

    private void registerBlockRenderLayers() {
        BlockRenderLayerMap.INSTANCE.putBlock(SmartSorter.INTAKE_BLOCK, class_1921.method_23577());
        BlockRenderLayerMap.INSTANCE.putBlock(SmartSorter.PROBE_BLOCK, class_1921.method_23577());
        BlockRenderLayerMap.INSTANCE.putBlock(SmartSorter.PROCESS_PROBE_BLOCK, class_1921.method_23577());
        BlockRenderLayerMap.INSTANCE.putBlock(SmartSorter.STORAGE_CONTROLLER_BLOCK, class_1921.method_23577());
    }

    private void registerOverflowInputHandlers() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 == null || client.field_1755 != null) {
                return;
            }
            long window = client.method_22683().method_4490();
            if (GLFW.glfwGetKey((long)window, (int)88) == 1 && OverflowNotificationOverlay.isActive()) {
                OverflowNotificationOverlay.dismiss();
            }
            if (GLFW.glfwGetKey((long)window, (int)265) == 1) {
                OverflowNotificationOverlay.scroll(-1);
            }
            if (GLFW.glfwGetKey((long)window, (int)264) == 1) {
                OverflowNotificationOverlay.scroll(1);
            }
        });
    }
}

