/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.network;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.shaddii.smartsorter.util.FuelFilterMode;
import net.shaddii.smartsorter.util.ProcessProbeConfig;
import net.shaddii.smartsorter.util.RecipeFilterMode;

public class StorageControllerSyncPacket {
    public static final class_2960 ID = class_2960.method_60655((String)"smartsorter", (String)"storage_sync");

    public static void send(class_3222 player, Map<ItemVariant, Long> items, int storedXp, Map<class_2338, ProcessProbeConfig> probeConfigs) {
        class_1799 cursorStack = player.field_7512.method_34255();
        ServerPlayNetworking.send((class_3222)player, (class_8710)new SyncPayload(items, storedXp, probeConfigs, cursorStack));
    }

    public record SyncPayload(Map<ItemVariant, Long> items, int storedXp, Map<class_2338, ProcessProbeConfig> probeConfigs, class_1799 cursorStack) implements class_8710
    {
        public static final class_8710.class_9154<SyncPayload> ID_PAYLOAD = new class_8710.class_9154(ID);
        public static final class_9139<class_9129, SyncPayload> CODEC = class_9139.method_56438((value, buf) -> SyncPayload.write(buf, value), buf -> SyncPayload.read(buf));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID_PAYLOAD;
        }

        public static void write(class_9129 buf, SyncPayload payload) {
            buf.method_10804(payload.items.size());
            for (Map.Entry<ItemVariant, Long> entry : payload.items.entrySet()) {
                class_1799 stack = entry.getKey().toStack(1);
                class_1799.field_48349.encode((Object)buf, (Object)stack);
                buf.method_10791(entry.getValue().longValue());
            }
            buf.method_10804(payload.storedXp);
            HashMap<String, Integer> machineTypePool = new HashMap<String, Integer>();
            machineTypePool.put("Furnace", 0);
            machineTypePool.put("Blast Furnace", 1);
            machineTypePool.put("Smoker", 2);
            machineTypePool.put("Unknown", 3);
            buf.method_10804(payload.probeConfigs.size());
            for (Map.Entry<class_2338, ProcessProbeConfig> entry : payload.probeConfigs.entrySet()) {
                buf.method_52974(entry.getKey().method_10063());
                ProcessProbeConfig config = entry.getValue();
                buf.method_10814(config.machineType);
                buf.method_52964(config.customName != null);
                if (config.customName != null) {
                    buf.method_10814(config.customName);
                }
                buf.method_52964(config.enabled);
                buf.method_10814(config.recipeFilter.asString());
                buf.method_10814(config.fuelFilter.asString());
                buf.method_10804(config.itemsProcessed);
                buf.method_10804(config.index);
            }
            if (payload.cursorStack.method_7960()) {
                buf.method_52964(false);
            } else {
                buf.method_52964(true);
                class_1799.field_48349.encode((Object)buf, (Object)payload.cursorStack);
            }
        }

        public static SyncPayload read(class_9129 buf) {
            HashMap<ItemVariant, Long> items = new HashMap<ItemVariant, Long>();
            int itemCount = buf.method_10816();
            for (int i = 0; i < itemCount; ++i) {
                class_1799 stack = (class_1799)class_1799.field_48349.decode((Object)buf);
                ItemVariant variant = ItemVariant.of((class_1799)stack);
                long amount = buf.method_10792();
                items.put(variant, amount);
            }
            int storedXp = buf.method_10816();
            HashMap<class_2338, ProcessProbeConfig> probeConfigs = new HashMap<class_2338, ProcessProbeConfig>();
            int configCount = buf.method_10816();
            for (int i = 0; i < configCount; ++i) {
                class_2338 pos = class_2338.method_10092((long)buf.readLong());
                ProcessProbeConfig config = new ProcessProbeConfig();
                config.position = pos;
                config.machineType = buf.method_19772();
                boolean hasCustomName = buf.readBoolean();
                if (hasCustomName) {
                    config.customName = buf.method_19772();
                }
                config.enabled = buf.readBoolean();
                config.recipeFilter = RecipeFilterMode.fromString(buf.method_19772());
                config.fuelFilter = FuelFilterMode.fromString(buf.method_19772());
                config.itemsProcessed = buf.method_10816();
                config.index = buf.method_10816();
                probeConfigs.put(pos, config);
            }
            class_1799 cursorStack = buf.readBoolean() ? (class_1799)class_1799.field_48349.decode((Object)buf) : class_1799.field_8037;
            return new SyncPayload(items, storedXp, probeConfigs, cursorStack);
        }
    }
}

