/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.screen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.shaddii.smartsorter.client.OverflowNotificationOverlay;
import net.shaddii.smartsorter.client.SortProgressOverlay;
import net.shaddii.smartsorter.screen.StorageControllerScreenHandler;
import net.shaddii.smartsorter.screen.tabs.AutoProcessingTabComponent;
import net.shaddii.smartsorter.screen.tabs.ChestsTabComponent;
import net.shaddii.smartsorter.screen.tabs.StorageTabComponent;
import net.shaddii.smartsorter.screen.tabs.TabComponent;
import org.lwjgl.glfw.GLFW;

public class StorageControllerScreen
extends class_465<StorageControllerScreenHandler> {
    private static final class_2960 TEXTURE = class_2960.method_60655((String)"smartsorter", (String)"textures/gui/storage_controller.png");
    private Tab currentTab = Tab.STORAGE;
    private final Map<Tab, TabComponent> tabs = new HashMap<Tab, TabComponent>();
    private final List<class_4185> tabButtons = new ArrayList<class_4185>();

    public class_327 getTextRenderer() {
        return this.field_22793;
    }

    public void addWidget(class_339 widget) {
        this.method_37063((class_364)widget);
    }

    public void setWidgetFocused(class_364 element) {
        this.method_25395(element);
    }

    public StorageControllerScreen(StorageControllerScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.field_2792 = 194;
        this.field_2779 = 202;
        this.field_25267 = 7;
        this.field_25268 = 6;
        this.field_25269 = 8;
        this.field_25270 = 109;
    }

    protected void method_25426() {
        super.method_25426();
        this.tabs.put(Tab.STORAGE, new StorageTabComponent(this, (StorageControllerScreenHandler)this.field_2797));
        this.tabs.put(Tab.CHESTS, new ChestsTabComponent(this, (StorageControllerScreenHandler)this.field_2797));
        this.tabs.put(Tab.AUTO_PROCESSING, new AutoProcessingTabComponent(this, (StorageControllerScreenHandler)this.field_2797));
        this.initTabButtons();
        TabComponent activeTab = this.tabs.get((Object)this.currentTab);
        if (activeTab != null) {
            activeTab.init((this.field_22789 - this.field_2792) / 2, (this.field_22790 - this.field_2779) / 2);
        }
        ((StorageControllerScreenHandler)this.field_2797).requestSync();
    }

    private void initTabButtons() {
        int guiX = (this.field_22789 - this.field_2792) / 2;
        int guiY = (this.field_22790 - this.field_2779) / 2;
        int tabX = guiX - 60;
        int tabY = guiY + 10;
        int tabWidth = 58;
        int tabHeight = 22;
        int tabSpacing = 4;
        this.tabButtons.clear();
        class_4185 storageTab = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Items"), btn -> this.switchTab(Tab.STORAGE)).method_46434(tabX, tabY, tabWidth, tabHeight).method_46431();
        class_4185 chestsTab = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Chests"), btn -> this.switchTab(Tab.CHESTS)).method_46434(tabX, tabY + (tabHeight + tabSpacing), tabWidth, tabHeight).method_46431();
        class_4185 processingTab = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Config"), btn -> this.switchTab(Tab.AUTO_PROCESSING)).method_46434(tabX, tabY + 2 * (tabHeight + tabSpacing), tabWidth, tabHeight).method_46431();
        this.tabButtons.add(storageTab);
        this.tabButtons.add(chestsTab);
        this.tabButtons.add(processingTab);
        this.method_37063((class_364)storageTab);
        this.method_37063((class_364)chestsTab);
        this.method_37063((class_364)processingTab);
    }

    private void switchTab(Tab newTab) {
        if (this.currentTab == newTab) {
            return;
        }
        TabComponent oldTab = this.tabs.get((Object)this.currentTab);
        if (oldTab != null) {
            oldTab.onClose();
        }
        this.currentTab = newTab;
        this.method_37067();
        for (class_4185 btn : this.tabButtons) {
            this.method_37063((class_364)btn);
        }
        TabComponent activeTab = this.tabs.get((Object)this.currentTab);
        if (activeTab != null) {
            activeTab.init((this.field_22789 - this.field_2792) / 2, (this.field_22790 - this.field_2779) / 2);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        TabComponent activeTab = this.tabs.get((Object)this.currentTab);
        if (activeTab != null) {
            activeTab.render(context, mouseX, mouseY, delta);
        }
        this.method_2380(context, mouseX, mouseY);
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, 400.0f);
        OverflowNotificationOverlay.render(context, 0.0f);
        SortProgressOverlay.render(context);
        context.method_51448().method_22909();
        if (((StorageControllerScreenHandler)this.field_2797).method_34255() != null && !((StorageControllerScreenHandler)this.field_2797).method_34255().method_7960()) {
            class_1799 cursorStack = ((StorageControllerScreenHandler)this.field_2797).method_34255();
            context.method_51427(cursorStack, mouseX - 8, mouseY - 8);
            context.method_51431(this.field_22793, cursorStack, mouseX - 8, mouseY - 8);
        }
    }

    private boolean isAnyTextFieldFocused() {
        TabComponent activeTab = this.tabs.get((Object)this.currentTab);
        if (activeTab == null) {
            return false;
        }
        if (activeTab instanceof StorageTabComponent) {
            StorageTabComponent storageTab = (StorageTabComponent)activeTab;
            return storageTab.isSearchFieldFocused();
        }
        return false;
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        context.method_25290(TEXTURE, x, y, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 256);
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
    }

    protected void method_2380(class_332 context, int mouseX, int mouseY) {
        ChestsTabComponent chestsTab;
        super.method_2380(context, mouseX, mouseY);
        if (this.currentTab == Tab.STORAGE) {
            StorageTabComponent storageTab = (StorageTabComponent)this.tabs.get((Object)Tab.STORAGE);
            if (storageTab != null) {
                storageTab.renderTooltip(context, mouseX, mouseY);
            }
        } else if (this.currentTab == Tab.CHESTS && (chestsTab = (ChestsTabComponent)this.tabs.get((Object)Tab.CHESTS)) != null) {
            chestsTab.renderTooltips(context, mouseX, mouseY);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        TabComponent activeTab = this.tabs.get((Object)this.currentTab);
        if (activeTab != null && activeTab.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.isAnyTextFieldFocused() && this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        TabComponent activeTab = this.tabs.get((Object)this.currentTab);
        if (activeTab != null && activeTab.charTyped(chr, modifiers)) {
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    public void markDirty() {
        for (TabComponent tab : this.tabs.values()) {
            tab.markDirty();
        }
    }

    public void onPriorityUpdate() {
        ChestsTabComponent chestsTab;
        if (this.currentTab == Tab.CHESTS && (chestsTab = (ChestsTabComponent)this.tabs.get((Object)Tab.CHESTS)) != null) {
            chestsTab.onPriorityUpdate();
        }
    }

    public void updateProbeStats(class_2338 position, int itemsProcessed) {
        AutoProcessingTabComponent processingTab;
        if (this.currentTab == Tab.AUTO_PROCESSING && (processingTab = (AutoProcessingTabComponent)this.tabs.get((Object)Tab.AUTO_PROCESSING)) != null) {
            processingTab.updateProbeStats(position, itemsProcessed);
        }
    }

    public void handleSortThisChest(class_2338 chestPos) {
        ChestsTabComponent chestsTab = (ChestsTabComponent)this.tabs.get((Object)Tab.CHESTS);
        if (chestsTab != null) {
            chestsTab.handleSortThisChest(chestPos);
        }
    }

    public void scheduleRefresh(long delayMs) {
        new Thread(() -> {
            try {
                Thread.sleep(delayMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.field_22787 != null) {
                this.field_22787.execute(() -> {
                    ((StorageControllerScreenHandler)this.field_2797).requestSync();
                    this.markDirty();
                });
            }
        }).start();
    }

    public boolean isShiftDown() {
        long handle = class_310.method_1551().method_22683().method_4490();
        return GLFW.glfwGetKey((long)handle, (int)340) == 1 || GLFW.glfwGetKey((long)handle, (int)344) == 1;
    }

    public void drawScaledText(class_332 context, String text, float x, float y, float scale, int color) {
        context.method_51448().method_22903();
        context.method_51448().method_46416(x, y, 0.0f);
        context.method_51448().method_22905(scale, scale, scale);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)text), 0, 0, color, true);
        context.method_51448().method_22909();
    }

    public static enum Tab {
        STORAGE("Storage"),
        CHESTS("Chests"),
        AUTO_PROCESSING("Auto-Processing");

        private final String name;

        private Tab(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

