/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.screen.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_6880;
import net.minecraft.class_9304;

public class TooltipRenderer {
    private static final int MAX_CACHE_SIZE = 100;
    private final class_327 textRenderer;
    private final class_310 client;
    private final Map<TooltipKey, List<class_2561>> tooltipCache = new LinkedHashMap<TooltipKey, List<class_2561>>(100, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<TooltipKey, List<class_2561>> eldest) {
            return this.size() > 100;
        }
    };

    public TooltipRenderer(class_327 textRenderer) {
        this.textRenderer = textRenderer;
        this.client = class_310.method_1551();
    }

    public List<class_2561> createItemTooltip(ItemVariant variant, long amount) {
        TooltipKey key = new TooltipKey(variant, amount);
        List<class_2561> cached = this.tooltipCache.get(key);
        if (cached != null) {
            return cached;
        }
        List<class_2561> tooltip = this.generateTooltip(variant, amount);
        this.tooltipCache.put(key, tooltip);
        return tooltip;
    }

    private List<class_2561> generateTooltip(ItemVariant variant, long amount) {
        class_1799 stack;
        ArrayList<class_2561> tooltip;
        block9: {
            tooltip = new ArrayList<class_2561>();
            stack = variant.toStack();
            tooltip.add(stack.method_7964());
            try {
                class_9304 enchantmentsComponent = stack.method_58657();
                if (enchantmentsComponent != null && !enchantmentsComponent.method_57543()) {
                    for (class_6880 enchantment : enchantmentsComponent.method_57534()) {
                        try {
                            int level = enchantmentsComponent.method_57536(enchantment);
                            String enchantName = ((class_1887)enchantment.comp_349()).comp_2686().getString();
                            String levelStr = level > 1 ? " " + this.toRoman(level) : "";
                            tooltip.add((class_2561)class_2561.method_43470((String)("\u00a79" + enchantName + levelStr)));
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Exception e) {
                if (!stack.method_7958()) break block9;
                tooltip.add((class_2561)class_2561.method_43470((String)"\u00a77Enchanted"));
            }
        }
        try {
            if (stack.method_7986()) {
                int durability = stack.method_7936() - stack.method_7919();
                int maxDurability = stack.method_7936();
                tooltip.add((class_2561)class_2561.method_43470((String)("\u00a77Durability: " + durability + " / " + maxDurability)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43470((String)("\u00a77Stored: \u00a7f" + String.format("%,d", amount))));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43470((String)"\u00a78Left-Click: \u00a77Take stack (64)"));
        tooltip.add((class_2561)class_2561.method_43470((String)"\u00a78Right-Click: \u00a77Take half (32)"));
        tooltip.add((class_2561)class_2561.method_43470((String)"\u00a78Ctrl+Left: \u00a77Take quarter (16)"));
        tooltip.add((class_2561)class_2561.method_43470((String)"\u00a78Shift-Click: \u00a77To inventory"));
        return tooltip;
    }

    public void invalidateCache() {
        this.tooltipCache.clear();
    }

    private String toRoman(int number) {
        if (number <= 0 || number > 10) {
            return String.valueOf(number);
        }
        String[] romans = new String[]{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X"};
        return romans[Math.min(number, 10)];
    }

    private static final class TooltipKey {
        private final ItemVariant variant;
        private final long amount;
        private final int hashCode;

        TooltipKey(ItemVariant variant, long amount) {
            this.variant = variant;
            this.amount = amount;
            this.hashCode = Objects.hash(variant, amount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TooltipKey)) {
                return false;
            }
            TooltipKey that = (TooltipKey)o;
            return this.amount == that.amount && this.variant.equals((Object)that.variant);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

