/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.blockentity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2401;
import net.minecraft.class_243;
import net.minecraft.class_2457;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3720;
import net.minecraft.class_3723;
import net.minecraft.class_3866;
import net.minecraft.class_3956;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_8786;
import net.minecraft.class_9334;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import net.shaddii.smartsorter.SmartSorter;
import net.shaddii.smartsorter.block.ProcessProbeBlock;
import net.shaddii.smartsorter.blockentity.StorageControllerBlockEntity;
import net.shaddii.smartsorter.network.ProbeStatsSyncPayload;
import net.shaddii.smartsorter.screen.StorageControllerScreenHandler;
import net.shaddii.smartsorter.util.ControllerLinkable;
import net.shaddii.smartsorter.util.FuelFilterMode;
import net.shaddii.smartsorter.util.ProcessProbeConfig;
import net.shaddii.smartsorter.util.RecipeFilterMode;

public class ProcessProbeBlockEntity
extends class_2586
implements ControllerLinkable {
    private class_2338 controllerPos;
    private class_2350 facing;
    private boolean enabled = false;
    private int processedCount = 0;
    private String machineType = "None";
    private class_2338 targetMachinePos;
    private int storedExperience = 0;
    private final Map<ItemVariant, Float> experienceCache = new HashMap<ItemVariant, Float>();
    private int tickCounter = 0;
    private static final int TICK_INTERVAL = 10;
    private static final int MAX_FUEL_PER_INSERT = 16;
    private static final int MAX_INPUT_PER_INSERT = 4;
    private final Map<ItemVariant, CachedRecipeCheck> recipeCache = new HashMap<ItemVariant, CachedRecipeCheck>();
    private final Set<ItemVariant> knownFuels = new HashSet<ItemVariant>();
    private final Set<ItemVariant> knownNonFuels = new HashSet<ItemVariant>();
    private boolean wasRedstonePowered = false;
    private boolean isLinked = false;
    private ProcessProbeConfig config;
    private boolean hasBeenConfigured = false;

    public ProcessProbeBlockEntity(class_2338 pos, class_2680 state) {
        super(SmartSorter.PROCESS_PROBE_BE_TYPE, pos, state);
        try {
            this.facing = (class_2350)state.method_11654(ProcessProbeBlock.FACING);
        }
        catch (Exception e) {
            this.facing = class_2350.field_11043;
        }
        this.config = new ProcessProbeConfig(pos, "Unknown");
    }

    @Override
    public void setController(class_2338 controllerPos) {
        this.controllerPos = controllerPos;
        this.method_5431();
    }

    @Override
    public class_2338 getController() {
        return this.controllerPos;
    }

    public boolean addLinkedBlock(class_2338 controllerPos) {
        if (this.controllerPos == null || !this.controllerPos.equals((Object)controllerPos)) {
            this.setController(controllerPos);
            return true;
        }
        return false;
    }

    public ProcessProbeConfig getConfig() {
        if (this.config == null) {
            this.config = new ProcessProbeConfig(this.field_11867, this.machineType);
        }
        this.config.position = this.field_11867;
        this.config.machineType = this.machineType;
        this.config.itemsProcessed = this.processedCount;
        return this.config;
    }

    public void setConfig(ProcessProbeConfig newConfig) {
        this.config = newConfig.copy();
        this.config.position = this.field_11867;
        this.processedCount = newConfig.itemsProcessed;
        this.hasBeenConfigured = true;
        this.method_5431();
    }

    private void syncStatsToClients() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_2586 be;
            class_3218 serverWorld = (class_3218)class_19372;
            if (this.controllerPos != null && (be = this.field_11863.method_8321(this.controllerPos)) instanceof StorageControllerBlockEntity) {
                StorageControllerBlockEntity controller = (StorageControllerBlockEntity)be;
                for (class_3222 player : serverWorld.method_18456()) {
                    class_1703 class_17032 = player.field_7512;
                    if (!(class_17032 instanceof StorageControllerScreenHandler)) continue;
                    StorageControllerScreenHandler handler = (StorageControllerScreenHandler)class_17032;
                    if (handler.controller != controller) continue;
                    ServerPlayNetworking.send((class_3222)player, (class_8710)new ProbeStatsSyncPayload(this.field_11867, this.processedCount));
                }
            }
        }
    }

    public boolean hasBeenConfigured() {
        return this.hasBeenConfigured;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, ProcessProbeBlockEntity be) {
        StorageControllerBlockEntity controller;
        ProcessProbeConfig config;
        class_2586 controllerBE;
        if (world == null || world.method_8608()) {
            return;
        }
        ++be.tickCounter;
        if (be.controllerPos != null && (controllerBE = world.method_8321(be.controllerPos)) instanceof StorageControllerBlockEntity && (config = (controller = (StorageControllerBlockEntity)controllerBE).getProbeConfig(pos)) != null && !config.enabled) {
            return;
        }
        boolean powered = ProcessProbeBlockEntity.isReceivingRedstone(world, pos);
        if (powered != be.wasRedstonePowered) {
            if (powered) {
                be.attemptLink(world, state);
            } else {
                be.disconnect(world);
            }
            be.wasRedstonePowered = powered;
        }
        be.setEnabled(powered);
        if (be.tickCounter < 10) {
            return;
        }
        be.tickCounter = 0;
        if (!be.enabled || !be.isLinked) {
            return;
        }
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        if (be.controllerPos == null) {
            return;
        }
        class_2586 controllerBE2 = world.method_8321(be.controllerPos);
        if (!(controllerBE2 instanceof StorageControllerBlockEntity)) {
            return;
        }
        StorageControllerBlockEntity controller2 = (StorageControllerBlockEntity)controllerBE2;
        ProcessProbeConfig config2 = controller2.getProbeConfig(pos);
        if (config2 != null && !config2.enabled) {
            return;
        }
        try {
            be.facing = (class_2350)state.method_11654(ProcessProbeBlock.FACING);
        }
        catch (Exception e) {
            be.facing = class_2350.field_11043;
        }
        be.handleProcessTick(serverWorld, controller2);
        if (be.tickCounter % 200 == 0) {
            be.cleanCache();
        }
    }

    private static boolean isReceivingRedstone(class_1937 world, class_2338 pos) {
        if (world.method_49803(pos)) {
            return true;
        }
        for (class_2350 dir : class_2350.values()) {
            int power;
            class_2338 neighborPos = pos.method_10093(dir);
            class_2680 neighborState = world.method_8320(neighborPos);
            if (neighborState.method_27852(class_2246.field_10091) && (power = ((Integer)neighborState.method_11654((class_2769)class_2457.field_11432)).intValue()) > 0) {
                return true;
            }
            if (neighborState.method_27852(class_2246.field_10363) && ((Boolean)neighborState.method_11654((class_2769)class_2401.field_11265)).booleanValue()) {
                return true;
            }
            if (world.method_49808(neighborPos, dir.method_10153()) <= 0) continue;
            return true;
        }
        return false;
    }

    private void attemptLink(class_1937 world, class_2680 state) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        try {
            this.facing = (class_2350)state.method_11654(ProcessProbeBlock.FACING);
        }
        catch (Exception e) {
            this.facing = class_2350.field_11043;
        }
        class_2338 machinePos = this.field_11867.method_10093(this.facing);
        class_2586 machineEntity = world.method_8321(machinePos);
        class_2680 machineState = world.method_8320(machinePos);
        if (!this.isValidProcessingMachine(machineEntity, machineState)) {
            this.notifyPlayers(serverWorld, "No valid processing machine found", false);
            this.isLinked = false;
            return;
        }
        this.updateMachineType(machineState, machineEntity);
        this.targetMachinePos = machinePos;
        class_2338 controllerInNetwork = this.traceRedstoneToController(serverWorld, this.field_11867, 256);
        if (controllerInNetwork == null) {
            controllerInNetwork = this.findControllerWithRedstoneConnection(serverWorld, this.field_11867, 32);
        }
        if (controllerInNetwork != null) {
            class_2586 be = world.method_8321(controllerInNetwork);
            if (be instanceof StorageControllerBlockEntity) {
                StorageControllerBlockEntity controller = (StorageControllerBlockEntity)be;
                boolean success = controller.registerProcessProbe(this.field_11867, this.machineType);
                if (success) {
                    this.controllerPos = controllerInNetwork;
                    this.isLinked = true;
                    this.method_5431();
                    String message = String.format("Linked to %s - Link Active", this.machineType);
                    this.notifyPlayers(serverWorld, message, true);
                } else {
                    this.isLinked = false;
                    this.notifyPlayers(serverWorld, "Controller rejected link", false);
                }
            }
        } else {
            this.isLinked = false;
            this.notifyPlayers(serverWorld, "No Storage Controller found in redstone network", false);
        }
    }

    private class_2338 traceRedstoneToController(class_3218 world, class_2338 start, int maxBlocks) {
        HashSet<class_2338> visited = new HashSet<class_2338>();
        LinkedList<class_2338> toVisit = new LinkedList<class_2338>();
        toVisit.add(start);
        for (class_2350 dir : class_2350.values()) {
            class_2338 adjacent = start.method_10093(dir);
            toVisit.add(adjacent);
        }
        class_2338 closestController = null;
        double closestDistance = Double.MAX_VALUE;
        int blocksChecked = 0;
        while (!toVisit.isEmpty() && blocksChecked < maxBlocks) {
            class_2338 current = (class_2338)toVisit.poll();
            if (visited.contains(current)) continue;
            visited.add(current);
            ++blocksChecked;
            class_2586 be = world.method_8321(current);
            if (be instanceof StorageControllerBlockEntity) {
                double dist = start.method_10262((class_2382)current);
                if (!(dist < closestDistance)) continue;
                closestDistance = dist;
                closestController = current;
                continue;
            }
            class_2680 state = world.method_8320(current);
            if (!this.isRedstoneComponent((class_1937)world, current, state)) continue;
            for (class_2350 dir : class_2350.values()) {
                double dist;
                class_2338 neighbor = current.method_10093(dir);
                if (visited.contains(neighbor)) continue;
                toVisit.add(neighbor);
                class_2586 neighborBE = world.method_8321(neighbor);
                if (!(neighborBE instanceof StorageControllerBlockEntity) || !((dist = start.method_10262((class_2382)neighbor)) < closestDistance)) continue;
                closestDistance = dist;
                closestController = neighbor;
            }
            for (class_2350 dir1 : class_2350.class_2353.field_11062) {
                for (class_2350 dir2 : new class_2350[]{class_2350.field_11036, class_2350.field_11033}) {
                    double dist;
                    class_2586 diagonalBE;
                    class_2338 diagonal = current.method_10093(dir1).method_10093(dir2);
                    if (visited.contains(diagonal)) continue;
                    class_2680 diagonalState = world.method_8320(diagonal);
                    if (this.isRedstoneComponent((class_1937)world, diagonal, diagonalState)) {
                        toVisit.add(diagonal);
                    }
                    if (!((diagonalBE = world.method_8321(diagonal)) instanceof StorageControllerBlockEntity) || !((dist = start.method_10262((class_2382)diagonal)) < closestDistance)) continue;
                    closestDistance = dist;
                    closestController = diagonal;
                }
            }
        }
        return closestController;
    }

    private class_2338 findControllerWithRedstoneConnection(class_3218 world, class_2338 probePos, int radius) {
        ArrayList<class_2338> controllers = new ArrayList<class_2338>();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    class_2338 checkPos = probePos.method_10069(x, y, z);
                    class_2586 be = world.method_8321(checkPos);
                    if (!(be instanceof StorageControllerBlockEntity)) continue;
                    controllers.add(checkPos);
                }
            }
        }
        if (controllers.isEmpty()) {
            return null;
        }
        for (class_2338 controllerPos : controllers) {
            for (class_2350 dir : class_2350.values()) {
                class_2338 adjacent = controllerPos.method_10093(dir);
                class_2680 adjacentState = world.method_8320(adjacent);
                if (!adjacentState.method_27852(class_2246.field_10091) && !adjacentState.method_27852(class_2246.field_10363) && !adjacentState.method_27852(class_2246.field_10523) && !adjacentState.method_27852(class_2246.field_10002) || !this.hasRedstonePath(world, probePos, adjacent, 256)) continue;
                return controllerPos;
            }
        }
        return null;
    }

    private boolean hasRedstonePath(class_3218 world, class_2338 start, class_2338 end, int maxBlocks) {
        HashSet<class_2338> visited = new HashSet<class_2338>();
        LinkedList<class_2338> toVisit = new LinkedList<class_2338>();
        for (class_2350 dir : class_2350.values()) {
            class_2338 adjacent = start.method_10093(dir);
            if (!this.isRedstoneComponent((class_1937)world, adjacent, world.method_8320(adjacent))) continue;
            toVisit.add(adjacent);
        }
        int checked = 0;
        while (!toVisit.isEmpty() && checked < maxBlocks) {
            class_2338 current = (class_2338)toVisit.poll();
            if (visited.contains(current)) continue;
            visited.add(current);
            ++checked;
            if (current.equals((Object)end) || current.method_19455((class_2382)end) <= 1) {
                return true;
            }
            class_2680 state = world.method_8320(current);
            if (!this.isRedstoneComponent((class_1937)world, current, state)) continue;
            for (class_2350 dir : class_2350.values()) {
                class_2338 neighbor = current.method_10093(dir);
                if (visited.contains(neighbor)) continue;
                toVisit.add(neighbor);
            }
        }
        return false;
    }

    private boolean isRedstoneComponent(class_1937 world, class_2338 pos, class_2680 state) {
        if (state.method_27852(class_2246.field_10091)) {
            return true;
        }
        if (state.method_27852(class_2246.field_10363)) {
            return true;
        }
        if (state.method_27852(class_2246.field_10523) || state.method_27852(class_2246.field_10301)) {
            return true;
        }
        if (state.method_27852(class_2246.field_10002)) {
            return true;
        }
        if (state.method_27852(class_2246.field_10450)) {
            return true;
        }
        return state.method_27852(class_2246.field_10377);
    }

    private void disconnect(class_1937 world) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        if (this.isLinked && this.controllerPos != null) {
            class_2586 be = world.method_8321(this.controllerPos);
            if (be instanceof StorageControllerBlockEntity) {
                StorageControllerBlockEntity controller = (StorageControllerBlockEntity)be;
                controller.unregisterProcessProbe(this.field_11867);
            }
            this.isLinked = false;
            this.notifyPlayers(serverWorld, "Link Inactive", false);
        }
        this.enabled = false;
    }

    private boolean isValidProcessingMachine(class_2586 entity, class_2680 state) {
        if (!(entity instanceof class_2609)) {
            return false;
        }
        return state.method_27852(class_2246.field_10181) || state.method_27852(class_2246.field_16333) || state.method_27852(class_2246.field_16334);
    }

    private void updateMachineType(class_2680 state, class_2586 blockEntity) {
        this.machineType = state.method_27852(class_2246.field_10181) ? "Furnace" : (state.method_27852(class_2246.field_16333) ? "Blast Furnace" : (state.method_27852(class_2246.field_16334) ? "Smoker" : "Unknown"));
        if (this.config != null) {
            this.config.machineType = this.machineType;
        }
    }

    private void notifyPlayers(class_3218 world, String message, boolean success) {
        class_5250 text = class_2561.method_43470((String)message).method_27692(success ? class_124.field_1060 : class_124.field_1054);
        for (class_3222 player : world.method_18456()) {
            if (!(player.method_5707(class_243.method_24953((class_2382)this.field_11867)) < 256.0)) continue;
            player.method_7353((class_2561)text, true);
        }
    }

    private void handleProcessTick(class_3218 world, StorageControllerBlockEntity controller) {
        class_2338 machinePos = this.field_11867.method_10093(this.facing);
        class_2586 blockEntity = world.method_8321(machinePos);
        if (!(blockEntity instanceof class_1263)) {
            return;
        }
        class_1263 inventory = (class_1263)blockEntity;
        this.targetMachinePos = machinePos;
        SlotConfig slots = this.getSlotConfig(blockEntity);
        if (slots == null) {
            return;
        }
        ProcessProbeConfig config = controller.getProbeConfig(this.field_11867);
        if (config == null) {
            return;
        }
        if (blockEntity instanceof class_2609) {
            class_2609 furnace = (class_2609)blockEntity;
            this.processFurnaceOptimized(world, furnace, controller, slots, config);
        }
    }

    private SlotConfig getSlotConfig(class_2586 blockEntity) {
        if (blockEntity instanceof class_2609) {
            return new FurnaceSlots();
        }
        return null;
    }

    private void processFurnaceOptimized(class_3218 world, class_2609 furnace, StorageControllerBlockEntity controller, SlotConfig slots, ProcessProbeConfig config) {
        Object stack;
        boolean outputsHandled = this.extractOutputsOptimized(world, (class_1263)furnace, controller, slots);
        if (!outputsHandled) {
            return;
        }
        boolean needsInput = false;
        boolean needsFuel = false;
        int inputSpace = 0;
        int fuelSpace = 0;
        class_1799 currentInput = class_1799.field_8037;
        Object currentFuel = class_1799.field_8037;
        for (int slot : slots.getInputSlots()) {
            stack = furnace.method_5438(slot);
            if (stack.method_7960()) {
                needsInput = true;
                inputSpace = 4;
                break;
            }
            if (stack.method_7947() >= stack.method_7914()) continue;
            needsInput = true;
            currentInput = stack;
            inputSpace = Math.min(stack.method_7914() - stack.method_7947(), 4);
            break;
        }
        for (int slot : slots.getFuelSlots()) {
            stack = furnace.method_5438(slot);
            if (stack.method_7960()) {
                needsFuel = true;
                fuelSpace = 16;
                break;
            }
            if (stack.method_7947() >= stack.method_7914()) continue;
            needsFuel = true;
            currentFuel = stack;
            fuelSpace = Math.min(stack.method_7914() - stack.method_7947(), 16);
            break;
        }
        if (!needsInput && !needsFuel) {
            return;
        }
        class_1799 foundInput = class_1799.field_8037;
        class_1799 foundFuel = class_1799.field_8037;
        Map<ItemVariant, Long> networkItems = controller.getNetworkItems();
        class_3956<?> recipeType = this.getRecipeTypeForFurnace(furnace);
        for (Map.Entry entry : networkItems.entrySet()) {
            int amount;
            if ((Long)entry.getValue() <= 0L) continue;
            ItemVariant variant = (ItemVariant)entry.getKey();
            if (needsInput && foundInput.method_7960()) {
                if (currentInput.method_7960()) {
                    if (this.canSmelt(world, variant, furnace, recipeType) && this.matchesRecipeFilter(variant, config.recipeFilter)) {
                        amount = (int)Math.min((long)inputSpace, (Long)entry.getValue());
                        foundInput = controller.extractItem(variant, amount);
                        needsInput = false;
                    }
                } else if (ItemVariant.of((class_1799)currentInput).equals((Object)variant)) {
                    amount = (int)Math.min((long)inputSpace, (Long)entry.getValue());
                    foundInput = controller.extractItem(variant, amount);
                    needsInput = false;
                }
            }
            if (needsFuel && foundFuel.method_7960()) {
                if (currentFuel.method_7960()) {
                    if (this.isFuel(world, variant) && this.matchesFuelFilter(variant, config.fuelFilter)) {
                        amount = (int)Math.min((long)fuelSpace, (Long)entry.getValue());
                        foundFuel = controller.extractItem(variant, amount);
                        needsFuel = false;
                    }
                } else if (ItemVariant.of((class_1799)currentFuel).equals((Object)variant)) {
                    amount = (int)Math.min((long)fuelSpace, (Long)entry.getValue());
                    foundFuel = controller.extractItem(variant, amount);
                    needsFuel = false;
                }
            }
            if (needsInput || needsFuel) continue;
            break;
        }
        if (!foundInput.method_7960()) {
            int inputSlot = slots.getInputSlots()[0];
            class_1799 class_17992 = furnace.method_5438(inputSlot);
            if (class_17992.method_7960()) {
                furnace.method_5447(inputSlot, foundInput);
            } else {
                class_17992.method_7933(foundInput.method_7947());
            }
            furnace.method_5431();
        }
        if (!foundFuel.method_7960()) {
            int fuelSlot = slots.getFuelSlots()[0];
            class_1799 class_17993 = furnace.method_5438(fuelSlot);
            if (class_17993.method_7960()) {
                furnace.method_5447(fuelSlot, foundFuel);
            } else {
                class_17993.method_7933(foundFuel.method_7947());
            }
            furnace.method_5431();
        }
    }

    private boolean canSmelt(class_3218 world, ItemVariant variant, class_2609 furnace, class_3956<?> recipeType) {
        if (recipeType == null) {
            return false;
        }
        CachedRecipeCheck cached = this.recipeCache.get(variant);
        if (cached != null && cached.isValid()) {
            return cached.canProcess;
        }
        class_1799 stack = variant.toStack(1);
        class_9696 recipeInput = new class_9696(stack);
        boolean canSmelt = false;
        try {
            if (furnace instanceof class_3866) {
                canSmelt = world.method_64577().method_8132(class_3956.field_17546, (class_9695)recipeInput, (class_1937)world).isPresent();
            } else if (furnace instanceof class_3720) {
                canSmelt = world.method_64577().method_8132(class_3956.field_17547, (class_9695)recipeInput, (class_1937)world).isPresent();
            } else if (furnace instanceof class_3723) {
                canSmelt = world.method_64577().method_8132(class_3956.field_17548, (class_9695)recipeInput, (class_1937)world).isPresent();
            }
        }
        catch (Exception e) {
            canSmelt = false;
        }
        this.recipeCache.put(variant, new CachedRecipeCheck(canSmelt));
        return canSmelt;
    }

    private boolean isFuel(class_3218 world, ItemVariant variant) {
        if (this.knownFuels.contains(variant)) {
            return true;
        }
        if (this.knownNonFuels.contains(variant)) {
            return false;
        }
        class_1799 stack = variant.toStack(1);
        boolean isFuel = world.method_61269().method_61752(stack);
        if (isFuel) {
            this.knownFuels.add(variant);
            return true;
        }
        this.knownNonFuels.add(variant);
        return false;
    }

    private boolean extractOutputsOptimized(class_3218 world, class_1263 inventory, StorageControllerBlockEntity controller, SlotConfig slots) {
        boolean allExtracted = true;
        for (int slot : slots.getOutputSlots()) {
            class_1799 output = inventory.method_5438(slot);
            if (output.method_7960()) continue;
            class_1799 toInsert = output.method_7972();
            class_1799 remaining = controller.insertItem(toInsert);
            if (remaining.method_7960()) {
                if (inventory instanceof class_2609) {
                    class_2609 furnace = (class_2609)inventory;
                    this.collectFurnaceExperience(world, furnace, controller, toInsert);
                }
                inventory.method_5447(slot, class_1799.field_8037);
                inventory.method_5431();
                this.processedCount += toInsert.method_7947();
                if (this.config != null) {
                    this.config.itemsProcessed = this.processedCount;
                }
                this.method_5431();
                controller.syncProbeStatsToClients(this.field_11867, this.processedCount);
                continue;
            }
            allExtracted = false;
        }
        return allExtracted;
    }

    private void collectFurnaceExperience(class_3218 world, class_2609 furnace, StorageControllerBlockEntity controller, class_1799 outputStack) {
        int totalXP;
        class_3956<?> recipeType = this.getRecipeTypeForFurnace(furnace);
        if (recipeType == null) {
            return;
        }
        ItemVariant outputVariant = ItemVariant.of((class_1799)outputStack);
        Float experiencePerItem = this.experienceCache.get(outputVariant);
        if (experiencePerItem == null) {
            experiencePerItem = Float.valueOf(this.getExperienceForOutput(world, outputStack, recipeType));
            this.experienceCache.put(outputVariant, experiencePerItem);
        }
        if ((totalXP = Math.round(experiencePerItem.floatValue() * (float)outputStack.method_7947())) > 0) {
            controller.addExperience(totalXP);
        }
    }

    private float getExperienceForOutput(class_3218 world, class_1799 output, class_3956<?> recipeType) {
        try {
            Collection allRecipes = world.method_64577().method_8126();
            for (class_8786 recipeEntry : allRecipes) {
                class_1874 cookingRecipe;
                class_1799 recipeOutput;
                class_1860 recipe = recipeEntry.comp_1933();
                if (recipe.method_17716() != recipeType || !(recipe instanceof class_1874) || !class_1799.method_7984((class_1799)(recipeOutput = (cookingRecipe = (class_1874)recipe).method_59998(new class_9696(class_1799.field_8037), (class_7225.class_7874)world.method_30349())), (class_1799)output)) continue;
                return cookingRecipe.method_8171();
            }
        }
        catch (Exception e) {
            return 0.1f;
        }
        return 0.1f;
    }

    private class_3956<?> getRecipeTypeForFurnace(class_2609 furnace) {
        if (furnace instanceof class_3866) {
            return class_3956.field_17546;
        }
        if (furnace instanceof class_3720) {
            return class_3956.field_17547;
        }
        if (furnace instanceof class_3723) {
            return class_3956.field_17548;
        }
        return null;
    }

    private void cleanCache() {
        this.recipeCache.entrySet().removeIf(entry -> !((CachedRecipeCheck)entry.getValue()).isValid());
        if (this.knownFuels.size() > 100) {
            this.knownFuels.clear();
        }
        if (this.knownNonFuels.size() > 500) {
            this.knownNonFuels.clear();
        }
        if (this.experienceCache.size() > 200) {
            this.experienceCache.clear();
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            class_2586 be;
            this.enabled = enabled;
            if (this.config != null) {
                this.config.enabled = enabled;
            }
            if (this.field_11863 instanceof class_3218 && this.controllerPos != null && (be = this.field_11863.method_8321(this.controllerPos)) instanceof StorageControllerBlockEntity) {
                StorageControllerBlockEntity controller = (StorageControllerBlockEntity)be;
                controller.updateProbeConfig(this.config);
                controller.syncProbeConfigToClients(this.field_11867, this.config);
            }
            this.method_5431();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getProcessedCount() {
        return this.processedCount;
    }

    public String getMachineType() {
        return this.machineType;
    }

    public String getStatusText() {
        if (!this.enabled) {
            return "\u00a7cDisabled";
        }
        if (!this.isLinked) {
            return "\u00a7eNot Linked";
        }
        if (this.targetMachinePos == null) {
            return "\u00a7eNo Machine Found";
        }
        return "\u00a7aActive";
    }

    public int getStoredExperience() {
        return this.storedExperience;
    }

    public void collectExperience(class_1657 player) {
        if (this.storedExperience > 0) {
            player.method_7255(this.storedExperience);
            player.method_7353((class_2561)class_2561.method_43470((String)String.format("\u00a7aCollected %d XP!", this.storedExperience)), true);
            this.storedExperience = 0;
            this.method_5431();
        }
    }

    public void method_11007(class_11372 view) {
        super.method_11007(view);
        if (this.controllerPos != null) {
            view.method_71466("ControllerPos", this.controllerPos.method_10063());
        }
        if (this.targetMachinePos != null) {
            view.method_71466("TargetMachine", this.targetMachinePos.method_10063());
        }
        view.method_71472("Enabled", this.enabled);
        view.method_71465("Processed", this.processedCount);
        view.method_71469("MachineType", this.machineType);
        view.method_71465("StoredXP", this.storedExperience);
        view.method_71472("WasRedstonePowered", this.wasRedstonePowered);
        view.method_71472("IsLinked", this.isLinked);
        view.method_71472("HasBeenConfigured", this.hasBeenConfigured);
        if (this.config != null && this.hasBeenConfigured) {
            if (this.config.customName != null) {
                view.method_71469("Config_CustomName", this.config.customName);
            }
            view.method_71472("Config_Enabled", this.config.enabled);
            view.method_71469("Config_RecipeFilter", this.config.recipeFilter.asString());
            view.method_71469("Config_FuelFilter", this.config.fuelFilter.asString());
            view.method_71465("Config_ItemsProcessed", this.config.itemsProcessed);
            view.method_71465("Config_Index", this.config.index);
        }
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        view.method_71440("ControllerPos").ifPresent(posLong -> {
            this.controllerPos = class_2338.method_10092((long)posLong);
        });
        view.method_71440("TargetMachine").ifPresent(posLong -> {
            this.targetMachinePos = class_2338.method_10092((long)posLong);
        });
        this.enabled = view.method_71433("Enabled", false);
        this.processedCount = view.method_71424("Processed", 0);
        this.machineType = view.method_71428("MachineType", "None");
        this.storedExperience = view.method_71424("StoredXP", 0);
        this.wasRedstonePowered = view.method_71433("WasRedstonePowered", false);
        this.isLinked = view.method_71433("IsLinked", false);
        this.hasBeenConfigured = view.method_71433("HasBeenConfigured", false);
        if (this.hasBeenConfigured) {
            this.config = new ProcessProbeConfig(this.field_11867, this.machineType);
            this.config.customName = view.method_71428("Config_CustomName", null);
            this.config.enabled = view.method_71433("Config_Enabled", true);
            this.config.recipeFilter = RecipeFilterMode.fromString(view.method_71428("Config_RecipeFilter", "ORES_ONLY"));
            this.config.fuelFilter = FuelFilterMode.fromString(view.method_71428("Config_FuelFilter", "COAL_ONLY"));
            this.config.itemsProcessed = view.method_71424("Config_ItemsProcessed", this.processedCount);
            this.config.index = view.method_71424("Config_Index", 0);
        } else {
            this.config = new ProcessProbeConfig(this.field_11867, this.machineType);
        }
    }

    public void onRemoved() {
        class_2586 be;
        if (this.field_11863 != null && !this.field_11863.method_8608() && this.controllerPos != null && (be = this.field_11863.method_8321(this.controllerPos)) instanceof StorageControllerBlockEntity) {
            StorageControllerBlockEntity controller = (StorageControllerBlockEntity)be;
            controller.unregisterProcessProbe(this.field_11867);
        }
        this.controllerPos = null;
        this.targetMachinePos = null;
        this.recipeCache.clear();
        this.knownFuels.clear();
        this.knownNonFuels.clear();
        this.experienceCache.clear();
    }

    private boolean matchesRecipeFilter(ItemVariant variant, RecipeFilterMode filter) {
        class_1799 stack = variant.toStack(1);
        switch (filter) {
            case ALL_SMELTABLE: {
                return true;
            }
            case ORES_ONLY: {
                String id = class_7923.field_41178.method_10221((Object)variant.getItem()).method_12832();
                return id.contains("ore") || id.contains("raw_");
            }
            case FOOD_ONLY: {
                return stack.method_57353().method_57832(class_9334.field_50075);
            }
            case RAW_METALS_ONLY: {
                String itemId = class_7923.field_41178.method_10221((Object)variant.getItem()).method_12832();
                return itemId.startsWith("raw_");
            }
            case NO_WOOD: {
                String woodId = class_7923.field_41178.method_10221((Object)variant.getItem()).method_12832();
                return !woodId.contains("log") && !woodId.contains("wood") && !woodId.contains("plank");
            }
            case CUSTOM: {
                return false;
            }
        }
        return true;
    }

    private boolean matchesFuelFilter(ItemVariant variant, FuelFilterMode filter) {
        class_1799 stack = variant.toStack(1);
        class_1792 item = variant.getItem();
        switch (filter) {
            case ANY_FUEL: {
                return true;
            }
            case COAL_ONLY: {
                return item == class_1802.field_8713 || item == class_1802.field_8665;
            }
            case BLOCKS_ONLY: {
                return item == class_1802.field_8797 || item == class_1802.field_17533 || item == class_1802.field_8894;
            }
            case NO_WOOD: {
                String id = class_7923.field_41178.method_10221((Object)item).method_12832();
                return !id.contains("log") && !id.contains("wood") && !id.contains("plank");
            }
            case LAVA_ONLY: {
                return item == class_1802.field_8187;
            }
            case CUSTOM: {
                return false;
            }
        }
        return true;
    }

    private static interface SlotConfig {
        public int[] getInputSlots();

        public int[] getFuelSlots();

        public int[] getOutputSlots();
    }

    private static class FurnaceSlots
    implements SlotConfig {
        private FurnaceSlots() {
        }

        @Override
        public int[] getInputSlots() {
            return new int[]{0};
        }

        @Override
        public int[] getFuelSlots() {
            return new int[]{1};
        }

        @Override
        public int[] getOutputSlots() {
            return new int[]{2};
        }
    }

    private static class CachedRecipeCheck {
        final boolean canProcess;
        final long timestamp;

        CachedRecipeCheck(boolean canProcess) {
            this.canProcess = canProcess;
            this.timestamp = System.currentTimeMillis();
        }

        boolean isValid() {
            return System.currentTimeMillis() - this.timestamp < 10000L;
        }
    }
}

