/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7654;
import net.shaddii.smartsorter.util.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryManager
extends class_4309<JsonElement>
implements IdentifiableResourceReloadListener {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"smartsorter");
    private static CategoryManager INSTANCE;
    private static final class_2960 ID;
    private final List<Category> sortedCategories = new ArrayList<Category>();
    private final Map<class_1792, Category> cache = new HashMap<class_1792, Category>();
    private final Map<class_1792, Category> itemCategoryIndex = new HashMap<class_1792, Category>();

    public CategoryManager() {
        super(Codec.PASSTHROUGH.xmap(dynamic -> (JsonElement)dynamic.convert((DynamicOps)JsonOps.INSTANCE).getValue(), jsonElement -> new Dynamic((DynamicOps)JsonOps.INSTANCE, jsonElement)), class_7654.method_45114((String)"smartsorter/categories"));
    }

    public static CategoryManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CategoryManager();
        }
        return INSTANCE;
    }

    public class_2960 getFabricId() {
        return ID;
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        this.sortedCategories.clear();
        this.cache.clear();
        this.sortedCategories.add(Category.ALL);
        for (Map.Entry<class_2960, JsonElement> entry : prepared.entrySet()) {
            try {
                JsonObject obj = entry.getValue().getAsJsonObject();
                class_2960 id = class_2960.method_60654((String)obj.get("id").getAsString());
                String displayName = obj.get("display_name").getAsString();
                String shortName = obj.has("short_name") ? obj.get("short_name").getAsString() : displayName;
                int order = obj.get("order").getAsInt();
                Category category = new Category(id, displayName, shortName, order);
                if (obj.has("items")) {
                    obj.getAsJsonArray("items").forEach(element -> category.addEntry(element.getAsString()));
                }
                this.sortedCategories.add(category);
                LOGGER.info("Loaded category: {} ({})", (Object)displayName, (Object)id);
            }
            catch (Exception e) {
                LOGGER.error("Failed to load category from {}: {}", (Object)entry.getKey(), (Object)e.getMessage());
            }
        }
        this.sortedCategories.add(Category.MISC);
        Collections.sort(this.sortedCategories);
        LOGGER.info("Loaded {} categories", (Object)this.sortedCategories.size());
    }

    private void buildItemIndex() {
        for (Category category : this.sortedCategories) {
            if (category == Category.ALL || category == Category.MISC) continue;
            for (class_1792 item : category.getMatchingItems()) {
                this.itemCategoryIndex.putIfAbsent(item, category);
            }
        }
    }

    public Category categorize(class_1792 item) {
        return this.itemCategoryIndex.getOrDefault(item, Category.MISC);
    }

    public List<Category> getAllCategories() {
        return new ArrayList<Category>(this.sortedCategories);
    }

    public Category getCategory(class_2960 id) {
        return this.sortedCategories.stream().filter(c -> c.getId().equals((Object)id)).findFirst().orElse(Category.MISC);
    }

    public Category getCategory(String idString) {
        class_2960 id = class_2960.method_12829((String)idString);
        return id != null ? this.getCategory(id) : Category.MISC;
    }

    static {
        ID = class_2960.method_60655((String)"smartsorter", (String)"category_manager");
    }
}

