/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter;

import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.shaddii.smartsorter.block.IntakeBlock;
import net.shaddii.smartsorter.block.OutputProbeBlock;
import net.shaddii.smartsorter.blockentity.IntakeBlockEntity;
import net.shaddii.smartsorter.blockentity.OutputProbeBlockEntity;
import net.shaddii.smartsorter.blockentity.StorageControllerBlockEntity;

public final class StorageLogic {
    private static final int MAX_PULL_PER_OP = 2;

    private StorageLogic() {
    }

    public static void pullFromFacingIntoBuffer(IntakeBlockEntity intake) {
        if (intake == null || intake.method_10997() == null || !intake.getBuffer().method_7960()) {
            return;
        }
        class_1937 world = intake.method_10997();
        class_2350 facing = (class_2350)intake.method_11010().method_11654(IntakeBlock.FACING);
        class_2338 sourcePos = intake.method_11016().method_10093(facing);
        Storage<ItemVariant> fromStorage = StorageLogic.locateItemStorage(world, sourcePos, facing.method_10153());
        if (fromStorage == null) {
            return;
        }
        for (StorageView view : fromStorage) {
            int toTake;
            ItemVariant variant;
            if (view.isResourceBlank() || view.getAmount() == 0L || !StorageLogic.canInsertAnywhere(world, intake, variant = (ItemVariant)view.getResource(), toTake = Math.min(2, (int)Math.min(view.getAmount(), (long)variant.getItem().method_7882())))) continue;
            Transaction tx = Transaction.openOuter();
            try {
                long extracted = view.extract((Object)variant, (long)toTake, (TransactionContext)tx);
                if (extracted <= 0L) continue;
                intake.setBuffer(variant.toStack((int)extracted));
                tx.commit();
                return;
            }
            finally {
                if (tx == null) continue;
                tx.close();
            }
        }
    }

    public static boolean routeBuffer(class_1937 world, IntakeBlockEntity intake) {
        class_1799 buffer = intake.getBuffer();
        if (buffer.method_7960()) {
            return false;
        }
        if (intake.isInManagedMode()) {
            class_2586 be;
            class_2338 controllerPos = intake.getController();
            if (controllerPos != null && (be = world.method_8321(controllerPos)) instanceof StorageControllerBlockEntity) {
                StorageControllerBlockEntity controller = (StorageControllerBlockEntity)be;
                class_1799 remaining = controller.insertItem(buffer.method_7972());
                if (remaining.method_7960()) {
                    intake.setBuffer(class_1799.field_8037);
                    return true;
                }
                if (remaining.method_7947() < buffer.method_7947()) {
                    intake.setBuffer(remaining);
                    return true;
                }
            }
            return false;
        }
        if (intake.isInDirectMode()) {
            ItemVariant variant = ItemVariant.of((class_1799)buffer);
            int remaining = buffer.method_7947();
            for (class_2338 probePos : intake.getOutputs()) {
                OutputProbeBlockEntity probe;
                class_2586 target = world.method_8321(probePos);
                if (!(target instanceof OutputProbeBlockEntity) || !(probe = (OutputProbeBlockEntity)target).accepts(variant)) continue;
                int inserted = StorageLogic.insertIntoInventoryFacingProbe(world, probe, variant, remaining);
                if (inserted > 0) {
                    remaining -= inserted;
                }
                if (remaining > 0) continue;
                break;
            }
            if (remaining != buffer.method_7947()) {
                if (remaining <= 0) {
                    intake.setBuffer(class_1799.field_8037);
                } else {
                    buffer.method_7939(remaining);
                    intake.setBuffer(buffer);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean canInsertAnywhere(class_1937 world, IntakeBlockEntity intake, ItemVariant variant, long amount) {
        if (intake.isInManagedMode()) {
            class_2338 controllerPos = intake.getController();
            if (controllerPos == null) {
                return false;
            }
            class_2586 be = world.method_8321(controllerPos);
            if (!(be instanceof StorageControllerBlockEntity)) {
                return false;
            }
            StorageControllerBlockEntity controller = (StorageControllerBlockEntity)be;
            return controller.canInsertItem(variant, (int)amount);
        }
        if (intake.isInDirectMode()) {
            for (class_2338 probePos : intake.getOutputs()) {
                OutputProbeBlockEntity probe;
                class_2586 be = world.method_8321(probePos);
                if (!(be instanceof OutputProbeBlockEntity) || !(probe = (OutputProbeBlockEntity)be).accepts(variant)) continue;
                class_2350 facing = (class_2350)probe.method_11010().method_11654(OutputProbeBlock.FACING);
                class_2338 targetPos = probe.method_11016().method_10093(facing);
                class_2586 target = world.method_8321(targetPos);
                if (!(target instanceof class_1263)) continue;
                class_1263 inventory = (class_1263)target;
                for (int i = 0; i < inventory.method_5439(); ++i) {
                    class_1799 slot = inventory.method_5438(i);
                    if (slot.method_7960()) {
                        return true;
                    }
                    if (!class_1799.method_31577((class_1799)slot, (class_1799)variant.toStack(1)) || slot.method_7947() >= slot.method_7914()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static int insertIntoInventoryFacingProbe(class_1937 world, OutputProbeBlockEntity probe, ItemVariant variant, int amount) {
        int i;
        class_2350 facing = (class_2350)probe.method_11010().method_11654(OutputProbeBlock.FACING);
        class_2338 targetPos = probe.method_11016().method_10093(facing);
        class_2586 targetBE = world.method_8321(targetPos);
        if (!(targetBE instanceof class_1263)) {
            return 0;
        }
        class_1263 inventory = (class_1263)targetBE;
        class_1799 toInsert = variant.toStack(amount);
        int originalCount = toInsert.method_7947();
        for (i = 0; i < inventory.method_5439() && !toInsert.method_7960(); ++i) {
            int canAdd;
            class_1799 slot = inventory.method_5438(i);
            if (slot.method_7960() || !class_1799.method_31577((class_1799)slot, (class_1799)toInsert) || (canAdd = Math.min(slot.method_7914(), inventory.method_5444()) - slot.method_7947()) <= 0) continue;
            int add = Math.min(canAdd, toInsert.method_7947());
            slot.method_7933(add);
            toInsert.method_7934(add);
            inventory.method_5431();
        }
        for (i = 0; i < inventory.method_5439() && !toInsert.method_7960(); ++i) {
            if (!inventory.method_5438(i).method_7960()) continue;
            int insertCount = Math.min(inventory.method_5444(), toInsert.method_7947());
            class_1799 newStack = toInsert.method_46651(insertCount);
            inventory.method_5447(i, newStack);
            toInsert.method_7934(insertCount);
            inventory.method_5431();
        }
        return originalCount - toInsert.method_7947();
    }

    private static Storage<ItemVariant> locateItemStorage(class_1937 world, class_2338 pos, class_2350 searchSide) {
        Objects.requireNonNull(world);
        Objects.requireNonNull(pos);
        Storage found = (Storage)ItemStorage.SIDED.find(world, pos, (Object)searchSide);
        if (found == null) {
            found = (Storage)ItemStorage.SIDED.find(world, pos, null);
        }
        class_2586 be = world.method_8321(pos);
        if (found == null && be instanceof class_1263) {
            class_1263 inv = (class_1263)be;
            found = InventoryStorage.of((class_1263)inv, null);
        }
        return found;
    }
}

