/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.blockentity;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.shaddii.smartsorter.SmartSorter;
import net.shaddii.smartsorter.block.OutputProbeBlock;
import net.shaddii.smartsorter.blockentity.IntakeBlockEntity;
import net.shaddii.smartsorter.blockentity.StorageControllerBlockEntity;
import net.shaddii.smartsorter.util.SortUtil;
import org.jetbrains.annotations.Nullable;

public class OutputProbeBlockEntity
extends class_2586 {
    public boolean ignoreComponents = true;
    public boolean useTags = false;
    public boolean requireAllTags = false;
    public ProbeMode mode = ProbeMode.FILTER;
    private final List<class_2338> linkedBlocks = new ArrayList<class_2338>();
    private List<class_2338> linkedBlocksCopy = null;
    private boolean linkedBlocksCopyDirty = true;

    public OutputProbeBlockEntity(class_2338 pos, class_2680 state) {
        super(SmartSorter.PROBE_BE_TYPE, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, OutputProbeBlockEntity be) {
        if (world.method_8608()) {
            return;
        }
        if (world.method_8510() % 100L == 0L) {
            be.validateLinkedBlocks();
        }
    }

    public boolean addLinkedBlock(class_2338 blockPos) {
        if (!this.linkedBlocks.contains(blockPos)) {
            this.linkedBlocks.add(blockPos);
            this.linkedBlocksCopyDirty = true;
            this.method_5431();
            if (this.field_11863 != null) {
                class_2680 state = this.field_11863.method_8320(this.field_11867);
                this.field_11863.method_8413(this.field_11867, state, state, 3);
            }
            return true;
        }
        return false;
    }

    public boolean removeLinkedBlock(class_2338 blockPos) {
        boolean removed = this.linkedBlocks.remove(blockPos);
        if (removed) {
            this.linkedBlocksCopyDirty = true;
            this.method_5431();
            if (this.field_11863 != null) {
                class_2680 state = this.field_11863.method_8320(this.field_11867);
                this.field_11863.method_8413(this.field_11867, state, state, 3);
            }
        }
        return removed;
    }

    public List<class_2338> getLinkedBlocks() {
        if (this.linkedBlocksCopyDirty || this.linkedBlocksCopy == null) {
            this.linkedBlocksCopy = new ArrayList<class_2338>(this.linkedBlocks);
            this.linkedBlocksCopyDirty = false;
        }
        return this.linkedBlocksCopy;
    }

    public boolean hasLinkedBlocks() {
        return !this.linkedBlocks.isEmpty();
    }

    private void validateLinkedBlocks() {
        if (this.field_11863 == null) {
            return;
        }
        this.linkedBlocks.removeIf(blockPos -> {
            class_2586 be = this.field_11863.method_8321(blockPos);
            return !(be instanceof StorageControllerBlockEntity) && !(be instanceof IntakeBlockEntity);
        });
    }

    public void notifyLinkedBlocks() {
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            return;
        }
        for (class_2338 blockPos : new ArrayList<class_2338>(this.linkedBlocks)) {
            class_2586 be = this.field_11863.method_8321(blockPos);
            if (!(be instanceof StorageControllerBlockEntity)) continue;
            StorageControllerBlockEntity controller = (StorageControllerBlockEntity)be;
            controller.onProbeInventoryChanged(this);
        }
    }

    @Deprecated
    public void setLinkedController(class_2338 controllerPos) {
        this.addLinkedBlock(controllerPos);
    }

    @Deprecated
    public class_2338 getLinkedController() {
        if (this.field_11863 == null) {
            return null;
        }
        for (class_2338 blockPos : this.linkedBlocks) {
            class_2586 be = this.field_11863.method_8321(blockPos);
            if (!(be instanceof StorageControllerBlockEntity)) continue;
            return blockPos;
        }
        return null;
    }

    public Storage<ItemVariant> getTargetStorage() {
        if (this.field_11863 == null) {
            return null;
        }
        class_2350 face = (class_2350)this.method_11010().method_11654(OutputProbeBlock.FACING);
        class_2338 targetPos = this.field_11867.method_10093(face);
        Storage sidedStorage = (Storage)ItemStorage.SIDED.find(this.field_11863, targetPos, (Object)face.method_10153());
        if (sidedStorage != null) {
            return sidedStorage;
        }
        Storage storage = (Storage)ItemStorage.SIDED.find(this.field_11863, targetPos, null);
        if (storage != null) {
            return storage;
        }
        class_1263 inv = this.getTargetInventory();
        if (inv != null) {
            return InventoryStorage.of((class_1263)inv, null);
        }
        return null;
    }

    public class_1263 getTargetInventory() {
        class_2281 chestBlock;
        class_1263 chestInv;
        if (this.field_11863 == null) {
            return null;
        }
        class_2350 face = (class_2350)this.method_11010().method_11654(OutputProbeBlock.FACING);
        class_2338 targetPos = this.field_11867.method_10093(face);
        class_2680 targetState = this.field_11863.method_8320(targetPos);
        class_2248 class_22482 = targetState.method_26204();
        if (class_22482 instanceof class_2281 && (chestInv = class_2281.method_17458((class_2281)(chestBlock = (class_2281)class_22482), (class_2680)targetState, (class_1937)this.field_11863, (class_2338)targetPos, (boolean)true)) != null) {
            return chestInv;
        }
        class_2586 be = this.field_11863.method_8321(targetPos);
        if (be instanceof class_1263) {
            class_1263 inv = (class_1263)be;
            return inv;
        }
        return null;
    }

    public boolean accepts(ItemVariant incoming) {
        if (this.field_11863 == null) {
            return false;
        }
        class_1263 inv = this.getTargetInventory();
        if (inv == null) {
            return false;
        }
        int invSize = inv.method_5439();
        if (this.mode == ProbeMode.ACCEPT_ALL) {
            return this.hasSpaceInInventory(inv, incoming, 1);
        }
        if (this.mode == ProbeMode.FILTER) {
            if (this.useTags) {
                return SortUtil.acceptsByInventoryTags(inv, incoming, this.requireAllTags);
            }
            for (int i = 0; i < invSize; ++i) {
                class_1799 stack = inv.method_5438(i);
                if (stack.method_7960()) continue;
                ItemVariant present = ItemVariant.of((class_1799)stack);
                if (!(this.ignoreComponents ? present.getItem() == incoming.getItem() : present.equals((Object)incoming))) continue;
                return true;
            }
            return false;
        }
        if (this.mode == ProbeMode.PRIORITY) {
            return this.hasSpaceInInventory(inv, incoming, 1);
        }
        return false;
    }

    private boolean hasSpaceInInventory(class_1263 inv, ItemVariant variant, int amount) {
        if (inv == null) {
            return false;
        }
        int invSize = inv.method_5439();
        for (int i = 0; i < invSize; ++i) {
            int maxStack;
            int canAdd;
            class_1799 stack = inv.method_5438(i);
            if (stack.method_7960()) {
                return true;
            }
            if (!class_1799.method_31577((class_1799)stack, (class_1799)variant.toStack(1)) || (canAdd = (maxStack = Math.min(stack.method_7914(), inv.method_5444())) - stack.method_7947()) <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasSpace(ItemVariant variant, int amount) {
        class_1263 inv = this.getTargetInventory();
        return this.hasSpaceInInventory(inv, variant, amount);
    }

    public void cycleMode() {
        this.mode = switch (this.mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ProbeMode.ACCEPT_ALL;
            case 1 -> ProbeMode.FILTER;
            case 2 -> ProbeMode.FILTER;
        };
        this.method_5431();
    }

    public String getModeName() {
        return switch (this.mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "Filter Mode";
            case 1 -> "Accept All";
            case 2 -> "Priority Mode";
        };
    }

    public int getModeColor() {
        return switch (this.mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 4886754;
            case 1 -> 8311585;
            case 2 -> 16098851;
        };
    }

    public void onRemoved(class_1937 world) {
        if (world.method_8608()) {
            return;
        }
        for (class_2338 blockPos : new ArrayList<class_2338>(this.linkedBlocks)) {
            class_2586 be = world.method_8321(blockPos);
            if (!(be instanceof StorageControllerBlockEntity)) continue;
            StorageControllerBlockEntity controller = (StorageControllerBlockEntity)be;
            controller.removeProbe(this.field_11867);
        }
        this.linkedBlocks.clear();
    }

    private void writeProbeData(class_2487 nbt) {
        nbt.method_10556("ignoreComponents", this.ignoreComponents);
        nbt.method_10556("useTags", this.useTags);
        nbt.method_10556("requireAllTags", this.requireAllTags);
        nbt.method_10582("mode", this.mode.name());
        nbt.method_10569("linked_blocks_count", this.linkedBlocks.size());
        for (int i = 0; i < this.linkedBlocks.size(); ++i) {
            nbt.method_10544("linked_block_" + i, this.linkedBlocks.get(i).method_10063());
        }
    }

    private void readProbeData(class_2487 nbt) {
        this.ignoreComponents = nbt.method_10577("ignoreComponents");
        this.useTags = nbt.method_10577("useTags");
        this.requireAllTags = nbt.method_10577("requireAllTags");
        try {
            this.mode = ProbeMode.valueOf(nbt.method_10558("mode"));
        }
        catch (IllegalArgumentException e) {
            this.mode = ProbeMode.FILTER;
        }
        this.linkedBlocks.clear();
        int count = nbt.method_10550("linked_blocks_count");
        for (int i = 0; i < count; ++i) {
            String key = "linked_block_" + i;
            if (!nbt.method_10545(key)) continue;
            this.linkedBlocks.add(class_2338.method_10092((long)nbt.method_10537(key)));
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        this.writeProbeData(nbt);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.readProbeData(nbt);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }

    public static enum ProbeMode {
        FILTER,
        ACCEPT_ALL,
        PRIORITY;

    }
}

