/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.widget;

import java.util.function.Consumer;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import org.lwjgl.glfw.GLFW;

public class SearchBoxWidget
implements class_4068,
class_364 {
    private final class_327 textRenderer;
    private int x;
    private int y;
    private int width;
    private int height;
    private String text = "";
    private boolean isFocused = false;
    private int cursorPosition = 0;
    private int tickCounter = 0;
    private Consumer<String> onTextChanged;
    private static final int BACKGROUND_COLOR = -7631989;
    private static final int BORDER_COLOR = -16777216;
    private static final int FOCUSED_BORDER_COLOR = -1;
    private static final int TEXT_COLOR = -1;
    private static final int PLACEHOLDER_COLOR = -8355712;
    private static final String PLACEHOLDER = "Search...";

    public SearchBoxWidget(class_327 textRenderer, int x, int y, int width, int height) {
        this.textRenderer = textRenderer;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setOnTextChanged(Consumer<String> callback) {
        this.onTextChanged = callback;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, -7631989);
        int borderColor = this.isFocused ? -1 : -16777216;
        context.method_25292(this.x, this.x + this.width - 1, this.y, borderColor);
        context.method_25292(this.x, this.x + this.width - 1, this.y + this.height - 1, borderColor);
        context.method_25301(this.x, this.y, this.y + this.height - 1, borderColor);
        context.method_25301(this.x + this.width - 1, this.y, this.y + this.height - 1, borderColor);
        String displayText = this.text.isEmpty() && !this.isFocused ? PLACEHOLDER : this.text;
        int textColor = this.text.isEmpty() && !this.isFocused ? -8355712 : -1;
        String trimmedText = this.textRenderer.method_27523(displayText, this.width - 8);
        context.method_51433(this.textRenderer, trimmedText, this.x + 4, this.y + (this.height - 8) / 2, textColor, false);
        if (this.isFocused && this.tickCounter / 6 % 2 == 0) {
            int cursorX = this.x + 4 + this.textRenderer.method_1727(this.text.substring(0, Math.min(this.cursorPosition, this.text.length())));
            context.method_25294(cursorX, this.y + 2, cursorX + 1, this.y + this.height - 2, -1);
        }
    }

    public void tick() {
        ++this.tickCounter;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean wasClicked;
        boolean bl = wasClicked = mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
        if (button == 0) {
            this.method_25365(wasClicked);
            if (wasClicked && !this.text.isEmpty()) {
                int relativeX = (int)(mouseX - (double)this.x - 4.0);
                this.cursorPosition = this.getCursorPositionFromX(relativeX);
            }
        }
        return wasClicked;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return false;
    }

    private int getCursorPositionFromX(int px) {
        int currentX = 0;
        for (int i = 0; i <= this.text.length(); ++i) {
            int nextX = this.textRenderer.method_1727(this.text.substring(0, i));
            if (px < (currentX + nextX) / 2) {
                return Math.max(0, i - 1);
            }
            currentX = nextX;
        }
        return this.text.length();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.isFocused) {
            return false;
        }
        switch (keyCode) {
            case 256: {
                this.method_25365(false);
                return true;
            }
            case 259: {
                if (!this.text.isEmpty() && this.cursorPosition > 0) {
                    this.text = this.text.substring(0, this.cursorPosition - 1) + this.text.substring(this.cursorPosition);
                    --this.cursorPosition;
                    this.onTextChange();
                }
                return true;
            }
            case 261: {
                if (this.cursorPosition < this.text.length()) {
                    this.text = this.text.substring(0, this.cursorPosition) + this.text.substring(this.cursorPosition + 1);
                    this.onTextChange();
                }
                return true;
            }
            case 263: {
                if (this.cursorPosition > 0) {
                    --this.cursorPosition;
                }
                return true;
            }
            case 262: {
                if (this.cursorPosition < this.text.length()) {
                    ++this.cursorPosition;
                }
                return true;
            }
            case 268: {
                this.cursorPosition = 0;
                return true;
            }
            case 269: {
                this.cursorPosition = this.text.length();
                return true;
            }
            case 65: {
                if (!this.isControlDown()) break;
                return true;
            }
            case 86: {
                if (!this.isControlDown()) break;
                long handle = class_310.method_1551().method_22683().method_4490();
                String clipboard = GLFW.glfwGetClipboardString((long)handle);
                if (clipboard != null && !clipboard.isEmpty()) {
                    for (char c : clipboard.toCharArray()) {
                        this.method_25400(c, 0);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean method_25400(char chr, int modifiers) {
        if (!this.isFocused) {
            return false;
        }
        if (this.isValidChar(chr)) {
            this.text = this.text.substring(0, this.cursorPosition) + chr + this.text.substring(this.cursorPosition);
            ++this.cursorPosition;
            this.onTextChange();
            return true;
        }
        return false;
    }

    private boolean isControlDown() {
        long handle = class_310.method_1551().method_22683().method_4490();
        return GLFW.glfwGetKey((long)handle, (int)341) == 1 || GLFW.glfwGetKey((long)handle, (int)345) == 1;
    }

    private boolean isValidChar(char chr) {
        return chr >= ' ' && chr != '\u007f';
    }

    private void onTextChange() {
        if (this.onTextChanged != null) {
            this.onTextChanged.accept(this.text);
        }
    }

    public void method_25365(boolean focused) {
        if (this.isFocused != focused) {
            this.isFocused = focused;
            if (focused) {
                this.cursorPosition = this.text.length();
            }
        }
    }

    public boolean method_25370() {
        return this.isFocused;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.cursorPosition = text.length();
        this.onTextChange();
    }

    public void clear() {
        this.setText("");
    }
}

