/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.blockentity.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.shaddii.smartsorter.blockentity.OutputProbeBlockEntity;
import net.shaddii.smartsorter.util.ChestConfig;

public class ProbeRegistry {
    private final List<class_2338> linkedProbes = new ArrayList<class_2338>();
    private final Map<class_2338, OutputProbeBlockEntity> probeCache = new HashMap<class_2338, OutputProbeBlockEntity>();
    private final Map<class_2338, Boolean> hasItemsCache = new HashMap<class_2338, Boolean>();
    private List<class_2338> sortedProbesCache;
    private boolean sortCacheDirty = true;
    private long lastCacheUpdate = 0L;
    private static final long CACHE_LIFETIME = 100L;

    public boolean addProbe(class_2338 probePos) {
        if (this.linkedProbes.contains(probePos)) {
            return false;
        }
        this.linkedProbes.add(probePos);
        this.invalidateCache();
        return true;
    }

    public boolean removeProbe(class_2338 probePos) {
        boolean removed = this.linkedProbes.remove(probePos);
        if (removed) {
            this.probeCache.remove(probePos);
            this.hasItemsCache.remove(probePos);
            this.invalidateCache();
        }
        return removed;
    }

    public List<class_2338> getSortedProbes(class_1937 world) {
        long currentTime;
        long l = currentTime = world != null ? world.method_8510() : 0L;
        if (!this.sortCacheDirty && this.sortedProbesCache != null && currentTime - this.lastCacheUpdate < 100L) {
            return this.sortedProbesCache;
        }
        this.rebuildSortedCache(world, currentTime);
        return this.sortedProbesCache;
    }

    private void rebuildSortedCache(class_1937 world, long currentTime) {
        ArrayList<ProbeEntry> entries = new ArrayList<ProbeEntry>(this.linkedProbes.size());
        for (class_2338 probePos : this.linkedProbes) {
            OutputProbeBlockEntity probe = this.getCachedProbe(world, probePos);
            if (probe == null) continue;
            ChestConfig config = probe.getChestConfig();
            entries.add(new ProbeEntry(probePos, probe.mode, config, this.getCachedHasItems(world, probePos, probe, currentTime)));
        }
        entries.sort((a, b) -> {
            int bPri;
            int aPri = a.config != null ? a.config.hiddenPriority : 0;
            int n = bPri = b.config != null ? b.config.hiddenPriority : 0;
            if (aPri != bPri) {
                return Integer.compare(bPri, aPri);
            }
            if (a.hasItems != b.hasItems) {
                return a.hasItems ? -1 : 1;
            }
            return Integer.compare(this.getModeOrder(a.mode), this.getModeOrder(b.mode));
        });
        this.sortedProbesCache = new ArrayList<class_2338>(entries.size());
        for (ProbeEntry entry : entries) {
            this.sortedProbesCache.add(entry.pos);
        }
        this.sortCacheDirty = false;
        this.lastCacheUpdate = currentTime;
    }

    private OutputProbeBlockEntity getCachedProbe(class_1937 world, class_2338 pos) {
        class_2586 be;
        OutputProbeBlockEntity cached = this.probeCache.get(pos);
        if (cached != null) {
            if (!cached.method_11015()) {
                return cached;
            }
            this.probeCache.remove(pos);
        }
        if ((be = world.method_8321(pos)) instanceof OutputProbeBlockEntity) {
            OutputProbeBlockEntity probe = (OutputProbeBlockEntity)be;
            this.probeCache.put(pos, probe);
            return probe;
        }
        return null;
    }

    private boolean getCachedHasItems(class_1937 world, class_2338 probePos, OutputProbeBlockEntity probe, long currentTime) {
        Boolean cached = this.hasItemsCache.get(probePos);
        if (cached != null && currentTime - this.lastCacheUpdate < 20L) {
            return cached;
        }
        boolean hasItems = this.checkHasItemsFast(probe);
        this.hasItemsCache.put(probePos, hasItems);
        return hasItems;
    }

    private boolean checkHasItemsFast(OutputProbeBlockEntity probe) {
        class_1263 inv = probe.getTargetInventory();
        if (inv == null) {
            return false;
        }
        int size = inv.method_5439();
        for (int i = 0; i < size; ++i) {
            if (inv.method_5438(i).method_7960()) continue;
            return true;
        }
        return false;
    }

    public List<class_2338> getLinkedProbes() {
        return new ArrayList<class_2338>(this.linkedProbes);
    }

    public int getProbeCount() {
        return this.linkedProbes.size();
    }

    public void invalidateCache() {
        this.sortCacheDirty = true;
        this.hasItemsCache.clear();
    }

    public void validate(class_1937 world) {
        this.linkedProbes.removeIf(probePos -> {
            OutputProbeBlockEntity probe = this.getCachedProbe(world, (class_2338)probePos);
            if (probe == null || probe.method_11015()) {
                this.probeCache.remove(probePos);
                this.hasItemsCache.remove(probePos);
                return true;
            }
            return false;
        });
    }

    private int getModeOrder(OutputProbeBlockEntity.ProbeMode mode) {
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case OutputProbeBlockEntity.ProbeMode.FILTER -> 0;
            case OutputProbeBlockEntity.ProbeMode.PRIORITY -> 1;
            case OutputProbeBlockEntity.ProbeMode.ACCEPT_ALL -> 2;
        };
    }

    private record ProbeEntry(class_2338 pos, OutputProbeBlockEntity.ProbeMode mode, ChestConfig config, boolean hasItems) {
    }
}

