/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.screen.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.shaddii.smartsorter.util.Category;
import net.shaddii.smartsorter.util.CategoryManager;
import net.shaddii.smartsorter.util.SortMode;

public class ItemCacheManager {
    private List<Map.Entry<ItemVariant, Long>> cachedFilteredList = null;
    private List<Map.Entry<ItemVariant, Long>> cachedUnfilteredList = null;
    private String lastSearchTerm = "";
    private SortMode lastSortMode = SortMode.NAME;
    private Category lastFilterCategory = Category.ALL;
    private int lastItemCount = 0;
    private final Map<ItemVariant, Category> categoryCache = new HashMap<ItemVariant, Category>();
    private final CategoryManager categoryManager = CategoryManager.getInstance();

    public List<Map.Entry<ItemVariant, Long>> getFilteredItems(Map<ItemVariant, Long> items, String search, SortMode sortMode, Category category) {
        boolean itemsChanged;
        int itemCount = items.size();
        boolean searchChanged = !search.equals(this.lastSearchTerm);
        boolean sortChanged = sortMode != this.lastSortMode;
        boolean categoryChanged = !category.equals(this.lastFilterCategory);
        boolean bl = itemsChanged = itemCount != this.lastItemCount;
        if (!(this.cachedFilteredList == null || searchChanged || sortChanged || categoryChanged || itemsChanged)) {
            return this.cachedFilteredList;
        }
        if (this.cachedFilteredList != null && !sortChanged && !categoryChanged && !itemsChanged && searchChanged) {
            List<Map.Entry<ItemVariant, Long>> result = this.filterBySearch(this.cachedUnfilteredList, search);
            this.cachedFilteredList = result;
            this.lastSearchTerm = search;
            return result;
        }
        List<Map.Entry<ItemVariant, Long>> result = new ArrayList<Map.Entry<ItemVariant, Long>>(items.entrySet());
        if (category != Category.ALL) {
            result = this.filterByCategory(result, category);
        }
        this.cachedUnfilteredList = new ArrayList<Map.Entry<ItemVariant, Long>>(result);
        if (!search.isEmpty()) {
            result = this.filterBySearch(result, search);
        }
        this.sortList(result, sortMode);
        this.cachedFilteredList = result;
        this.lastItemCount = itemCount;
        this.lastSearchTerm = search;
        this.lastSortMode = sortMode;
        this.lastFilterCategory = category;
        return result;
    }

    private List<Map.Entry<ItemVariant, Long>> filterByCategory(List<Map.Entry<ItemVariant, Long>> list, Category category) {
        ArrayList<Map.Entry<ItemVariant, Long>> result = new ArrayList<Map.Entry<ItemVariant, Long>>(list.size());
        for (Map.Entry<ItemVariant, Long> entry : list) {
            Category itemCategory = this.categoryCache.computeIfAbsent(entry.getKey(), variant -> this.categoryManager.categorize(variant.getItem()));
            if (!itemCategory.equals(category)) continue;
            result.add(entry);
        }
        return result;
    }

    private List<Map.Entry<ItemVariant, Long>> filterBySearch(List<Map.Entry<ItemVariant, Long>> list, String search) {
        if (search.isEmpty()) {
            return list;
        }
        String lowerSearch = search.toLowerCase();
        ArrayList<Map.Entry<ItemVariant, Long>> result = new ArrayList<Map.Entry<ItemVariant, Long>>(list.size());
        for (Map.Entry<ItemVariant, Long> entry : list) {
            String itemName = entry.getKey().getItem().method_63680().getString().toLowerCase();
            if (!itemName.contains(lowerSearch)) continue;
            result.add(entry);
        }
        return result;
    }

    private void sortList(List<Map.Entry<ItemVariant, Long>> list, SortMode sortMode) {
        switch (sortMode) {
            case NAME: {
                list.sort((a, b) -> {
                    String nameA = ((ItemVariant)a.getKey()).getItem().method_63680().getString();
                    String nameB = ((ItemVariant)b.getKey()).getItem().method_63680().getString();
                    return nameA.compareTo(nameB);
                });
                break;
            }
            case COUNT: {
                list.sort((a, b) -> Long.compare((Long)b.getValue(), (Long)a.getValue()));
            }
        }
    }

    public void invalidate() {
        this.cachedFilteredList = null;
        this.cachedUnfilteredList = null;
    }

    public void clearAll() {
        this.cachedFilteredList = null;
        this.cachedUnfilteredList = null;
        this.categoryCache.clear();
    }
}

