/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.screen.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;

public class TooltipRenderer {
    private static final int MAX_CACHE_SIZE = 100;
    private final class_327 textRenderer;
    private final class_310 client;
    private final Map<TooltipKey, List<class_2561>> tooltipCache = new LinkedHashMap<TooltipKey, List<class_2561>>(100, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<TooltipKey, List<class_2561>> eldest) {
            return this.size() > 100;
        }
    };

    public TooltipRenderer(class_327 textRenderer) {
        this.textRenderer = textRenderer;
        this.client = class_310.method_1551();
    }

    public List<class_2561> createItemTooltip(ItemVariant variant, long amount) {
        TooltipKey key = new TooltipKey(variant, amount);
        List<class_2561> cached = this.tooltipCache.get(key);
        if (cached != null) {
            return cached;
        }
        List<class_2561> tooltip = this.generateTooltip(variant, amount);
        this.tooltipCache.put(key, tooltip);
        return tooltip;
    }

    private List<class_2561> generateTooltip(ItemVariant variant, long amount) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        class_1799 stack = variant.toStack();
        try {
            class_1836.class_1837 tooltipType = this.client != null && this.client.field_1690.field_1827 ? class_1836.field_41071 : class_1836.field_41070;
            List vanillaTooltip = stack.method_7950(class_1792.class_9635.field_51353, (class_1657)(this.client != null ? this.client.field_1724 : null), (class_1836)tooltipType);
            tooltip.addAll(vanillaTooltip);
        }
        catch (Exception e) {
            tooltip.add(stack.method_7964());
        }
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43470((String)("\u00a77Stored: \u00a7f" + String.format("%,d", amount))));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43470((String)"\u00a78Left-Click: \u00a77Take stack (64)"));
        tooltip.add((class_2561)class_2561.method_43470((String)"\u00a78Right-Click: \u00a77Take half (32)"));
        tooltip.add((class_2561)class_2561.method_43470((String)"\u00a78Ctrl+Left: \u00a77Take quarter (16)"));
        tooltip.add((class_2561)class_2561.method_43470((String)"\u00a78Shift-Click: \u00a77To inventory"));
        return tooltip;
    }

    public void invalidateCache() {
        this.tooltipCache.clear();
    }

    private String toRoman(int number) {
        if (number <= 0 || number > 10) {
            return String.valueOf(number);
        }
        String[] romans = new String[]{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X"};
        return romans[Math.min(number, 10)];
    }

    private static final class TooltipKey {
        private final ItemVariant variant;
        private final long amount;
        private final int hashCode;

        TooltipKey(ItemVariant variant, long amount) {
            this.variant = variant;
            this.amount = amount;
            this.hashCode = Objects.hash(variant, amount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TooltipKey)) {
                return false;
            }
            TooltipKey that = (TooltipKey)o;
            return this.amount == that.amount && this.variant.equals((Object)that.variant);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

