/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7654;
import net.minecraft.class_7923;
import net.shaddii.smartsorter.network.CategorySyncPayload;
import net.shaddii.smartsorter.util.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryManager
extends class_4309<JsonElement> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"smartsorter");
    private static CategoryManager INSTANCE;
    private final List<Category> sortedCategories = new ArrayList<Category>();
    private final Map<class_1792, Category> itemCategoryIndex = new HashMap<class_1792, Category>();
    private boolean indexIsBuilt = false;

    public CategoryManager() {
        super(Codec.PASSTHROUGH.xmap(dynamic -> (JsonElement)dynamic.convert((DynamicOps)JsonOps.INSTANCE).getValue(), jsonElement -> new Dynamic((DynamicOps)JsonOps.INSTANCE, jsonElement)), class_7654.method_45114((String)"smartsorter/categories"));
    }

    public static CategoryManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CategoryManager();
        }
        return INSTANCE;
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        this.sortedCategories.clear();
        this.itemCategoryIndex.clear();
        this.indexIsBuilt = false;
        this.sortedCategories.add(Category.ALL);
        for (Map.Entry<class_2960, JsonElement> entry : prepared.entrySet()) {
            try {
                JsonObject obj = entry.getValue().getAsJsonObject();
                class_2960 id = class_2960.method_60654((String)obj.get("id").getAsString());
                String displayName = obj.get("display_name").getAsString();
                String shortName = obj.has("short_name") ? obj.get("short_name").getAsString() : displayName;
                int order = obj.get("order").getAsInt();
                Category category = new Category(id, displayName, shortName, order);
                if (obj.has("items")) {
                    obj.getAsJsonArray("items").forEach(element -> category.addEntry(element.getAsString()));
                }
                this.sortedCategories.add(category);
            }
            catch (Exception e) {
                LOGGER.error("Failed to load category from {}: {}", (Object)entry.getKey(), (Object)e.getMessage());
            }
        }
        this.sortedCategories.add(Category.MISC);
        Collections.sort(this.sortedCategories);
        LOGGER.info("Smart Sorter: Loaded {} categories. Index will be built on first use.", (Object)this.sortedCategories.size());
    }

    private void buildItemIndex() {
        if (this.indexIsBuilt) {
            return;
        }
        LOGGER.info("Building Smart Sorter item index for the first time...");
        this.itemCategoryIndex.clear();
        for (Category category : this.sortedCategories) {
            category.buildCache();
        }
        for (class_1792 item : class_7923.field_41178) {
            boolean foundMatch = false;
            for (Category category : this.sortedCategories) {
                if (category == Category.ALL || category == Category.MISC || !category.matches(item)) continue;
                this.itemCategoryIndex.put(item, category);
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            this.itemCategoryIndex.put(item, Category.MISC);
        }
        this.indexIsBuilt = true;
        LOGGER.info("Smart Sorter index built, {} items categorized.", (Object)this.itemCategoryIndex.size());
    }

    public Category categorize(class_1792 item) {
        this.buildItemIndex();
        return this.itemCategoryIndex.getOrDefault(item, Category.MISC);
    }

    public List<Category> getAllCategories() {
        return new ArrayList<Category>(this.sortedCategories);
    }

    public Category getCategory(class_2960 id) {
        return this.sortedCategories.stream().filter(c -> c.getId().equals((Object)id)).findFirst().orElse(Category.MISC);
    }

    public Category getCategory(String idString) {
        class_2960 id = class_2960.method_12829((String)idString);
        return id != null ? this.getCategory(id) : Category.MISC;
    }

    public void updateFromServer(List<CategorySyncPayload.CategoryData> serverCategories) {
        LOGGER.info("Updating categories from server, received {} categories", (Object)serverCategories.size());
        this.sortedCategories.clear();
        this.itemCategoryIndex.clear();
        this.indexIsBuilt = false;
        this.sortedCategories.add(Category.ALL);
        for (CategorySyncPayload.CategoryData data : serverCategories) {
            try {
                class_2960 id = class_2960.method_12829((String)data.id());
                if (id == null || id.equals((Object)Category.ALL.getId()) || id.equals((Object)Category.MISC.getId())) continue;
                Category category = new Category(id, data.displayName(), data.shortName(), data.order());
                LOGGER.debug("Loading category {}: {} items", (Object)data.displayName(), (Object)data.items().size());
                for (String itemEntry : data.items()) {
                    category.addEntry(itemEntry);
                }
                this.sortedCategories.add(category);
            }
            catch (Exception e) {
                LOGGER.error("Failed to load category {}: {}", (Object)data.id(), (Object)e.getMessage());
            }
        }
        this.sortedCategories.add(Category.MISC);
        Collections.sort(this.sortedCategories);
        LOGGER.info("Updated categories from server: {} categories loaded", (Object)this.sortedCategories.size());
    }

    public List<CategorySyncPayload.CategoryData> getCategoryData() {
        ArrayList<CategorySyncPayload.CategoryData> data = new ArrayList<CategorySyncPayload.CategoryData>();
        for (Category cat : this.sortedCategories) {
            if (cat == Category.ALL || cat == Category.MISC) continue;
            data.add(new CategorySyncPayload.CategoryData(cat.getId().toString(), cat.getDisplayName(), cat.getShortName(), cat.getOrder(), new ArrayList<String>(cat.getEntries())));
        }
        return data;
    }
}

