/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.shaddii.smartsorter.blockentity.StorageControllerBlockEntity;
import net.shaddii.smartsorter.network.SortProgressPayload;
import net.shaddii.smartsorter.screen.StorageControllerScreenHandler;

public class ChunkedSorter {
    private static final Map<UUID, SortTask> activeTasks = new HashMap<UUID, SortTask>();
    private static final int CHESTS_PER_TICK = 10;

    public static void init() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            Iterator<Map.Entry<UUID, SortTask>> iterator = activeTasks.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<UUID, SortTask> entry = iterator.next();
                SortTask task = entry.getValue();
                class_3222 player = server.method_3760().method_14602(entry.getKey());
                if (player == null) {
                    iterator.remove();
                    continue;
                }
                boolean finished = task.processChunk(player);
                if (!finished) continue;
                iterator.remove();
                ServerPlayNetworking.send((class_3222)player, (class_8710)new SortProgressPayload(task.positions.size(), task.positions.size(), true, task.overflowCounts, task.overflowDestinations));
            }
        });
    }

    public static void startSorting(class_3222 player, StorageControllerBlockEntity controller, List<class_2338> positions) {
        UUID playerId = player.method_5667();
        activeTasks.remove(playerId);
        SortTask task = new SortTask(controller, positions);
        activeTasks.put(playerId, task);
        ServerPlayNetworking.send((class_3222)player, (class_8710)new SortProgressPayload(0, positions.size(), false, null, null));
    }

    public static boolean isPlayerSorting(UUID playerId) {
        return activeTasks.containsKey(playerId);
    }

    public static float getSortProgress(UUID playerId) {
        SortTask task = activeTasks.get(playerId);
        if (task == null) {
            return 0.0f;
        }
        return (float)task.currentIndex / (float)task.positions.size();
    }

    private static class SortTask {
        private final StorageControllerBlockEntity controller;
        private final List<class_2338> positions;
        private final Map<ItemVariant, Long> overflowCounts = new HashMap<ItemVariant, Long>();
        private final Map<ItemVariant, String> overflowDestinations = new HashMap<ItemVariant, String>();
        private int currentIndex = 0;

        SortTask(StorageControllerBlockEntity controller, List<class_2338> positions) {
            this.controller = controller;
            this.positions = positions;
        }

        boolean processChunk(class_3222 player) {
            int processed = 0;
            while (this.currentIndex < this.positions.size() && processed < 10) {
                class_2338 pos = this.positions.get(this.currentIndex);
                if (this.controller.isChestLinked(pos)) {
                    this.controller.sortChestIntoNetwork(pos, this.overflowCounts, this.overflowDestinations);
                    ++processed;
                }
                ++this.currentIndex;
            }
            ServerPlayNetworking.send((class_3222)player, (class_8710)new SortProgressPayload(this.currentIndex, this.positions.size(), false, null, null));
            if (this.currentIndex < this.positions.size()) {
                return false;
            }
            this.controller.method_5431();
            this.controller.updateNetworkCache();
            ServerPlayNetworking.send((class_3222)player, (class_8710)new SortProgressPayload(this.positions.size(), this.positions.size(), true, this.overflowCounts.isEmpty() ? null : this.overflowCounts, this.overflowDestinations.isEmpty() ? null : this.overflowDestinations));
            class_1703 class_17032 = player.field_7512;
            if (class_17032 instanceof StorageControllerScreenHandler) {
                StorageControllerScreenHandler handler = (StorageControllerScreenHandler)class_17032;
                handler.sendNetworkUpdate(player);
            }
            return true;
        }
    }
}

