/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.widget;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_8710;
import net.shaddii.smartsorter.network.ChestConfigUpdatePayload;
import net.shaddii.smartsorter.screen.StorageControllerScreen;
import net.shaddii.smartsorter.util.ChestConfig;
import net.shaddii.smartsorter.util.ChestSortMode;
import net.shaddii.smartsorter.widget.DropdownWidget;

public class ChestSelectorWidget {
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final class_327 textRenderer;
    List<ChestConfig> chests = new ArrayList<ChestConfig>();
    private int selectedIndex = -1;
    private Consumer<ChestConfig> onSelectionChange;
    private Consumer<ChestConfig> onConfigUpdate;
    public DropdownWidget dropdown;
    private ChestSortMode currentSortMode = ChestSortMode.PRIORITY;
    private Map<class_2338, ChestConfig> chestConfigs = new HashMap<class_2338, ChestConfig>();
    private class_4185 editButton;
    private class_4185 sortButton;
    private class_342 renameField;
    private boolean isRenaming = false;
    private final StorageControllerScreen parentScreen;

    public ChestSelectorWidget(int x, int y, int width, int height, class_327 textRenderer, StorageControllerScreen parentScreen) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.textRenderer = textRenderer;
        this.parentScreen = parentScreen;
        int dropdownWidth = width - 25;
        this.dropdown = new DropdownWidget(x, y, dropdownWidth, height, (class_2561)class_2561.method_43470((String)"Select Chest"));
        this.sortButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udce4"), btn -> this.triggerSort()).method_46434(x + dropdownWidth + 2, y - 14, 20, 10).method_46431();
        this.editButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u270f"), btn -> this.startRenaming()).method_46434(x + dropdownWidth + 2, y, 20, height).method_46431();
        this.renameField = new class_342(textRenderer, x, y, dropdownWidth, height, (class_2561)class_2561.method_43470((String)""));
        this.renameField.method_1880(32);
        this.renameField.method_1862(false);
        this.renameField.method_1858(true);
    }

    public void reselectChestByPos(class_2338 posToSelect) {
        if (posToSelect == null) {
            if (!this.chests.isEmpty()) {
                this.setSelectedIndex(0);
            }
            return;
        }
        for (int i = 0; i < this.chests.size(); ++i) {
            if (!this.chests.get((int)i).position.equals((Object)posToSelect)) continue;
            this.setSelectedIndex(i);
            if (this.onSelectionChange != null) {
                this.onSelectionChange.accept(this.chests.get(i));
            }
            return;
        }
        if (!this.chests.isEmpty()) {
            this.setSelectedIndex(0);
        }
    }

    private String getPriorityColor(int priority, int totalChests) {
        if (totalChests == 0) {
            return "\u00a77";
        }
        int topThird = Math.max(1, totalChests / 3);
        int bottomThird = Math.max(1, totalChests * 2 / 3);
        if (priority <= topThird) {
            return "\u00a7a";
        }
        if (priority <= bottomThird) {
            return "\u00a7e";
        }
        return "\u00a7c";
    }

    private String buildChestDisplayText(ChestConfig config, int totalChests) {
        Object displayText;
        Object object = displayText = config.customName != null && !config.customName.isEmpty() ? config.customName : "Chest";
        if (config.filterMode == ChestConfig.FilterMode.CUSTOM) {
            displayText = (String)displayText + " \u00a7d[Custom]";
        } else if (config.filterMode == ChestConfig.FilterMode.CATEGORY || config.filterMode == ChestConfig.FilterMode.CATEGORY_AND_PRIORITY || config.filterMode == ChestConfig.FilterMode.OVERFLOW || config.filterMode == ChestConfig.FilterMode.BLACKLIST) {
            displayText = (String)displayText + " \u00a77[" + config.filterCategory.getShortName() + "]";
        }
        displayText = config.filterMode == ChestConfig.FilterMode.CUSTOM ? (String)displayText + " \u00a7d0" : (String)displayText + " " + this.getPriorityColor(config.priority, totalChests) + config.priority;
        int fullness = config.cachedFullness;
        if (fullness >= 0) {
            String fullnessColor = fullness >= 90 ? "\u00a7c" : (fullness >= 70 ? "\u00a7e" : "\u00a7a");
            displayText = (String)displayText + " " + fullnessColor + fullness + "%";
        } else {
            displayText = (String)displayText + " \u00a78--%";
        }
        return displayText;
    }

    private void triggerSort() {
        ChestConfig selected = this.getSelectedChest();
        if (selected == null) {
            return;
        }
        if (selected.filterMode == ChestConfig.FilterMode.CUSTOM) {
            return;
        }
        this.parentScreen.handleSortThisChest(selected.position);
        if (this.onConfigUpdate != null) {
            this.onConfigUpdate.accept(selected);
        }
    }

    public void setSortMode(ChestSortMode mode) {
        this.currentSortMode = mode;
        this.updateChests(this.chestConfigs);
    }

    public ChestSortMode getSortMode() {
        return this.currentSortMode;
    }

    public void updateChests(Map<class_2338, ChestConfig> configs) {
        this.chestConfigs = configs;
        this.chests.clear();
        this.dropdown.clearEntries();
        ArrayList<ChestConfig> sortedChests = new ArrayList<ChestConfig>(configs.values());
        sortedChests.sort((a, b) -> {
            boolean bIsFiltered;
            if (a.filterMode == ChestConfig.FilterMode.CUSTOM && b.filterMode != ChestConfig.FilterMode.CUSTOM) {
                return -1;
            }
            if (b.filterMode == ChestConfig.FilterMode.CUSTOM && a.filterMode != ChestConfig.FilterMode.CUSTOM) {
                return 1;
            }
            if (this.currentSortMode == ChestSortMode.FULLNESS) {
                int fullnessCompare = Integer.compare(b.cachedFullness, a.cachedFullness);
                if (fullnessCompare != 0) {
                    return fullnessCompare;
                }
                return a.getSortKey(ChestSortMode.NAME).compareTo(b.getSortKey(ChestSortMode.NAME));
            }
            if (this.currentSortMode == ChestSortMode.PRIORITY) {
                int bPriority;
                int aPriority = a.filterMode == ChestConfig.FilterMode.CUSTOM ? 0 : a.priority;
                int n = bPriority = b.filterMode == ChestConfig.FilterMode.CUSTOM ? 0 : b.priority;
                if (aPriority != bPriority) {
                    return Integer.compare(aPriority, bPriority);
                }
                return a.getSortKey(ChestSortMode.NAME).compareTo(b.getSortKey(ChestSortMode.NAME));
            }
            boolean aIsFiltered = a.filterMode != ChestConfig.FilterMode.NONE && a.filterMode != ChestConfig.FilterMode.CUSTOM;
            boolean bl = bIsFiltered = b.filterMode != ChestConfig.FilterMode.NONE && b.filterMode != ChestConfig.FilterMode.CUSTOM;
            if (aIsFiltered != bIsFiltered) {
                return aIsFiltered ? -1 : 1;
            }
            String keyA = a.getSortKey(this.currentSortMode);
            String keyB = b.getSortKey(this.currentSortMode);
            return keyA.compareTo(keyB);
        });
        int totalChests = sortedChests.size();
        for (ChestConfig config : sortedChests) {
            this.chests.add(config);
            String displayText = this.buildChestDisplayText(config, totalChests);
            this.dropdown.addEntry(displayText, displayText);
        }
        if (!this.chests.isEmpty() && this.selectedIndex < 0) {
            this.selectedIndex = 0;
            this.dropdown.setSelectedIndex(0);
            this.notifySelectionChange();
        }
    }

    public void setOnSelectionChange(Consumer<ChestConfig> callback) {
        this.onSelectionChange = callback;
        this.dropdown.setOnSelect(index -> {
            this.selectedIndex = index;
            this.notifySelectionChange();
        });
    }

    public void setOnConfigUpdate(Consumer<ChestConfig> callback) {
        this.onConfigUpdate = callback;
    }

    private void startRenaming() {
        if (this.chests.isEmpty() || this.isRenaming) {
            return;
        }
        this.isRenaming = true;
        ChestConfig config = this.chests.get(this.selectedIndex);
        this.renameField.method_1852(config.customName != null && !config.customName.isEmpty() ? config.customName : "");
        this.renameField.method_1862(true);
        this.renameField.method_25365(true);
        this.dropdown.field_22764 = false;
    }

    private void finishRenaming() {
        if (!this.isRenaming) {
            return;
        }
        this.isRenaming = false;
        String newName = this.renameField.method_1882().trim();
        ChestConfig config = this.chests.get(this.selectedIndex);
        config.customName = newName.isEmpty() ? "" : newName;
        ClientPlayNetworking.send((class_8710)new ChestConfigUpdatePayload(config));
        if (this.onConfigUpdate != null) {
            this.onConfigUpdate.accept(config);
        }
        this.renameField.method_1862(false);
        this.renameField.method_25365(false);
        this.dropdown.field_22764 = true;
    }

    private void notifySelectionChange() {
        if (this.onSelectionChange != null) {
            ChestConfig selected = this.getSelectedChest();
            this.onSelectionChange.accept(selected);
        }
    }

    public ChestConfig getSelectedChest() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.chests.size()) {
            return this.chests.get(this.selectedIndex);
        }
        return null;
    }

    public void setSelectedIndex(int index) {
        if (index >= 0 && index < this.chests.size()) {
            this.selectedIndex = index;
            this.dropdown.setSelectedIndex(index);
            this.notifySelectionChange();
        }
    }

    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        ChestConfig selected = this.getSelectedChest();
        if (selected != null && selected.filterMode != ChestConfig.FilterMode.CUSTOM) {
            this.sortButton.method_25394(context, mouseX, mouseY, delta);
        }
        if (this.isRenaming) {
            this.renameField.method_25394(context, mouseX, mouseY, delta);
        } else {
            this.dropdown.method_25394(context, mouseX, mouseY, delta);
        }
        this.editButton.method_25394(context, mouseX, mouseY, delta);
    }

    public void renderDropdownIfOpen(class_332 context, int mouseX, int mouseY) {
        if (this.dropdown.isOpen()) {
            ChestConfig hoveredChest;
            int hoveredIndex;
            this.dropdown.renderDropdown(context, mouseX, mouseY);
            if (this.dropdown.isShiftDown() && (hoveredIndex = this.dropdown.getHoveredEntryIndex()) >= 0 && hoveredIndex < this.chests.size() && (hoveredChest = this.chests.get(hoveredIndex)) != null && !hoveredChest.previewItems.isEmpty()) {
                this.dropdown.renderItemPreviewTooltip(context, mouseX, mouseY, hoveredIndex - this.dropdown.getScrollOffset(), hoveredChest.previewItems);
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        class_11910 mouseInput = new class_11910(button, 0);
        class_11909 click = new class_11909(mouseX, mouseY, mouseInput);
        ChestConfig selected = this.getSelectedChest();
        if (selected != null && selected.filterMode != ChestConfig.FilterMode.CUSTOM && this.sortButton.method_25402(click, false)) {
            return true;
        }
        if (this.isRenaming) {
            if (this.renameField.method_25402(click, false)) {
                return true;
            }
            this.finishRenaming();
            return true;
        }
        if (this.editButton.method_25402(click, false)) {
            return true;
        }
        if (this.dropdown.mouseClicked(mouseX, mouseY, button)) {
            this.selectedIndex = this.dropdown.getSelectedIndex();
            this.notifySelectionChange();
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return this.dropdown.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.isRenaming) {
            class_11908 input = new class_11908(keyCode, scanCode, modifiers);
            if (keyCode == 257 || keyCode == 335) {
                this.finishRenaming();
                return true;
            }
            if (keyCode == 256) {
                this.renameField.method_1852("");
                this.finishRenaming();
                return true;
            }
            return this.renameField.method_25404(input);
        }
        class_11908 input = new class_11908(keyCode, scanCode, modifiers);
        return this.dropdown.method_25404(input);
    }

    public boolean charTyped(char chr, int modifiers) {
        if (this.isRenaming) {
            class_11905 input = new class_11905((int)chr, modifiers);
            return this.renameField.method_25400(input);
        }
        class_11905 input = new class_11905((int)chr, modifiers);
        return this.dropdown.method_25400(input);
    }

    public boolean isDropdownOpen() {
        return this.dropdown.isOpen();
    }

    public boolean isCurrentlyRenaming() {
        return this.isRenaming;
    }
}

