/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.blockentity;

import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2401;
import net.minecraft.class_243;
import net.minecraft.class_2457;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.shaddii.smartsorter.SmartSorter;
import net.shaddii.smartsorter.block.ProcessProbeBlock;
import net.shaddii.smartsorter.blockentity.StorageControllerBlockEntity;
import net.shaddii.smartsorter.blockentity.processor.ControllerFinder;
import net.shaddii.smartsorter.blockentity.processor.ExperienceCollector;
import net.shaddii.smartsorter.blockentity.processor.RecipeValidator;
import net.shaddii.smartsorter.blockentity.processor.SmeltingProcessor;
import net.shaddii.smartsorter.util.ControllerLinkable;
import net.shaddii.smartsorter.util.FuelFilterMode;
import net.shaddii.smartsorter.util.ProcessProbeConfig;
import net.shaddii.smartsorter.util.RecipeFilterMode;

public class ProcessProbeBlockEntity
extends class_2586
implements ControllerLinkable {
    private static final int TICK_INTERVAL = 10;
    private static final long CACHE_CLEAN_INTERVAL = 200L;
    private final RecipeValidator recipeValidator;
    private final SmeltingProcessor smeltingProcessor;
    private final ExperienceCollector experienceCollector;
    private class_2338 controllerPos;
    private class_2350 facing;
    private boolean enabled = false;
    private String machineType = "None";
    private class_2338 targetMachinePos;
    private boolean wasRedstonePowered = false;
    private boolean isLinked = false;
    private int tickCounter = 0;
    private boolean needsInitialLink = false;
    private ProcessProbeConfig config;
    private boolean hasBeenConfigured = false;

    public ProcessProbeBlockEntity(class_2338 pos, class_2680 state) {
        super(SmartSorter.PROCESS_PROBE_BE_TYPE, pos, state);
        try {
            this.facing = (class_2350)state.method_11654(ProcessProbeBlock.FACING);
        }
        catch (Exception e) {
            this.facing = class_2350.field_11043;
        }
        this.config = new ProcessProbeConfig(pos, "Unknown");
        this.experienceCollector = new ExperienceCollector();
        this.recipeValidator = new RecipeValidator();
        this.smeltingProcessor = new SmeltingProcessor(this.recipeValidator, this.experienceCollector);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, ProcessProbeBlockEntity be) {
        boolean powered;
        if (world == null || world.method_8608()) {
            return;
        }
        ++be.tickCounter;
        if (be.needsInitialLink) {
            powered = ProcessProbeBlockEntity.isReceivingRedstone(world, pos);
            if (powered) {
                be.attemptLink(world, state);
            }
            be.needsInitialLink = false;
            be.wasRedstonePowered = powered;
        }
        if (!be.checkControllerEnabled(world)) {
            return;
        }
        powered = ProcessProbeBlockEntity.isReceivingRedstone(world, pos);
        if (powered != be.wasRedstonePowered) {
            if (powered) {
                be.attemptLink(world, state);
            } else {
                be.disconnect(world);
            }
            be.wasRedstonePowered = powered;
        }
        be.setEnabled(powered);
        if (be.tickCounter >= 10) {
            be.tickCounter = 0;
            if (be.enabled && be.isLinked && world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                be.processTick(serverWorld);
            }
        }
        if ((long)be.tickCounter % 200L == 0L) {
            be.cleanCaches();
        }
    }

    private boolean checkControllerEnabled(class_1937 world) {
        if (this.controllerPos == null) {
            return true;
        }
        class_2586 controllerBE = world.method_8321(this.controllerPos);
        if (controllerBE instanceof StorageControllerBlockEntity) {
            StorageControllerBlockEntity controller = (StorageControllerBlockEntity)controllerBE;
            ProcessProbeConfig config = controller.getProbeConfig(this.field_11867);
            return config == null || config.enabled;
        }
        return true;
    }

    private void processTick(class_3218 world) {
        if (this.controllerPos == null) {
            return;
        }
        class_2586 controllerBE = world.method_8321(this.controllerPos);
        if (!(controllerBE instanceof StorageControllerBlockEntity)) {
            return;
        }
        StorageControllerBlockEntity controller = (StorageControllerBlockEntity)controllerBE;
        ProcessProbeConfig config = controller.getProbeConfig(this.field_11867);
        if (config == null || !config.enabled) {
            return;
        }
        try {
            class_2680 state = world.method_8320(this.field_11867);
            this.facing = (class_2350)state.method_11654(ProcessProbeBlock.FACING);
        }
        catch (Exception e) {
            this.facing = class_2350.field_11043;
        }
        class_2338 machinePos = this.field_11867.method_10093(this.facing);
        class_2586 blockEntity = world.method_8321(machinePos);
        if (blockEntity instanceof class_2609) {
            class_2609 smeltingMachine = (class_2609)blockEntity;
            this.smeltingProcessor.processSmeltingMachine(world, this.field_11867, smeltingMachine, controller, config);
            int processedCount = this.smeltingProcessor.getItemsProcessed();
            if (config.itemsProcessed != processedCount) {
                config.itemsProcessed = processedCount;
                controller.updateProbeConfig(config);
            }
        }
    }

    private void attemptLink(class_1937 world, class_2680 state) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        try {
            this.facing = (class_2350)state.method_11654(ProcessProbeBlock.FACING);
        }
        catch (Exception e) {
            this.facing = class_2350.field_11043;
        }
        class_2338 machinePos = this.field_11867.method_10093(this.facing);
        class_2586 machineEntity = world.method_8321(machinePos);
        class_2680 machineState = world.method_8320(machinePos);
        if (!this.isValidProcessingMachine(machineEntity, machineState)) {
            this.notifyPlayers(serverWorld, "No valid processing machine found", false);
            this.isLinked = false;
            return;
        }
        this.updateMachineType(machineState);
        this.targetMachinePos = machinePos;
        class_2338 foundController = ControllerFinder.findController(serverWorld, this.field_11867);
        if (foundController != null) {
            class_2586 be = world.method_8321(foundController);
            if (be instanceof StorageControllerBlockEntity) {
                StorageControllerBlockEntity controller = (StorageControllerBlockEntity)be;
                boolean success = controller.registerProcessProbe(this.field_11867, this.machineType);
                if (success) {
                    this.controllerPos = foundController;
                    this.isLinked = true;
                    this.method_5431();
                    String message = String.format("Linked to %s - Link Active", this.machineType);
                    this.notifyPlayers(serverWorld, message, true);
                } else {
                    this.isLinked = false;
                    this.notifyPlayers(serverWorld, "Controller rejected link", false);
                }
            }
        } else {
            this.isLinked = false;
            this.notifyPlayers(serverWorld, "No Storage Controller found in redstone network", false);
        }
    }

    private void disconnect(class_1937 world) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        if (this.isLinked && this.controllerPos != null) {
            class_2586 be = world.method_8321(this.controllerPos);
            if (be instanceof StorageControllerBlockEntity) {
                StorageControllerBlockEntity controller = (StorageControllerBlockEntity)be;
                controller.unregisterProcessProbe(this.field_11867);
            }
            this.isLinked = false;
            this.notifyPlayers(serverWorld, "Link Inactive", false);
        }
        this.enabled = false;
    }

    private static boolean isReceivingRedstone(class_1937 world, class_2338 pos) {
        if (world.method_49803(pos)) {
            return true;
        }
        for (class_2350 dir : class_2350.values()) {
            int power;
            class_2338 neighborPos = pos.method_10093(dir);
            class_2680 neighborState = world.method_8320(neighborPos);
            if (neighborState.method_27852(class_2246.field_10091) && (power = ((Integer)neighborState.method_11654((class_2769)class_2457.field_11432)).intValue()) > 0) {
                return true;
            }
            if (neighborState.method_27852(class_2246.field_10363) && ((Boolean)neighborState.method_11654((class_2769)class_2401.field_11265)).booleanValue()) {
                return true;
            }
            if (world.method_49808(neighborPos, dir.method_10153()) <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean isValidProcessingMachine(class_2586 entity, class_2680 state) {
        if (!(entity instanceof class_2609)) {
            return false;
        }
        return state.method_27852(class_2246.field_10181) || state.method_27852(class_2246.field_16333) || state.method_27852(class_2246.field_16334);
    }

    private void updateMachineType(class_2680 state) {
        this.machineType = state.method_27852(class_2246.field_10181) ? "Furnace" : (state.method_27852(class_2246.field_16333) ? "Blast Furnace" : (state.method_27852(class_2246.field_16334) ? "Smoker" : "Unknown"));
        if (this.config != null) {
            this.config.machineType = this.machineType;
        }
    }

    private void notifyPlayers(class_3218 world, String message, boolean success) {
        class_5250 text = class_2561.method_43470((String)message).method_27692(success ? class_124.field_1060 : class_124.field_1054);
        for (class_3222 player : world.method_18456()) {
            if (!(player.method_5707(class_243.method_24953((class_2382)this.field_11867)) < 256.0)) continue;
            player.method_7353((class_2561)text, true);
        }
    }

    private void cleanCaches() {
        this.recipeValidator.cleanCache();
    }

    @Override
    public void setController(class_2338 controllerPos) {
        this.controllerPos = controllerPos;
        this.method_5431();
    }

    @Override
    public class_2338 getController() {
        return this.controllerPos;
    }

    public ProcessProbeConfig getConfig() {
        if (this.config == null) {
            this.config = new ProcessProbeConfig(this.field_11867, this.machineType);
        }
        this.config.position = this.field_11867;
        this.config.machineType = this.machineType;
        this.config.itemsProcessed = this.smeltingProcessor.getItemsProcessed();
        return this.config;
    }

    public void setConfig(ProcessProbeConfig newConfig) {
        this.config = newConfig.copy();
        this.config.position = this.field_11867;
        this.smeltingProcessor.setItemsProcessed(newConfig.itemsProcessed);
        this.hasBeenConfigured = true;
        this.method_5431();
    }

    public boolean addLinkedBlock(class_2338 controllerPos) {
        if (this.controllerPos == null || !this.controllerPos.equals((Object)controllerPos)) {
            this.setController(controllerPos);
            return true;
        }
        return false;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            this.method_5431();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getProcessedCount() {
        return this.smeltingProcessor.getItemsProcessed();
    }

    public String getMachineType() {
        return this.machineType;
    }

    public String getStatusText() {
        if (!this.enabled) {
            return "\u00a7cDisabled";
        }
        if (!this.isLinked) {
            return "\u00a7eNot Linked";
        }
        if (this.targetMachinePos == null) {
            return "\u00a7eNo Machine Found";
        }
        return "\u00a7aActive";
    }

    public void collectExperience(class_1657 player) {
        player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7eExperience is stored in the controller!"), true);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        if (this.controllerPos != null) {
            nbt.method_10544("ControllerPos", this.controllerPos.method_10063());
        }
        if (this.targetMachinePos != null) {
            nbt.method_10544("TargetMachine", this.targetMachinePos.method_10063());
        }
        nbt.method_10556("Enabled", this.enabled);
        nbt.method_10569("Processed", this.smeltingProcessor.getItemsProcessed());
        nbt.method_10582("MachineType", this.machineType);
        nbt.method_10556("WasRedstonePowered", this.wasRedstonePowered);
        nbt.method_10556("IsLinked", this.isLinked);
        nbt.method_10556("HasBeenConfigured", this.hasBeenConfigured);
        if (this.isLinked && this.controllerPos != null) {
            this.needsInitialLink = true;
            this.isLinked = false;
        }
        if (this.config != null && this.hasBeenConfigured) {
            if (this.config.customName != null) {
                nbt.method_10582("Config_CustomName", this.config.customName);
            }
            nbt.method_10556("Config_Enabled", this.config.enabled);
            nbt.method_10582("Config_RecipeFilter", this.config.recipeFilter.asString());
            nbt.method_10582("Config_FuelFilter", this.config.fuelFilter.asString());
            nbt.method_10569("Config_ItemsProcessed", this.config.itemsProcessed);
            nbt.method_10569("Config_Index", this.config.index);
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        if (nbt.method_10545("ControllerPos")) {
            this.controllerPos = class_2338.method_10092((long)nbt.method_10537("ControllerPos"));
        }
        if (nbt.method_10545("TargetMachine")) {
            this.targetMachinePos = class_2338.method_10092((long)nbt.method_10537("TargetMachine"));
        }
        this.enabled = nbt.method_10577("Enabled");
        this.smeltingProcessor.setItemsProcessed(nbt.method_10550("Processed"));
        this.machineType = nbt.method_10545("MachineType") ? nbt.method_10558("MachineType") : "None";
        this.wasRedstonePowered = nbt.method_10577("WasRedstonePowered");
        this.isLinked = nbt.method_10577("IsLinked");
        this.hasBeenConfigured = nbt.method_10577("HasBeenConfigured");
        if (this.hasBeenConfigured) {
            this.config = new ProcessProbeConfig(this.field_11867, this.machineType);
            this.config.customName = nbt.method_10545("Config_CustomName") ? nbt.method_10558("Config_CustomName") : null;
            this.config.enabled = nbt.method_10545("Config_Enabled") ? nbt.method_10577("Config_Enabled") : true;
            this.config.recipeFilter = RecipeFilterMode.fromString(nbt.method_10545("Config_RecipeFilter") ? nbt.method_10558("Config_RecipeFilter") : "ORES_ONLY");
            this.config.fuelFilter = FuelFilterMode.fromString(nbt.method_10545("Config_FuelFilter") ? nbt.method_10558("Config_FuelFilter") : "COAL_ONLY");
            this.config.itemsProcessed = nbt.method_10545("Config_ItemsProcessed") ? nbt.method_10550("Config_ItemsProcessed") : this.smeltingProcessor.getItemsProcessed();
            this.config.index = nbt.method_10545("Config_Index") ? nbt.method_10550("Config_Index") : 0;
        } else {
            this.config = new ProcessProbeConfig(this.field_11867, this.machineType);
        }
    }

    public void onRemoved() {
        class_2586 be;
        if (this.field_11863 != null && !this.field_11863.method_8608() && this.controllerPos != null && (be = this.field_11863.method_8321(this.controllerPos)) instanceof StorageControllerBlockEntity) {
            StorageControllerBlockEntity controller = (StorageControllerBlockEntity)be;
            ProcessProbeConfig controllerConfig = controller.getProbeConfig(this.field_11867);
            if (controllerConfig != null) {
                this.config = controllerConfig.copy();
                this.hasBeenConfigured = true;
                this.method_5431();
            }
            controller.unregisterProcessProbe(this.field_11867);
        }
        this.controllerPos = null;
        this.targetMachinePos = null;
        this.recipeValidator.clearCache();
        this.experienceCollector.clearCache();
    }

    public void clearController() {
        StorageControllerBlockEntity controller;
        ProcessProbeConfig controllerConfig;
        class_2586 be;
        if (this.field_11863 != null && this.controllerPos != null && (be = this.field_11863.method_8321(this.controllerPos)) instanceof StorageControllerBlockEntity && (controllerConfig = (controller = (StorageControllerBlockEntity)be).getProbeConfig(this.field_11867)) != null) {
            this.config = controllerConfig.copy();
            this.hasBeenConfigured = true;
        }
        this.controllerPos = null;
        this.isLinked = false;
        this.method_5431();
        if (this.field_11863 != null) {
            class_2680 state = this.field_11863.method_8320(this.field_11867);
            this.field_11863.method_8413(this.field_11867, state, state, 3);
        }
    }

    public boolean hasBeenConfigured() {
        return this.hasBeenConfigured;
    }
}

