/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.blockentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_7225;
import net.shaddii.smartsorter.SmartSorter;
import net.shaddii.smartsorter.blockentity.IntakeBlockEntity;
import net.shaddii.smartsorter.blockentity.OutputProbeBlockEntity;
import net.shaddii.smartsorter.blockentity.controller.ChestConfigManager;
import net.shaddii.smartsorter.blockentity.controller.ChestSortingService;
import net.shaddii.smartsorter.blockentity.controller.ItemRoutingService;
import net.shaddii.smartsorter.blockentity.controller.NetworkInventoryManager;
import net.shaddii.smartsorter.blockentity.controller.ProbeRegistry;
import net.shaddii.smartsorter.blockentity.controller.ProcessProbeManager;
import net.shaddii.smartsorter.screen.StorageControllerScreenHandler;
import net.shaddii.smartsorter.util.ChestConfig;
import net.shaddii.smartsorter.util.ProcessProbeConfig;
import org.jetbrains.annotations.Nullable;

public class StorageControllerBlockEntity
extends class_2586
implements class_3908,
class_1263 {
    private static final long CACHE_DURATION = 40L;
    private static final long SYNC_COOLDOWN = 5L;
    private static final long VALIDATION_INTERVAL = 200L;
    private final NetworkInventoryManager networkManager;
    private final ProbeRegistry probeRegistry;
    private final ItemRoutingService routingService;
    private final ChestSortingService sortingService;
    private final ProcessProbeManager processProbeManager;
    private final ChestConfigManager chestConfigManager;
    private final List<class_2338> linkedIntakes = new ArrayList<class_2338>();
    private long lastCacheUpdate = 0L;
    private long lastSyncTime = 0L;
    private boolean networkDirty = true;
    private int storedExperience = 0;

    public StorageControllerBlockEntity(class_2338 pos, class_2680 state) {
        super(SmartSorter.STORAGE_CONTROLLER_BE_TYPE, pos, state);
        this.networkManager = new NetworkInventoryManager();
        this.probeRegistry = new ProbeRegistry();
        this.routingService = new ItemRoutingService(this.probeRegistry);
        this.sortingService = new ChestSortingService(this.routingService, this.probeRegistry, this.networkManager);
        this.processProbeManager = new ProcessProbeManager();
        this.chestConfigManager = new ChestConfigManager(this.probeRegistry);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, StorageControllerBlockEntity be) {
        if (world.method_8608()) {
            return;
        }
        long currentTime = world.method_8510();
        if (currentTime % 200L == 0L) {
            be.validateLinks();
        }
        if (be.networkDirty && currentTime - be.lastCacheUpdate >= 40L) {
            be.updateNetworkCache();
            be.lastCacheUpdate = currentTime;
            be.syncToViewers();
            be.networkDirty = false;
        }
    }

    private void validateLinks() {
        this.probeRegistry.validate(this.field_11863);
        this.linkedIntakes.removeIf(intakePos -> {
            class_2586 be = this.field_11863.method_8321(intakePos);
            return !(be instanceof IntakeBlockEntity);
        });
    }

    public void updateNetworkCache() {
        if (this.field_11863 == null) {
            return;
        }
        this.networkManager.updateCache(this.field_11863, this.probeRegistry.getLinkedProbes());
    }

    private void syncToViewers() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        long currentTime = this.field_11863.method_8510();
        if (currentTime - this.lastSyncTime < 5L) {
            return;
        }
        this.lastSyncTime = currentTime;
        if (!this.networkManager.hasDeltas()) {
            return;
        }
        Map<ItemVariant, Long> deltas = this.networkManager.consumeDeltas();
        for (class_3222 player : serverWorld.method_18456()) {
            class_1703 class_17032 = player.field_7512;
            if (!(class_17032 instanceof StorageControllerScreenHandler)) continue;
            StorageControllerScreenHandler handler = (StorageControllerScreenHandler)class_17032;
            if (handler.controller != this) continue;
            handler.sendNetworkUpdate(player, deltas);
        }
    }

    public Map<ItemVariant, Long> getNetworkItems() {
        return this.networkManager.getNetworkItems();
    }

    public void onProbeInventoryChanged(OutputProbeBlockEntity probe) {
        this.networkDirty = true;
    }

    public boolean addProbe(class_2338 probePos) {
        boolean added = this.probeRegistry.addProbe(probePos);
        if (added) {
            this.networkDirty = true;
            this.method_5431();
            if (this.field_11863 != null) {
                OutputProbeBlockEntity probe;
                class_2338 targetPos;
                class_2586 be = this.field_11863.method_8321(probePos);
                if (be instanceof OutputProbeBlockEntity && (targetPos = (probe = (OutputProbeBlockEntity)be).getTargetPos()) != null) {
                    this.chestConfigManager.onChestDetected(this.field_11863, targetPos, probe);
                }
                this.updateListeners();
            }
        }
        return added;
    }

    public boolean removeProbe(class_2338 probePos) {
        boolean removed = this.probeRegistry.removeProbe(probePos);
        if (removed) {
            this.networkDirty = true;
            this.method_5431();
            if (this.field_11863 != null) {
                OutputProbeBlockEntity probe;
                class_2338 targetPos;
                class_2586 be = this.field_11863.method_8321(probePos);
                if (be instanceof OutputProbeBlockEntity && (targetPos = (probe = (OutputProbeBlockEntity)be).getTargetPos()) != null) {
                    this.chestConfigManager.onChestRemoved(this.field_11863, targetPos, this.probeRegistry.getLinkedProbes());
                }
                this.updateListeners();
            }
        }
        return removed;
    }

    public List<class_2338> getLinkedProbes() {
        return this.probeRegistry.getLinkedProbes();
    }

    public int getLinkedInventoryCount() {
        return this.probeRegistry.getProbeCount();
    }

    public boolean addIntake(class_2338 intakePos) {
        if (this.linkedIntakes.contains(intakePos)) {
            return false;
        }
        this.linkedIntakes.add(intakePos);
        this.method_5431();
        this.updateListeners();
        return true;
    }

    public boolean removeIntake(class_2338 intakePos) {
        boolean removed = this.linkedIntakes.remove(intakePos);
        if (removed) {
            this.method_5431();
            this.updateListeners();
        }
        return removed;
    }

    public List<class_2338> getLinkedIntakes() {
        return new ArrayList<class_2338>(this.linkedIntakes);
    }

    public ItemRoutingService.InsertionResult insertItem(class_1799 stack) {
        ItemRoutingService.InsertionResult result = this.routingService.insertItem(this.field_11863, stack);
        if (!result.remainder().method_7960() || result.remainder().method_7947() != stack.method_7947()) {
            this.networkDirty = true;
        }
        return result;
    }

    public class_1799 extractItem(ItemVariant variant, int amount) {
        class_1799 result = this.routingService.extractItem(this.field_11863, variant, amount, this.networkManager);
        if (!result.method_7960()) {
            this.networkDirty = true;
        }
        return result;
    }

    public boolean canInsertItem(ItemVariant variant, int amount) {
        OutputProbeBlockEntity probe;
        class_2586 be;
        List<class_2338> probesWithItem = this.networkManager.getProbesWithItem(variant);
        for (class_2338 probePos : probesWithItem) {
            be = this.field_11863.method_8321(probePos);
            if (!(be instanceof OutputProbeBlockEntity) || !(probe = (OutputProbeBlockEntity)be).hasSpace(variant, amount)) continue;
            return true;
        }
        for (class_2338 probePos : this.probeRegistry.getLinkedProbes()) {
            class_1263 inv;
            be = this.field_11863.method_8321(probePos);
            if (!(be instanceof OutputProbeBlockEntity) || !(probe = (OutputProbeBlockEntity)be).accepts(variant) || (inv = probe.getTargetInventory()) == null) continue;
            for (int i = 0; i < inv.method_5439(); ++i) {
                if (!inv.method_5438(i).method_7960()) continue;
                return true;
            }
        }
        return false;
    }

    public Map<class_2338, ChestConfig> getChestConfigs() {
        return this.chestConfigManager.getChestConfigs(this.field_11863, this.probeRegistry.getLinkedProbes());
    }

    public ChestConfig getChestConfig(class_2338 position) {
        return this.chestConfigManager.getChestConfig(position);
    }

    public void updateChestConfig(class_2338 position, ChestConfig config) {
        this.chestConfigManager.updateChestConfig(this.field_11863, position, config, this);
        this.probeRegistry.invalidateCache();
        this.networkDirty = true;
        this.method_5431();
        this.updateListeners();
    }

    public void removeChestConfig(class_2338 chestPos) {
        this.chestConfigManager.removeChestConfig(this.field_11863, chestPos, this);
        this.probeRegistry.invalidateCache();
        this.networkDirty = true;
        this.method_5431();
    }

    public boolean isChestLinked(class_2338 chestPos) {
        return this.chestConfigManager.isChestLinked(this.field_11863, chestPos, this.probeRegistry.getLinkedProbes());
    }

    public void sortChestsInOrder(List<class_2338> positions, @Nullable class_3222 player) {
        this.updateNetworkCache();
        this.sortingService.sortChests(this.field_11863, positions, player);
        this.method_5431();
        this.updateNetworkCache();
    }

    public boolean registerProcessProbe(class_2338 pos, String machineType) {
        boolean result = this.processProbeManager.registerProbe(this.field_11863, pos, machineType);
        if (result) {
            this.method_5431();
            this.networkDirty = true;
        }
        return result;
    }

    public void unregisterProcessProbe(class_2338 pos) {
        this.processProbeManager.unregisterProbe(this.field_11863, pos);
        this.method_5431();
        this.networkDirty = true;
    }

    public void updateProbeConfig(ProcessProbeConfig config) {
        this.processProbeManager.updateConfig(this.field_11863, config, this);
        this.method_5431();
        this.networkDirty = true;
    }

    public Map<class_2338, ProcessProbeConfig> getProcessProbeConfigs() {
        return this.processProbeManager.getConfigs();
    }

    public ProcessProbeConfig getProbeConfig(class_2338 pos) {
        return this.processProbeManager.getConfig(pos);
    }

    public void syncProbeStatsToClients(class_2338 probePos, int itemsProcessed) {
        this.processProbeManager.syncStatsToClients(this.field_11863, probePos, itemsProcessed, this);
    }

    public void addExperience(int amount) {
        this.storedExperience += amount;
        this.method_5431();
    }

    public int getStoredExperience() {
        return this.storedExperience;
    }

    public int collectExperience() {
        int xp = this.storedExperience;
        this.storedExperience = 0;
        this.method_5431();
        return xp;
    }

    public int calculateTotalFreeSlots() {
        if (this.field_11863 == null) {
            return 0;
        }
        int totalFree = 0;
        for (class_2338 probePos : this.probeRegistry.getLinkedProbes()) {
            OutputProbeBlockEntity probe;
            class_1263 inv;
            class_2586 be = this.field_11863.method_8321(probePos);
            if (!(be instanceof OutputProbeBlockEntity) || (inv = (probe = (OutputProbeBlockEntity)be).getTargetInventory()) == null) continue;
            for (int i = 0; i < inv.method_5439(); ++i) {
                if (!inv.method_5438(i).method_7960()) continue;
                ++totalFree;
            }
        }
        return totalFree;
    }

    public int calculateTotalCapacity() {
        if (this.field_11863 == null) {
            return 0;
        }
        int totalSlots = 0;
        for (class_2338 probePos : this.probeRegistry.getLinkedProbes()) {
            OutputProbeBlockEntity probe;
            class_1263 inv;
            class_2586 be = this.field_11863.method_8321(probePos);
            if (!(be instanceof OutputProbeBlockEntity) || (inv = (probe = (OutputProbeBlockEntity)be).getTargetInventory()) == null) continue;
            totalSlots += inv.method_5439();
        }
        return totalSlots;
    }

    public int calculateChestFullness(class_2338 chestPos) {
        return this.chestConfigManager.calculateChestFullness(this.field_11863, chestPos, this.probeRegistry.getLinkedProbes());
    }

    public void sortChestIntoNetwork(class_2338 chestPos, Map<ItemVariant, Long> overflowCounts, Map<ItemVariant, String> overflowDestinations) {
        this.sortingService.sortChest(this.field_11863, chestPos, overflowCounts, overflowDestinations);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_2499 probeList = new class_2499();
        for (class_2338 probe : this.probeRegistry.getLinkedProbes()) {
            probeList.add((Object)class_2503.method_23251((long)probe.method_10063()));
        }
        nbt.method_10566("Probes", (class_2520)probeList);
        class_2499 intakeList = new class_2499();
        for (class_2338 intake : this.linkedIntakes) {
            intakeList.add((Object)class_2503.method_23251((long)intake.method_10063()));
        }
        nbt.method_10566("Intakes", (class_2520)intakeList);
        nbt.method_10566("ProcessProbes", (class_2520)this.processProbeManager.writeToNbt());
        nbt.method_10566("ChestConfigs", (class_2520)this.chestConfigManager.writeToNbt());
        nbt.method_10569("StoredXP", this.storedExperience);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        int i;
        super.method_11014(nbt, registryLookup);
        if (nbt.method_10573("Probes", 9)) {
            class_2499 probeList = nbt.method_10554("Probes", 4);
            for (i = 0; i < probeList.size(); ++i) {
                this.probeRegistry.addProbe(class_2338.method_10092((long)((class_2503)probeList.method_10534(i)).method_10699()));
            }
        }
        this.linkedIntakes.clear();
        if (nbt.method_10573("Intakes", 9)) {
            class_2499 intakeList = nbt.method_10554("Intakes", 4);
            for (i = 0; i < intakeList.size(); ++i) {
                this.linkedIntakes.add(class_2338.method_10092((long)((class_2503)intakeList.method_10534(i)).method_10699()));
            }
        }
        if (nbt.method_10573("ProcessProbes", 9)) {
            this.processProbeManager.readFromNbt(nbt.method_10554("ProcessProbes", 10));
        }
        if (nbt.method_10573("ChestConfigs", 9)) {
            this.chestConfigManager.readFromNbt(nbt.method_10554("ChestConfigs", 10));
        }
        this.storedExperience = nbt.method_10550("StoredXP");
    }

    public int method_5439() {
        return 0;
    }

    public boolean method_5442() {
        return true;
    }

    public class_1799 method_5438(int slot) {
        return class_1799.field_8037;
    }

    public class_1799 method_5434(int slot, int amount) {
        return class_1799.field_8037;
    }

    public class_1799 method_5441(int slot) {
        return class_1799.field_8037;
    }

    public void method_5447(int slot, class_1799 stack) {
    }

    public void method_5448() {
    }

    public boolean method_5443(class_1657 player) {
        return this.field_11867.method_19771((class_2382)player.method_24515(), 8.0);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.smartsorter.storage_controller");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new StorageControllerScreenHandler(syncId, playerInventory, this);
    }

    public void onRemoved() {
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            if (this.storedExperience > 0) {
                class_1303.method_31493((class_3218)((class_3218)this.field_11863), (class_243)class_243.method_24953((class_2382)this.field_11867), (int)this.storedExperience);
                for (class_3222 player : ((class_3218)this.field_11863).method_18456()) {
                    double distance = player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5);
                    if (!(distance < 256.0)) continue;
                    player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7a[Smart Sorter] \u00a7e" + this.storedExperience + " XP dropped from controller!")).method_27692(class_124.field_1054), false);
                }
                this.storedExperience = 0;
            }
            for (class_2338 probePos : this.probeRegistry.getLinkedProbes()) {
                class_2586 be = this.field_11863.method_8321(probePos);
                if (!(be instanceof OutputProbeBlockEntity)) continue;
                OutputProbeBlockEntity probe = (OutputProbeBlockEntity)be;
                probe.removeController(this.field_11867);
            }
            for (class_2338 intakePos : this.linkedIntakes) {
                class_2586 be = this.field_11863.method_8321(intakePos);
                if (!(be instanceof IntakeBlockEntity)) continue;
                IntakeBlockEntity intake = (IntakeBlockEntity)be;
                intake.clearController();
            }
            this.processProbeManager.unlinkAll(this.field_11863);
            this.chestConfigManager.clearAllChestNames(this.field_11863);
        }
    }

    private void updateListeners() {
        if (this.field_11863 != null) {
            class_2680 state = this.field_11863.method_8320(this.field_11867);
            this.field_11863.method_8413(this.field_11867, state, state, 3);
        }
    }
}

