/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.blockentity.controller;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.shaddii.smartsorter.blockentity.OutputProbeBlockEntity;
import net.shaddii.smartsorter.util.ChestConfig;

public class ProbeRegistry {
    private final List<class_2338> linkedProbes = new ArrayList<class_2338>();
    private List<class_2338> sortedProbesCache;
    private boolean sortCacheDirty = true;

    public boolean addProbe(class_2338 probePos) {
        if (this.linkedProbes.contains(probePos)) {
            return false;
        }
        this.linkedProbes.add(probePos);
        this.invalidateCache();
        return true;
    }

    public boolean removeProbe(class_2338 probePos) {
        boolean removed = this.linkedProbes.remove(probePos);
        if (removed) {
            this.invalidateCache();
        }
        return removed;
    }

    public List<class_2338> getSortedProbes(class_1937 world) {
        if (!this.sortCacheDirty && this.sortedProbesCache != null) {
            return this.sortedProbesCache;
        }
        ArrayList<ProbeEntry> entries = new ArrayList<ProbeEntry>(this.linkedProbes.size());
        for (class_2338 probePos : this.linkedProbes) {
            class_2586 be = world.method_8321(probePos);
            if (!(be instanceof OutputProbeBlockEntity)) continue;
            OutputProbeBlockEntity probe = (OutputProbeBlockEntity)be;
            class_2338 chestPos = probe.getTargetPos();
            ChestConfig config = chestPos != null ? probe.getChestConfig() : null;
            entries.add(new ProbeEntry(probePos, probe.mode, config, this.hasItemsInChest(world, probePos, probe)));
        }
        entries.sort((a, b) -> {
            int bPri;
            int aPri = a.config != null ? a.config.hiddenPriority : 0;
            int n = bPri = b.config != null ? b.config.hiddenPriority : 0;
            if (aPri != bPri) {
                return Integer.compare(bPri, aPri);
            }
            if (a.hasItems != b.hasItems) {
                return a.hasItems ? -1 : 1;
            }
            return Integer.compare(this.getModeOrder(a.mode), this.getModeOrder(b.mode));
        });
        this.sortedProbesCache = new ArrayList<class_2338>(entries.size());
        for (ProbeEntry entry : entries) {
            this.sortedProbesCache.add(entry.pos);
        }
        this.sortCacheDirty = false;
        return this.sortedProbesCache;
    }

    public List<class_2338> getLinkedProbes() {
        return new ArrayList<class_2338>(this.linkedProbes);
    }

    public int getProbeCount() {
        return this.linkedProbes.size();
    }

    public void invalidateCache() {
        this.sortCacheDirty = true;
    }

    public void validate(class_1937 world) {
        this.linkedProbes.removeIf(probePos -> {
            class_2586 be = world.method_8321(probePos);
            return !(be instanceof OutputProbeBlockEntity);
        });
    }

    private boolean hasItemsInChest(class_1937 world, class_2338 probePos, OutputProbeBlockEntity probe) {
        class_1263 inv = probe.getTargetInventory();
        if (inv == null) {
            return false;
        }
        for (int i = 0; i < inv.method_5439(); ++i) {
            if (inv.method_5438(i).method_7960()) continue;
            return true;
        }
        return false;
    }

    private int getModeOrder(OutputProbeBlockEntity.ProbeMode mode) {
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case OutputProbeBlockEntity.ProbeMode.FILTER -> 0;
            case OutputProbeBlockEntity.ProbeMode.PRIORITY -> 1;
            case OutputProbeBlockEntity.ProbeMode.ACCEPT_ALL -> 2;
        };
    }

    private record ProbeEntry(class_2338 pos, OutputProbeBlockEntity.ProbeMode mode, ChestConfig config, boolean hasItems) {
    }
}

