/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.blockentity.controller;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.shaddii.smartsorter.blockentity.ProcessProbeBlockEntity;
import net.shaddii.smartsorter.blockentity.StorageControllerBlockEntity;
import net.shaddii.smartsorter.network.ProbeStatsSyncPayload;
import net.shaddii.smartsorter.screen.StorageControllerScreenHandler;
import net.shaddii.smartsorter.util.ProcessProbeConfig;

public class ProcessProbeManager {
    private final Map<class_2338, ProcessProbeConfig> linkedProcessProbes = new LinkedHashMap<class_2338, ProcessProbeConfig>();

    public boolean registerProbe(class_1937 world, class_2338 pos, String machineType) {
        if (world == null) {
            return false;
        }
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof ProcessProbeBlockEntity)) {
            return false;
        }
        ProcessProbeBlockEntity probe = (ProcessProbeBlockEntity)be;
        ProcessProbeConfig config = probe.getConfig().copy();
        config.machineType = machineType;
        config.position = pos;
        if (!this.linkedProcessProbes.containsKey(pos)) {
            int index = this.getNextIndexForMachineType(machineType);
            config.setIndex(index);
        } else {
            ProcessProbeConfig existingConfig = this.linkedProcessProbes.get(pos);
            if (existingConfig != null) {
                config.setIndex(existingConfig.index);
            }
        }
        this.linkedProcessProbes.put(pos, config);
        probe.setConfig(config);
        return true;
    }

    public void unregisterProbe(class_1937 world, class_2338 pos) {
        ProcessProbeConfig config = this.linkedProcessProbes.get(pos);
        if (config != null) {
            class_2586 be;
            if (world != null && (be = world.method_8321(pos)) instanceof ProcessProbeBlockEntity) {
                ProcessProbeBlockEntity probe = (ProcessProbeBlockEntity)be;
                probe.setConfig(config.copy());
            }
            this.linkedProcessProbes.remove(pos);
        }
    }

    public void updateConfig(class_1937 world, ProcessProbeConfig config, StorageControllerBlockEntity controller) {
        class_2586 be;
        if (!this.linkedProcessProbes.containsKey(config.position)) {
            return;
        }
        ProcessProbeConfig existing = this.linkedProcessProbes.get(config.position);
        if (existing != null && existing.isFunctionallyEqual(config)) {
            if (existing.itemsProcessed != config.itemsProcessed) {
                existing.itemsProcessed = config.itemsProcessed;
                this.syncStatsToClients(world, config.position, config.itemsProcessed, controller);
            }
            return;
        }
        this.linkedProcessProbes.put(config.position, config.copy());
        if (world != null && (be = world.method_8321(config.position)) instanceof ProcessProbeBlockEntity) {
            ProcessProbeBlockEntity probe = (ProcessProbeBlockEntity)be;
            probe.setConfig(config.copy());
            this.syncStatsToClients(world, config.position, config.itemsProcessed, controller);
        }
    }

    public Map<class_2338, ProcessProbeConfig> getConfigs() {
        return new LinkedHashMap<class_2338, ProcessProbeConfig>(this.linkedProcessProbes);
    }

    public ProcessProbeConfig getConfig(class_2338 pos) {
        return this.linkedProcessProbes.get(pos);
    }

    public void syncStatsToClients(class_1937 world, class_2338 probePos, int itemsProcessed, StorageControllerBlockEntity controller) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            for (class_3222 player : serverWorld.method_18456()) {
                class_1703 class_17032 = player.field_7512;
                if (!(class_17032 instanceof StorageControllerScreenHandler)) continue;
                StorageControllerScreenHandler handler = (StorageControllerScreenHandler)class_17032;
                if (handler.controller != controller) continue;
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ProbeStatsSyncPayload(probePos, itemsProcessed));
            }
        }
    }

    public void unlinkAll(class_1937 world) {
        for (class_2338 pos : new ArrayList<class_2338>(this.linkedProcessProbes.keySet())) {
            class_2586 be = world.method_8321(pos);
            if (!(be instanceof ProcessProbeBlockEntity)) continue;
            ProcessProbeBlockEntity probe = (ProcessProbeBlockEntity)be;
            probe.clearController();
        }
        this.linkedProcessProbes.clear();
    }

    public class_2499 writeToNbt() {
        class_2499 list = new class_2499();
        for (ProcessProbeConfig config : this.linkedProcessProbes.values()) {
            list.add((Object)config.toNbt());
        }
        return list;
    }

    public void readFromNbt(class_2499 list) {
        this.linkedProcessProbes.clear();
        for (int i = 0; i < list.size(); ++i) {
            class_2487 nbt = list.method_10602(i);
            ProcessProbeConfig config = ProcessProbeConfig.fromNbt(nbt);
            if (config == null || config.position == null) continue;
            this.linkedProcessProbes.put(config.position, config);
        }
    }

    private int getNextIndexForMachineType(String machineType) {
        HashSet<Integer> usedIndices = new HashSet<Integer>();
        for (ProcessProbeConfig config : this.linkedProcessProbes.values()) {
            if (!config.machineType.equals(machineType)) continue;
            usedIndices.add(config.index);
        }
        int index = 0;
        while (usedIndices.contains(index)) {
            ++index;
        }
        return index;
    }
}

