/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.screen.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1799;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class ItemGridRenderer {
    private static final String[] AMOUNT_CACHE = new String[1000];
    private final class_327 textRenderer;
    private final Map<Long, String> formattedAmountCache = new HashMap<Long, String>();
    private int framesSinceLastCacheClear = 0;

    public ItemGridRenderer(class_327 textRenderer) {
        this.textRenderer = textRenderer;
    }

    public void renderItems(class_332 context, List<Map.Entry<ItemVariant, Long>> items, int startIndex, int endIndex, int gridX, int gridY, int itemsPerRow, int slotSize, int mouseX, int mouseY) {
        for (int i = startIndex; i < endIndex; ++i) {
            int relativeIndex = i - startIndex;
            int row = relativeIndex / itemsPerRow;
            int col = relativeIndex % itemsPerRow;
            int slotX = gridX + col * slotSize;
            int slotY = gridY + row * slotSize;
            Map.Entry<ItemVariant, Long> entry = items.get(i);
            ItemVariant variant = entry.getKey();
            long amount = entry.getValue();
            context.method_25294(slotX, slotY, slotX + 16, slotY + 16, -1953789045);
            class_1799 stack = variant.toStack();
            context.method_51427(stack, slotX, slotY);
            if (amount > 1L) {
                String amountText = this.formattedAmountCache.computeIfAbsent(amount, this::formatAmount);
                float scale = 0.75f;
                int rawWidth = this.textRenderer.method_1727(amountText);
                float scaledWidth = (float)rawWidth * scale;
                float textX = (float)(slotX + 16) - scaledWidth;
                float textY = slotY + 9;
                this.renderScaledText(context, amountText, textX, textY, scale, -1);
            }
            if (!this.isMouseOverSlot(slotX, slotY, mouseX, mouseY)) continue;
            context.method_25294(slotX, slotY, slotX + 16, slotY + 16, -2130706433);
        }
        ++this.framesSinceLastCacheClear;
        if (this.framesSinceLastCacheClear > 600) {
            this.clearCacheIfNeeded();
            this.framesSinceLastCacheClear = 0;
        }
    }

    public void renderScrollbar(class_332 context, int x, int y, int width, int height, float scrollProgress, boolean enabled) {
        context.method_25294(x, y, x + width, y + height, -3750202);
        context.method_25294(x, y, x + 1, y + height, -13158601);
        context.method_25294(x + width - 1, y, x + width, y + height, -1);
        if (enabled) {
            int handleHeight = 15;
            int maxHandleOffset = height - handleHeight;
            int handleY = y + (int)(scrollProgress * (float)maxHandleOffset);
            context.method_25294(x + 1, handleY, x + width - 1, handleY + handleHeight, -7631989);
            context.method_25294(x + 1, handleY, x + width - 1, handleY + 1, -1);
        }
    }

    private void renderScaledText(class_332 context, String text, float x, float y, float scale, int color) {
        context.method_51448().method_22903();
        context.method_51448().method_46416(x, y, 200.0f);
        context.method_51448().method_22905(scale, scale, scale);
        context.method_51433(this.textRenderer, text, 0, 0, color, true);
        context.method_51448().method_22909();
    }

    private String formatAmount(long amount) {
        if (amount < 1000L) {
            return amount < (long)AMOUNT_CACHE.length ? AMOUNT_CACHE[(int)amount] : String.valueOf(amount);
        }
        if (amount >= 1000000000L) {
            if (amount >= 10000000000L) {
                return amount / 1000000000L + "B";
            }
            long billions = amount / 1000000000L;
            long remainder = amount % 1000000000L / 100000000L;
            return remainder > 0L ? billions + "." + remainder + "B" : billions + "B";
        }
        if (amount >= 1000000L) {
            if (amount >= 10000000L) {
                return amount / 1000000L + "M";
            }
            long millions = amount / 1000000L;
            long remainder = amount % 1000000L / 100000L;
            return remainder > 0L ? millions + "." + remainder + "M" : millions + "M";
        }
        if (amount >= 10000L) {
            return amount / 1000L + "k";
        }
        long thousands = amount / 1000L;
        long remainder = amount % 1000L / 100L;
        return remainder > 0L ? thousands + "." + remainder + "k" : thousands + "k";
    }

    private void clearCacheIfNeeded() {
        if (this.formattedAmountCache.size() > 500) {
            this.formattedAmountCache.clear();
        }
    }

    private boolean isMouseOverSlot(int slotX, int slotY, double mouseX, double mouseY) {
        return mouseX >= (double)slotX && mouseX < (double)(slotX + 16) && mouseY >= (double)slotY && mouseY < (double)(slotY + 16);
    }

    static {
        for (int i = 0; i < 1000; ++i) {
            ItemGridRenderer.AMOUNT_CACHE[i] = String.valueOf(i);
        }
    }
}

