/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.screen.tabs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_8710;
import net.shaddii.smartsorter.network.SortChestsPayload;
import net.shaddii.smartsorter.screen.StorageControllerScreen;
import net.shaddii.smartsorter.screen.StorageControllerScreenHandler;
import net.shaddii.smartsorter.screen.tabs.TabComponent;
import net.shaddii.smartsorter.util.ChestConfig;
import net.shaddii.smartsorter.util.ChestSortMode;
import net.shaddii.smartsorter.widget.ChestConfigPanel;
import net.shaddii.smartsorter.widget.ChestSelectorWidget;
import net.shaddii.smartsorter.widget.DropdownWidget;

public class ChestsTabComponent
extends TabComponent {
    private ChestSelectorWidget chestSelector;
    private ChestConfigPanel chestConfigPanel;
    private class_4185 sortAllButton;
    private DropdownWidget chestSortDropdown;
    private class_2338 lastSelectedChestPos = null;
    private long sortAllClickTime = 0L;
    private int sortedChestCount = 0;

    public ChestsTabComponent(StorageControllerScreen parent, StorageControllerScreenHandler handler) {
        super(parent, handler);
    }

    @Override
    protected void initWidgets() {
        this.sortAllButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Sort All"), btn -> this.handleSortAllChests()).method_46434(this.guiX + 75, this.guiY + 4, 30, 12).method_46431();
        this.parent.addWidget((class_339)this.sortAllButton);
        this.chestSortDropdown = new DropdownWidget(this.guiX + 75 + 30 + 2, this.guiY + 4, 55, 12, (class_2561)class_2561.method_43470((String)""));
        this.initSortDropdown();
        this.parent.addWidget(this.chestSortDropdown);
        this.initChestSelector();
        this.initConfigPanel();
    }

    private void initSortDropdown() {
        for (ChestSortMode mode : ChestSortMode.values()) {
            String tooltip = switch (mode) {
                default -> throw new MatchException(null, null);
                case ChestSortMode.PRIORITY -> "Priority - Sort by routing priority (1-10)";
                case ChestSortMode.NAME -> "Name - Sort alphabetically by chest name";
                case ChestSortMode.FULLNESS -> "Fullness - Sort by how full the chest is";
                case ChestSortMode.COORDINATES -> "Position - Sort by X, Y, Z coordinates";
            };
            this.chestSortDropdown.addEntry(mode.getDisplayName(), tooltip);
        }
        this.chestSortDropdown.setSelectedIndex(0);
        this.chestSortDropdown.setOnSelect(index -> {
            if (index >= 0 && index < ChestSortMode.values().length) {
                ChestSortMode mode = ChestSortMode.values()[index];
                if (this.chestSelector != null) {
                    this.chestSelector.setSortMode(mode);
                }
            }
        });
    }

    private void initChestSelector() {
        this.chestSelector = new ChestSelectorWidget(this.guiX + 8, this.guiY + 18, this.backgroundWidth - 16, 10, this.parent.method_64506(), this.parent);
        Map<class_2338, ChestConfig> configs = this.handler.getChestConfigs();
        this.chestSelector.updateChests(configs);
        if (this.lastSelectedChestPos != null && configs.containsKey(this.lastSelectedChestPos)) {
            this.restoreSelection(configs);
        }
        this.chestSelector.setOnSelectionChange(config -> {
            if (this.chestConfigPanel != null) {
                this.chestConfigPanel.setConfig((ChestConfig)config);
                this.lastSelectedChestPos = config != null ? config.position : null;
            }
        });
        this.chestSelector.setOnConfigUpdate(config -> {
            class_2338 editedChestPos = config.position;
            this.markDirty();
            this.handler.updateChestConfig(editedChestPos, (ChestConfig)config);
            this.updateChestDisplay(editedChestPos);
        });
    }

    private void initConfigPanel() {
        this.chestConfigPanel = new ChestConfigPanel(this.guiX + 8, this.guiY + 30, this.backgroundWidth - 16, 75, this.parent.method_64506());
        Map<class_2338, ChestConfig> configs = this.handler.getChestConfigs();
        int regularChestCount = (int)configs.values().stream().filter(c -> c.filterMode != ChestConfig.FilterMode.CUSTOM).count();
        this.chestConfigPanel.setMaxPriority(regularChestCount);
        ChestConfig selected = this.chestSelector.getSelectedChest();
        this.chestConfigPanel.setConfig(selected);
        if (selected != null) {
            this.lastSelectedChestPos = selected.position;
        }
        this.chestConfigPanel.setOnConfigUpdate(config -> {
            class_2338 editedChestPos = config.position;
            this.markDirty();
            this.handler.updateChestConfig(editedChestPos, (ChestConfig)config);
            this.updateChestDisplay(editedChestPos);
        });
    }

    private void restoreSelection(Map<class_2338, ChestConfig> configs) {
        ChestSortMode currentMode = this.chestSelector.getSortMode();
        ArrayList<ChestConfig> sortedList = new ArrayList<ChestConfig>(configs.values());
        sortedList.sort((a, b) -> a.getSortKey(currentMode).compareTo(b.getSortKey(currentMode)));
        for (int i = 0; i < sortedList.size(); ++i) {
            if (!((ChestConfig)sortedList.get((int)i)).position.equals((Object)this.lastSelectedChestPos)) continue;
            this.chestSelector.setSelectedIndex(i);
            break;
        }
    }

    private void updateChestDisplay(class_2338 editedChestPos) {
        Map<class_2338, ChestConfig> updatedConfigs = this.handler.getChestConfigs();
        this.chestSelector.updateChests(updatedConfigs);
        this.chestSelector.reselectChestByPos(editedChestPos);
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_51433(this.parent.method_64506(), "Chest Config", this.guiX + 8, this.guiY + 6, -12566464, false);
        if (this.chestSelector != null) {
            this.chestSelector.render(context, mouseX, mouseY, delta);
        }
        if (this.chestConfigPanel != null) {
            this.chestConfigPanel.setExternalDropdownOpen(this.chestSelector != null && this.chestSelector.isDropdownOpen());
            this.chestConfigPanel.method_25394(context, mouseX, mouseY, delta);
        }
        this.renderFloatingText(context);
        this.renderDropdowns(context, mouseX, mouseY);
    }

    private void renderFloatingText(class_332 context) {
        long timeSinceSortAll = System.currentTimeMillis() - this.sortAllClickTime;
        if (timeSinceSortAll < 2000L && this.sortedChestCount > 0) {
            float alpha = 1.0f - (float)timeSinceSortAll / 2000.0f;
            int yOffset = (int)(timeSinceSortAll / 20L);
            String sortedText = "\u2713 Sorted " + this.sortedChestCount + " chest" + (this.sortedChestCount > 1 ? "s" : "") + "!";
            float scale = 0.8f;
            int scaledWidth = (int)((float)this.parent.method_64506().method_1727(sortedText) * scale);
            int textX = this.guiX + this.backgroundWidth / 2 - scaledWidth / 2;
            int textY = this.guiY + 108 - yOffset;
            int color = (int)(alpha * 255.0f) << 24 | 0x55FF55;
            this.parent.drawScaledText(context, sortedText, textX, textY, scale, color);
        }
    }

    private void renderDropdowns(class_332 context, int mouseX, int mouseY) {
        if (this.chestSelector != null) {
            this.chestSelector.renderDropdownIfOpen(context, mouseX, mouseY);
        }
        if (this.chestSortDropdown != null && this.chestSortDropdown.isOpen()) {
            this.chestSortDropdown.renderDropdown(context, mouseX, mouseY);
        }
        if (this.chestConfigPanel != null) {
            this.chestConfigPanel.renderDropdownsOnly(context, mouseX, mouseY);
        }
    }

    public void renderTooltips(class_332 context, int mouseX, int mouseY) {
        if (!this.parent.isShiftDown()) {
            return;
        }
        if (this.sortAllButton != null && this.sortAllButton.method_25405((double)mouseX, (double)mouseY)) {
            List<class_2561> tooltip = Arrays.asList(class_2561.method_43470((String)"\u00a76Sort All Chests"), class_2561.method_43470((String)"\u00a77Moves all items from every"), class_2561.method_43470((String)"\u00a77chest into the network"));
            context.method_51434(this.parent.method_64506(), tooltip, mouseX, mouseY);
            return;
        }
        if (this.chestSortDropdown != null && this.chestSortDropdown.method_25405(mouseX, mouseY)) {
            List<class_2561> tooltip = Arrays.asList(class_2561.method_43470((String)"\u00a76Sort Order"), class_2561.method_43470((String)"\u00a77Changes how chests are"), class_2561.method_43470((String)"\u00a77ordered in the list"));
            context.method_51434(this.parent.method_64506(), tooltip, mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean configPanelClicked;
        if (this.chestSortDropdown != null) {
            if (this.chestSortDropdown.isOpen()) {
                if (this.chestSortDropdown.method_25405(mouseX, mouseY)) {
                    return this.chestSortDropdown.method_25402(mouseX, mouseY, button);
                }
                this.chestSortDropdown.close();
                return true;
            }
            if (this.chestSortDropdown.method_25405(mouseX, mouseY)) {
                return this.chestSortDropdown.method_25402(mouseX, mouseY, button);
            }
        }
        if (this.chestSelector != null && this.chestSelector.isDropdownOpen()) {
            DropdownWidget dropdown = this.chestSelector.dropdown;
            int dropdownY = dropdown.getDropdownY();
            int visibleEntries = Math.min(6, dropdown.getEntries().size());
            int dropdownHeight = visibleEntries * 12;
            if (mouseX >= (double)dropdown.method_46426() && mouseX < (double)(dropdown.method_46426() + dropdown.method_25368()) && mouseY >= (double)dropdownY && mouseY < (double)(dropdownY + dropdownHeight)) {
                return this.chestSelector.mouseClicked(mouseX, mouseY, button);
            }
            dropdown.close();
            return true;
        }
        boolean chestSelectorClicked = this.chestSelector != null && this.chestSelector.mouseClicked(mouseX, mouseY, button);
        boolean bl = configPanelClicked = this.chestConfigPanel != null && this.chestConfigPanel.method_25402(mouseX, mouseY, button);
        if (!configPanelClicked && this.chestConfigPanel != null) {
            this.chestConfigPanel.method_25365(false);
            this.parent.method_25395(null);
        }
        return chestSelectorClicked || configPanelClicked;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return false;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return false;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.chestSortDropdown != null && this.chestSortDropdown.isOpen() && this.chestSortDropdown.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        if (this.chestSelector != null && this.chestSelector.isDropdownOpen()) {
            return this.chestSelector.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        return this.chestConfigPanel != null && this.chestConfigPanel.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.chestSelector != null) {
            if (this.chestSelector.isCurrentlyRenaming()) {
                this.chestSelector.keyPressed(keyCode, scanCode, modifiers);
                return true;
            }
            if (this.chestSelector.keyPressed(keyCode, scanCode, modifiers)) {
                return true;
            }
        }
        if (this.chestConfigPanel != null) {
            return this.handleKeyPress(this.chestConfigPanel, keyCode, scanCode, modifiers);
        }
        return false;
    }

    @Override
    public boolean charTyped(char chr, int modifiers) {
        if (this.chestSelector != null && this.chestSelector.charTyped(chr, modifiers)) {
            return true;
        }
        if (this.chestConfigPanel != null) {
            return this.handleCharType(this.chestConfigPanel, chr, modifiers);
        }
        return false;
    }

    @Override
    public void markDirty() {
    }

    public void onPriorityUpdate() {
        Map<class_2338, ChestConfig> updatedConfigs = this.handler.getChestConfigs();
        if (this.chestConfigPanel != null) {
            int regularChestCount = (int)updatedConfigs.values().stream().filter(c -> c.filterMode != ChestConfig.FilterMode.CUSTOM).count();
            this.chestConfigPanel.setMaxPriority(regularChestCount);
        }
        if (this.chestSelector != null) {
            this.chestSelector.updateChests(updatedConfigs);
            if (this.lastSelectedChestPos != null && updatedConfigs.containsKey(this.lastSelectedChestPos)) {
                this.chestSelector.reselectChestByPos(this.lastSelectedChestPos);
                ChestConfig refreshedConfig = updatedConfigs.get(this.lastSelectedChestPos);
                if (this.chestConfigPanel != null && refreshedConfig != null) {
                    this.chestConfigPanel.setConfig(refreshedConfig);
                }
            }
        }
        this.markDirty();
    }

    public void handleSortThisChest(class_2338 chestPos) {
        if (chestPos == null) {
            return;
        }
        List<class_2338> singleChestList = List.of(chestPos);
        ClientPlayNetworking.send((class_8710)new SortChestsPayload(singleChestList));
        this.sortAllClickTime = System.currentTimeMillis();
        this.sortedChestCount = 1;
        this.parent.scheduleRefresh(500L);
    }

    private void handleSortAllChests() {
        Map<class_2338, ChestConfig> chestConfigs = this.handler.getChestConfigs();
        if (chestConfigs.isEmpty()) {
            return;
        }
        ArrayList<SortableDestination> destinations = new ArrayList<SortableDestination>();
        for (ChestConfig config : chestConfigs.values()) {
            if (config.filterMode == ChestConfig.FilterMode.CUSTOM) continue;
            boolean isOverflow = config.filterMode == ChestConfig.FilterMode.OVERFLOW;
            boolean isGeneral = config.filterMode == ChestConfig.FilterMode.NONE;
            destinations.add(new SortableDestination(config.position, config.priority, isOverflow, isGeneral));
        }
        destinations.sort(Comparator.comparing(SortableDestination::isOverflow).thenComparing(SortableDestination::isGeneral).thenComparingInt(SortableDestination::priority));
        List<class_2338> sortedPositions = destinations.stream().map(SortableDestination::pos).collect(Collectors.toList());
        if (sortedPositions.isEmpty()) {
            return;
        }
        ClientPlayNetworking.send((class_8710)new SortChestsPayload(sortedPositions));
        this.sortAllClickTime = System.currentTimeMillis();
        this.sortedChestCount = sortedPositions.size();
        this.parent.scheduleRefresh(1000L);
    }

    private record SortableDestination(class_2338 pos, int priority, boolean isOverflow, boolean isGeneral) {
    }
}

